/*
 * Decompiled with CFR 0.152.
 */
package org.pmw.tinylog.runtime;

import android.os.Process;
import dalvik.system.VMStack;
import java.lang.reflect.Method;
import org.pmw.tinylog.InternalLogger;
import org.pmw.tinylog.runtime.RuntimeDialect;

public final class AndroidRuntime
implements RuntimeDialect {
    private final Method stackTraceMethod;
    private final int stackTraceOffset;

    public AndroidRuntime() {
        StackTraceMethodInfo stackTraceMethodInfo = AndroidRuntime.getStackTraceMethod();
        if (stackTraceMethodInfo == null) {
            this.stackTraceMethod = null;
            this.stackTraceOffset = -1;
        } else {
            this.stackTraceMethod = stackTraceMethodInfo.method;
            this.stackTraceOffset = stackTraceMethodInfo.index;
        }
    }

    public String getProcessId() {
        return Integer.toString(Process.myPid());
    }

    public String getClassName(int n) {
        return this.getStackTraceElement(n + 1).getClassName();
    }

    public StackTraceElement getStackTraceElement(int n) {
        if (this.stackTraceMethod != null) {
            try {
                StackTraceElement[] stackTraceElementArray = new StackTraceElement[n + this.stackTraceOffset + 1];
                this.stackTraceMethod.invoke(null, Thread.currentThread(), stackTraceElementArray);
                return stackTraceElementArray[n + this.stackTraceOffset];
            }
            catch (Exception exception) {
                InternalLogger.warn(exception, "Failed to get stack trace from dalvik.system.VMStack");
            }
        }
        return new Throwable().getStackTrace()[n];
    }

    private static StackTraceMethodInfo getStackTraceMethod() {
        try {
            Method method = VMStack.class.getDeclaredMethod("fillStackTraceElements", Thread.class, StackTraceElement[].class);
            method.setAccessible(true);
            StackTraceElement[] stackTraceElementArray = new StackTraceElement[10];
            method.invoke(null, Thread.currentThread(), stackTraceElementArray);
            for (int i = 0; i < 10; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i];
                if (stackTraceElement == null || !AndroidRuntime.class.getName().equals(stackTraceElement.getClassName())) continue;
                return new StackTraceMethodInfo(method, i);
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static final class StackTraceMethodInfo {
        private final Method method;
        private final int index;

        private StackTraceMethodInfo(Method method, int n) {
            this.method = method;
            this.index = n;
        }
    }
}

