/*
 * Decompiled with CFR 0.152.
 */
package org.pmw.tinylog.runtime;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import org.pmw.tinylog.InternalLogger;
import org.pmw.tinylog.runtime.RuntimeDialect;
import sun.reflect.Reflection;

public final class JavaRuntime
implements RuntimeDialect {
    private final boolean hasSunReflection = JavaRuntime.hasSunReflection();
    private final Method stackTraceMethod = JavaRuntime.getStackTraceMethod();

    public String getProcessId() {
        String string = ManagementFactory.getRuntimeMXBean().getName();
        int n = string.indexOf(64);
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public String getClassName(int n) {
        if (this.hasSunReflection) {
            try {
                Class clazz = Reflection.getCallerClass((int)(n + 1));
                return clazz.getName();
            }
            catch (Exception exception) {
                InternalLogger.warn(exception, "Failed to get caller class from sun.reflect.Reflection");
            }
        }
        return this.getStackTraceElement(n + 1).getClassName();
    }

    public StackTraceElement getStackTraceElement(int n) {
        if (this.stackTraceMethod != null) {
            try {
                return (StackTraceElement)this.stackTraceMethod.invoke((Object)new Throwable(), n);
            }
            catch (Exception exception) {
                InternalLogger.warn(exception, "Failed to get single stack trace element from throwable");
            }
        }
        return new Throwable().getStackTrace()[n];
    }

    private static boolean hasSunReflection() {
        try {
            Class clazz = Reflection.getCallerClass((int)1);
            return JavaRuntime.class.equals((Object)clazz);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static Method getStackTraceMethod() {
        try {
            Method method = Throwable.class.getDeclaredMethod("getStackTraceElement", Integer.TYPE);
            method.setAccessible(true);
            StackTraceElement stackTraceElement = (StackTraceElement)method.invoke((Object)new Throwable(), 0);
            if (JavaRuntime.class.getName().equals(stackTraceElement.getClassName())) {
                return method;
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

