/*
 * Decompiled with CFR 0.152.
 */
package org.pmw.tinylog.writers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.EnumSet;
import java.util.Set;
import org.pmw.tinylog.Configuration;
import org.pmw.tinylog.EnvironmentHelper;
import org.pmw.tinylog.InternalLogger;
import org.pmw.tinylog.LogEntry;
import org.pmw.tinylog.writers.LogEntryValue;
import org.pmw.tinylog.writers.PathResolver;
import org.pmw.tinylog.writers.PropertiesSupport;
import org.pmw.tinylog.writers.Property;
import org.pmw.tinylog.writers.VMShutdownHook;
import org.pmw.tinylog.writers.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PropertiesSupport(name="sharedfile", properties={@Property(name="filename", type=String.class), @Property(name="append", type=boolean.class, optional=true)})
public final class SharedFileWriter
implements Writer {
    private final File file;
    private final boolean append;
    private final Object mutex;
    private FileOutputStream stream;

    public SharedFileWriter(String string) {
        this(string, false);
    }

    public SharedFileWriter(String string, boolean bl) {
        this.file = new File(PathResolver.resolve(string));
        this.mutex = new Object();
        if (bl || EnvironmentHelper.isWindows()) {
            this.append = bl;
        } else {
            InternalLogger.warn("Shared file writer supports starting new log files only on Windows. Therefore \"append\" will be set automatically to \"true\".");
            this.append = true;
        }
    }

    @Override
    public Set<LogEntryValue> getRequiredLogEntryValues() {
        return EnumSet.of(LogEntryValue.RENDERED_LOG_ENTRY);
    }

    public String getFilename() {
        return this.file.getAbsolutePath();
    }

    public boolean isAppending() {
        return this.append;
    }

    @Override
    public void init(Configuration configuration) throws IOException {
        if (this.file.isFile()) {
            if (!this.append) {
                this.file.delete();
            }
        } else {
            EnvironmentHelper.makeDirectories(this.file);
        }
        this.stream = new FileOutputStream(this.file, true);
        VMShutdownHook.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(LogEntry logEntry) throws IOException {
        FileChannel fileChannel = this.stream.getChannel();
        byte[] byArray = logEntry.getRenderedLogEntry().getBytes();
        Object object = this.mutex;
        synchronized (object) {
            FileLock fileLock = fileChannel.lock();
            try {
                this.stream.write(byArray);
            }
            finally {
                fileLock.release();
            }
        }
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            VMShutdownHook.unregister(this);
            this.stream.close();
        }
    }
}

