/*
 * Decompiled with CFR 0.152.
 */
package pink.madis.apk.arsc;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import pink.madis.apk.arsc.AutoValue_LibraryChunk_Entry;
import pink.madis.apk.arsc.Chunk;
import pink.madis.apk.arsc.PackageUtils;
import pink.madis.apk.arsc.SerializableResource;

public final class LibraryChunk
extends Chunk {
    private final int entryCount;
    private final List<Entry> entries = new ArrayList<Entry>();

    protected LibraryChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
        this.entryCount = buffer.getInt();
    }

    @Override
    protected void init(ByteBuffer buffer) {
        super.init(buffer);
        this.entries.addAll(this.enumerateEntries(buffer));
    }

    private List<Entry> enumerateEntries(ByteBuffer buffer) {
        int offset;
        ArrayList<Entry> result = new ArrayList<Entry>(this.entryCount);
        int endOffset = offset + 260 * this.entryCount;
        for (offset = this.offset + this.getHeaderSize(); offset < endOffset; offset += 260) {
            result.add(Entry.create(buffer, offset));
        }
        return result;
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.TABLE_LIBRARY;
    }

    @Override
    protected void writeHeader(ByteBuffer output) {
        super.writeHeader(output);
        output.putInt(this.entries.size());
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, boolean shrink) throws IOException {
        for (Entry entry : this.entries) {
            output.write(entry.toByteArray(shrink));
        }
    }

    protected static abstract class Entry
    implements SerializableResource {
        protected Entry() {
        }

        public abstract int packageId();

        public abstract String packageName();

        static Entry create(ByteBuffer buffer, int offset) {
            int packageId = buffer.getInt(offset);
            String packageName = PackageUtils.readPackageName(buffer, offset + 4);
            return new AutoValue_LibraryChunk_Entry(packageId, packageName);
        }

        @Override
        public byte[] toByteArray() throws IOException {
            return this.toByteArray(false);
        }

        @Override
        public byte[] toByteArray(boolean shrink) throws IOException {
            ByteBuffer buffer = ByteBuffer.allocate(260).order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.packageId());
            PackageUtils.writePackageName(buffer, this.packageName());
            return buffer.array();
        }
    }
}

