/*
 * Decompiled with CFR 0.152.
 */
package pink.madis.apk.arsc;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import pink.madis.apk.arsc.Chunk;
import pink.madis.apk.arsc.ChunkWithChunks;
import pink.madis.apk.arsc.PackageUtils;
import pink.madis.apk.arsc.StringPoolChunk;
import pink.madis.apk.arsc.TypeChunk;
import pink.madis.apk.arsc.TypeSpecChunk;

public final class PackageChunk
extends ChunkWithChunks {
    private final int id;
    private final String packageName;
    private final int typeStringsOffset;
    private final int lastPublicType;
    private final int keyStringsOffset;
    private final int lastPublicKey;
    private final byte[] headerBlob;
    private final Map<Integer, TypeSpecChunk> typeSpecs = new HashMap<Integer, TypeSpecChunk>();
    private final Multimap<Integer, TypeChunk> types = HashMultimap.create();

    protected PackageChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
        this.id = buffer.getInt();
        this.packageName = PackageUtils.readPackageName(buffer, buffer.position());
        this.typeStringsOffset = buffer.getInt();
        this.lastPublicType = buffer.getInt();
        this.keyStringsOffset = buffer.getInt();
        this.lastPublicKey = buffer.getInt();
        int blobSz = this.getHeaderSize() - 284;
        Preconditions.checkState(blobSz >= 0, String.format("Header smaller than expected! Expected: %d got: %d", 284, this.getHeaderSize()));
        this.headerBlob = new byte[blobSz];
        buffer.get(this.headerBlob, 0, blobSz);
    }

    @Override
    protected void init(ByteBuffer buffer) {
        super.init(buffer);
        for (Chunk chunk : this.getChunks().values()) {
            if (chunk instanceof TypeChunk) {
                TypeChunk typeChunk = (TypeChunk)chunk;
                this.types.put(typeChunk.getId(), typeChunk);
                continue;
            }
            if (chunk instanceof TypeSpecChunk) {
                TypeSpecChunk typeSpecChunk = (TypeSpecChunk)chunk;
                this.typeSpecs.put(typeSpecChunk.getId(), typeSpecChunk);
                continue;
            }
            if (chunk instanceof StringPoolChunk) continue;
            throw new IllegalStateException(String.format("PackageChunk contains an unexpected chunk: %s", chunk.getClass()));
        }
    }

    public int getId() {
        return this.id;
    }

    public StringPoolChunk getKeyStringPool() {
        Chunk chunk = Preconditions.checkNotNull(this.getChunks().get(this.keyStringsOffset + this.offset));
        Preconditions.checkState(chunk instanceof StringPoolChunk, "Key string pool not found.");
        return (StringPoolChunk)chunk;
    }

    public StringPoolChunk getTypeStringPool() {
        Chunk chunk = Preconditions.checkNotNull(this.getChunks().get(this.typeStringsOffset + this.offset));
        Preconditions.checkState(chunk instanceof StringPoolChunk, "Type string pool not found.");
        return (StringPoolChunk)chunk;
    }

    public Collection<TypeChunk> getTypeChunks() {
        return this.types.values();
    }

    public Collection<TypeChunk> getTypeChunks(int id) {
        return this.types.get(id);
    }

    public Collection<TypeChunk> getTypeChunks(String type) {
        StringPoolChunk typeStringPool = Preconditions.checkNotNull(this.getTypeStringPool());
        return this.getTypeChunks(typeStringPool.indexOf(type) + 1);
    }

    public Collection<TypeSpecChunk> getTypeSpecChunks() {
        return this.typeSpecs.values();
    }

    public TypeSpecChunk getTypeSpecChunk(int id) {
        return Preconditions.checkNotNull(this.typeSpecs.get(id));
    }

    public TypeSpecChunk getTypeSpecChunk(String type) {
        StringPoolChunk typeStringPool = Preconditions.checkNotNull(this.getTypeStringPool());
        return this.getTypeSpecChunk(typeStringPool.indexOf(type) + 1);
    }

    public String getPackageName() {
        return this.packageName;
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.TABLE_PACKAGE;
    }

    @Override
    protected void writeHeader(ByteBuffer output) {
        output.putInt(this.id);
        PackageUtils.writePackageName(output, this.packageName);
        output.putInt(0);
        output.putInt(this.lastPublicType);
        output.putInt(0);
        output.putInt(this.lastPublicKey);
        output.put(this.headerBlob);
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, boolean shrink) throws IOException {
        int typeOffset = this.typeStringsOffset;
        int keyOffset = this.keyStringsOffset;
        int payloadOffset = 0;
        for (Chunk chunk : this.getChunks().values()) {
            if (chunk == this.getTypeStringPool()) {
                typeOffset = payloadOffset + this.getHeaderSize();
            } else if (chunk == this.getKeyStringPool()) {
                keyOffset = payloadOffset + this.getHeaderSize();
            }
            byte[] chunkBytes = chunk.toByteArray(shrink);
            output.write(chunkBytes);
            payloadOffset = this.writePad(output, chunkBytes.length);
        }
        header.putInt(268, typeOffset);
        header.putInt(276, keyOffset);
    }
}

