/*
 * Decompiled with CFR 0.152.
 */
package pink.madis.apk.arsc;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import pink.madis.apk.arsc.Chunk;
import pink.madis.apk.arsc.SerializableResource;

public final class ResourceFile
implements SerializableResource {
    private final List<Chunk> chunks = new ArrayList<Chunk>();

    public ResourceFile(byte[] buf) {
        ByteBuffer buffer = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
        while (buffer.remaining() > 0) {
            this.chunks.add(Chunk.newInstance(buffer));
        }
    }

    public static ResourceFile fromInputStream(InputStream is) throws IOException {
        byte[] buf = ByteStreams.toByteArray(is);
        return new ResourceFile(buf);
    }

    public List<Chunk> getChunks() {
        return Collections.unmodifiableList(this.chunks);
    }

    @Override
    public byte[] toByteArray() throws IOException {
        return this.toByteArray(false);
    }

    @Override
    public byte[] toByteArray(boolean shrink) throws IOException {
        ByteArrayDataOutput output = ByteStreams.newDataOutput();
        for (Chunk chunk : this.chunks) {
            output.write(chunk.toByteArray(shrink));
        }
        return output.toByteArray();
    }
}

