/*
 * Decompiled with CFR 0.152.
 */
package pink.madis.apk.arsc;

import com.google.common.base.Preconditions;
import pink.madis.apk.arsc.AutoValue_ResourceIdentifier;

public abstract class ResourceIdentifier {
    public abstract int packageId();

    public abstract int typeId();

    public abstract int entryId();

    public static ResourceIdentifier create(int resourceId) {
        int packageId = (resourceId & 0xFF000000) >>> 24;
        int typeId = (resourceId & 0xFF0000) >>> 16;
        int entryId = (resourceId & 0xFFFF) >>> 0;
        return ResourceIdentifier.create(packageId, typeId, entryId);
    }

    public static ResourceIdentifier create(int packageId, int typeId, int entryId) {
        Preconditions.checkState((packageId & 0xFF) == packageId, "packageId must be <= 0xFF.");
        Preconditions.checkState((typeId & 0xFF) == typeId, "typeId must be <= 0xFF.");
        Preconditions.checkState((entryId & 0xFFFF) == entryId, "entryId must be <= 0xFFFF.");
        return new AutoValue_ResourceIdentifier(packageId, typeId, entryId);
    }
}

