/*
 * Decompiled with CFR 0.152.
 */
package pink.madis.apk.arsc;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import pink.madis.apk.arsc.Chunk;
import pink.madis.apk.arsc.ChunkWithChunks;
import pink.madis.apk.arsc.PackageChunk;
import pink.madis.apk.arsc.StringPoolChunk;

public final class ResourceTableChunk
extends ChunkWithChunks {
    private StringPoolChunk stringPool;
    private final Map<String, PackageChunk> packages = new HashMap<String, PackageChunk>();

    protected ResourceTableChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
        Preconditions.checkState(buffer.getInt() >= 1, "ResourceTableChunk package count was < 1.");
    }

    @Override
    protected void init(ByteBuffer buffer) {
        super.init(buffer);
        this.packages.clear();
        for (Chunk chunk : this.getChunks().values()) {
            if (chunk instanceof PackageChunk) {
                PackageChunk packageChunk = (PackageChunk)chunk;
                this.packages.put(packageChunk.getPackageName(), packageChunk);
                continue;
            }
            if (!(chunk instanceof StringPoolChunk)) continue;
            this.stringPool = (StringPoolChunk)chunk;
        }
        Preconditions.checkNotNull(this.stringPool, "ResourceTableChunk must have a string pool.");
    }

    public StringPoolChunk getStringPool() {
        return this.stringPool;
    }

    @Nullable
    public PackageChunk getPackage(String packageName) {
        return this.packages.get(packageName);
    }

    public Collection<PackageChunk> getPackages() {
        return Collections.unmodifiableCollection(this.packages.values());
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.TABLE;
    }

    @Override
    protected void writeHeader(ByteBuffer output) {
        super.writeHeader(output);
        output.putInt(this.packages.size());
    }
}

