/*
 * Decompiled with CFR 0.152.
 */
package pink.madis.apk.arsc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedBytes;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import pink.madis.apk.arsc.AutoValue_ResourceValue;
import pink.madis.apk.arsc.SerializableResource;

public abstract class ResourceValue
implements SerializableResource {
    public static final int SIZE = 8;

    public abstract int size();

    public abstract Type type();

    public abstract int data();

    public static ResourceValue create(ByteBuffer buffer) {
        int size = buffer.getShort() & 0xFFFF;
        buffer.get();
        Type type = Type.fromCode(buffer.get());
        int data = buffer.getInt();
        return new AutoValue_ResourceValue(size, type, data);
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(false);
    }

    @Override
    public byte[] toByteArray(boolean shrink) {
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putShort((short)this.size());
        buffer.put((byte)0);
        buffer.put(this.type().code());
        buffer.putInt(this.data());
        return buffer.array();
    }

    public static enum Type {
        NULL(0),
        REFERENCE(1),
        ATTRIBUTE(2),
        STRING(3),
        FLOAT(4),
        DIMENSION(5),
        FRACTION(6),
        DYNAMIC_REFERENCE(7),
        INT_DEC(16),
        INT_HEX(17),
        INT_BOOLEAN(18),
        INT_COLOR_ARGB8(28),
        INT_COLOR_RGB8(29),
        INT_COLOR_ARGB4(30),
        INT_COLOR_RGB4(31);

        private final byte code;
        private static final Map<Byte, Type> FROM_BYTE;

        private Type(int code) {
            this.code = UnsignedBytes.checkedCast(code);
        }

        public byte code() {
            return this.code;
        }

        public static Type fromCode(byte code) {
            return Preconditions.checkNotNull(FROM_BYTE.get(code), "Unknown resource type: %s", code);
        }

        static {
            ImmutableMap.Builder<Byte, Type> builder = ImmutableMap.builder();
            for (Type type : Type.values()) {
                builder.put(type.code(), type);
            }
            FROM_BYTE = builder.build();
        }
    }
}

