/*
 * Decompiled with CFR 0.152.
 */
package pink.madis.apk.arsc;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import pink.madis.apk.arsc.AutoValue_XmlAttribute;
import pink.madis.apk.arsc.ResourceValue;
import pink.madis.apk.arsc.SerializableResource;
import pink.madis.apk.arsc.XmlNodeChunk;

public abstract class XmlAttribute
implements SerializableResource {
    public static final int SIZE = 20;

    public abstract int namespaceIndex();

    public abstract int nameIndex();

    public abstract int rawValueIndex();

    public abstract ResourceValue typedValue();

    public abstract XmlNodeChunk parent();

    public final String namespace() {
        return this.getString(this.namespaceIndex());
    }

    public final String name() {
        return this.getString(this.nameIndex());
    }

    public final String rawValue() {
        return this.getString(this.rawValueIndex());
    }

    public static XmlAttribute create(ByteBuffer buffer, XmlNodeChunk parent) {
        int namespace = buffer.getInt();
        int name = buffer.getInt();
        int rawValue = buffer.getInt();
        ResourceValue typedValue = ResourceValue.create(buffer);
        return new AutoValue_XmlAttribute(namespace, name, rawValue, typedValue, parent);
    }

    private String getString(int index) {
        return this.parent().getString(index);
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(false);
    }

    @Override
    public byte[] toByteArray(boolean shrink) {
        ByteBuffer buffer = ByteBuffer.allocate(20).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(this.namespaceIndex());
        buffer.putInt(this.nameIndex());
        buffer.putInt(this.rawValueIndex());
        buffer.put(this.typedValue().toByteArray(shrink));
        return buffer.array();
    }

    public String toString() {
        return String.format("XmlAttribute{namespace=%s, name=%s, value=%s}", this.namespace(), this.name(), this.rawValue());
    }
}

