/*
 * Decompiled with CFR 0.152.
 */
package pink.madis.apk.arsc;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import pink.madis.apk.arsc.Chunk;
import pink.madis.apk.arsc.ResourceValue;
import pink.madis.apk.arsc.XmlNodeChunk;

public final class XmlCdataChunk
extends XmlNodeChunk {
    private final int rawValue;
    private final ResourceValue resourceValue;

    protected XmlCdataChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
        this.rawValue = buffer.getInt();
        this.resourceValue = ResourceValue.create(buffer);
    }

    public String getRawValue() {
        return this.getString(this.rawValue);
    }

    public ResourceValue getResourceValue() {
        return this.resourceValue;
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.XML_CDATA;
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, boolean shrink) throws IOException {
        super.writePayload(output, header, shrink);
        output.writeInt(this.rawValue);
        output.write(this.resourceValue.toByteArray());
    }

    @Override
    public String toString() {
        return String.format("XmlCdataChunk{line=%d, comment=%s, value=%s}", this.getLineNumber(), this.getComment(), this.getRawValue());
    }
}

