/*
 * Decompiled with CFR 0.152.
 */
package pink.madis.apk.arsc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import pink.madis.apk.arsc.Chunk;
import pink.madis.apk.arsc.XmlChunk;

public abstract class XmlNodeChunk
extends Chunk {
    private final int lineNumber;
    private final int comment;

    protected XmlNodeChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
        this.lineNumber = buffer.getInt();
        this.comment = buffer.getInt();
    }

    public boolean hasComment() {
        return this.comment != -1;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getComment() {
        return this.getString(this.comment);
    }

    protected String getString(int index) {
        if (index == -1) {
            return "";
        }
        for (Chunk parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof XmlChunk)) continue;
            return ((XmlChunk)parent).getString(index);
        }
        throw new IllegalStateException("XmlNodeChunk did not have an XmlChunk parent.");
    }

    @Override
    protected final void writeHeader(ByteBuffer output) {
        super.writeHeader(output);
        output.putInt(this.lineNumber);
        output.putInt(this.comment);
    }

    public String toString() {
        return String.format("XmlNodeChunk{line=%d, comment=%s}", this.getLineNumber(), this.getComment());
    }
}

