/*
 * Decompiled with CFR 0.152.
 */
package pink.madis.apk.arsc;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import pink.madis.apk.arsc.Chunk;
import pink.madis.apk.arsc.ResourceIdentifier;

public class XmlResourceMapChunk
extends Chunk {
    private final List<Integer> resources = new ArrayList<Integer>();

    protected XmlResourceMapChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
    }

    @Override
    protected void init(ByteBuffer buffer) {
        super.init(buffer);
        this.resources.addAll(this.enumerateResources(buffer));
    }

    private List<Integer> enumerateResources(ByteBuffer buffer) {
        int resourceCount = (this.getOriginalChunkSize() - this.getHeaderSize()) / 4;
        ArrayList<Integer> result = new ArrayList<Integer>(resourceCount);
        int offset = this.offset + this.getHeaderSize();
        buffer.mark();
        buffer.position(offset);
        for (int i = 0; i < resourceCount; ++i) {
            result.add(buffer.getInt());
        }
        buffer.reset();
        return result;
    }

    public ResourceIdentifier getResourceId(int attributeId) {
        return ResourceIdentifier.create(this.resources.get(attributeId));
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.XML_RESOURCE_MAP;
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, boolean shrink) throws IOException {
        super.writePayload(output, header, shrink);
        for (Integer resource : this.resources) {
            output.writeInt(resource);
        }
    }
}

