/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.JadxDecompiler;
import jadx.api.ResourceFile;
import jadx.api.ResourceType;
import jadx.core.codegen.CodeWriter;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.files.FileUtils;
import jadx.core.utils.files.InputFile;
import jadx.core.utils.files.ZipSecurity;
import jadx.core.xmlgen.ResContainer;
import jadx.core.xmlgen.ResTableParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourcesLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcesLoader.class);
    private static final int LOAD_SIZE_LIMIT = 0xA00000;
    private final JadxDecompiler jadxRef;

    ResourcesLoader(JadxDecompiler jadxRef) {
        this.jadxRef = jadxRef;
    }

    List<ResourceFile> load(List<InputFile> inputFiles) {
        ArrayList<ResourceFile> list = new ArrayList<ResourceFile>(inputFiles.size());
        for (InputFile file : inputFiles) {
            this.loadFile(list, file.getFile());
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    public static ResContainer decodeStream(ResourceFile rf, ResourceDecoder decoder) throws JadxException {
        block16: {
            block15: {
                block17: {
                    zipFile = null;
                    inputStream = null;
                    zipRef = rf.getZipRef();
                    if (zipRef != null) break block17;
                    file = new File(rf.getName());
                    inputStream = new BufferedInputStream(new FileInputStream(file));
                    size = file.length();
                    ** GOTO lbl29
                }
                zipFile = new ZipFile(zipRef.getZipFile());
                entry = zipFile.getEntry(zipRef.getEntryName());
                if (ZipSecurity.isValidZipEntry(entry)) break block15;
                var9_10 = null;
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (Exception e) {
                    ResourcesLoader.LOG.error("Error close zip file: {}", (Object)rf.getName(), (Object)e);
                }
                FileUtils.close(inputStream);
                return var9_10;
            }
            if (entry == null) {
                throw new IOException("Zip entry not found: " + zipRef);
            }
            inputStream = new BufferedInputStream(zipFile.getInputStream(entry));
            size = entry.getSize();
lbl29:
            // 2 sources

            result = decoder.decode(size, inputStream);
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
                break block16;
            }
            catch (Exception e) {
                ResourcesLoader.LOG.error("Error close zip file: {}", (Object)rf.getName(), (Object)e);
            }
            break block16;
            catch (Exception e) {
                try {
                    throw new JadxException("Error decode: " + rf.getName(), e);
                }
                catch (Throwable var11_13) {
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                    }
                    catch (Exception e) {
                        ResourcesLoader.LOG.error("Error close zip file: {}", (Object)rf.getName(), (Object)e);
                    }
                    FileUtils.close(inputStream);
                    throw var11_13;
                }
            }
        }
        FileUtils.close(inputStream);
        return result;
    }

    static ResContainer loadContent(JadxDecompiler jadxRef, ResourceFile rf) {
        try {
            return ResourcesLoader.decodeStream(rf, (size, is) -> ResourcesLoader.loadContent(jadxRef, rf, is, size));
        }
        catch (JadxException e) {
            LOG.error("Decode error", (Throwable)e);
            CodeWriter cw = new CodeWriter();
            cw.add("Error decode ").add(rf.getType().toString().toLowerCase());
            cw.startLine(Utils.getStackTrace(e.getCause()));
            return ResContainer.singleFile(rf.getName(), cw);
        }
    }

    private static ResContainer loadContent(JadxDecompiler jadxRef, ResourceFile rf, InputStream inputStream, long size) throws IOException {
        switch (rf.getType()) {
            case MANIFEST: 
            case XML: {
                return ResContainer.singleFile(rf.getName(), jadxRef.getXmlParser().parse(inputStream));
            }
            case ARSC: {
                return new ResTableParser().decodeFiles(inputStream);
            }
            case IMG: {
                return ResContainer.singleImageFile(rf.getName(), inputStream);
            }
        }
        if (size > 0xA00000L) {
            return ResContainer.singleFile(rf.getName(), new CodeWriter().add("File too big, size: " + String.format("%.2f KB", (double)size / 1024.0)));
        }
        return ResContainer.singleFile(rf.getName(), ResourcesLoader.loadToCodeWriter(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile(List<ResourceFile> list, File file) {
        if (file == null) {
            return;
        }
        ZipFile zip = null;
        try {
            zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!ZipSecurity.isValidZipEntry(entry)) continue;
                this.addEntry(list, file, entry);
            }
        }
        catch (IOException e) {
            LOG.debug("Not a zip file: {}", (Object)file.getAbsolutePath());
            this.addResourceFile(list, file);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (Exception e) {
                    LOG.error("Zip file close error: {}", (Object)file.getAbsolutePath(), (Object)e);
                }
            }
        }
    }

    private void addResourceFile(List<ResourceFile> list, File file) {
        ResourceType type;
        String name = file.getAbsolutePath();
        ResourceFile rf = ResourceFile.createResourceFileInstance(this.jadxRef, name, type = ResourceType.getFileType(name));
        if (rf != null) {
            list.add(rf);
        }
    }

    private void addEntry(List<ResourceFile> list, File zipFile, ZipEntry entry) {
        ResourceType type;
        if (entry.isDirectory()) {
            return;
        }
        String name = entry.getName();
        ResourceFile rf = ResourceFile.createResourceFileInstance(this.jadxRef, name, type = ResourceType.getFileType(name));
        if (rf != null) {
            rf.setZipRef(new ResourceFile.ZipRef(zipFile, name));
            list.add(rf);
        }
    }

    public static CodeWriter loadToCodeWriter(InputStream is) throws IOException {
        CodeWriter cw = new CodeWriter();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        FileUtils.copyStream(is, baos);
        cw.add(baos.toString("UTF-8"));
        return cw;
    }

    public static interface ResourceDecoder {
        public ResContainer decode(long var1, InputStream var3) throws IOException;
    }
}

