/*
 * Decompiled with CFR 0.152.
 */
package jadx.core;

import jadx.core.codegen.CodeGen;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.ProcessState;
import jadx.core.dex.visitors.DepthTraversal;
import jadx.core.dex.visitors.IDexTreeVisitor;
import jadx.core.utils.ErrorsCounter;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class ProcessClass {
    private ProcessClass() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void process(ClassNode cls, List<IDexTreeVisitor> passes, @Nullable CodeGen codeGen) {
        if (codeGen == null && cls.getState() == ProcessState.PROCESSED) {
            return;
        }
        ClassInfo classInfo = cls.getClassInfo();
        synchronized (classInfo) {
            try {
                if (cls.getState() == ProcessState.NOT_LOADED) {
                    cls.load();
                    cls.setState(ProcessState.STARTED);
                    for (IDexTreeVisitor visitor : passes) {
                        DepthTraversal.visit(visitor, cls);
                    }
                    cls.setState(ProcessState.PROCESSED);
                }
                if (cls.getState() == ProcessState.PROCESSED && codeGen != null) {
                    ProcessClass.processDependencies(cls, passes);
                    codeGen.visit(cls);
                    cls.setState(ProcessState.GENERATED);
                }
            }
            catch (Exception e) {
                ErrorsCounter.classError(cls, e.getClass().getSimpleName(), e);
            }
            finally {
                if (cls.getState() == ProcessState.GENERATED) {
                    cls.unload();
                    cls.setState(ProcessState.UNLOADED);
                }
            }
        }
    }

    private static void processDependencies(ClassNode cls, List<IDexTreeVisitor> passes) {
        for (ClassNode depCls : cls.getDependencies()) {
            ProcessClass.process(depCls, passes, null);
        }
    }
}

