/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import com.android.dex.ClassData;
import com.android.dex.Code;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.JumpInfo;
import jadx.core.dex.attributes.nodes.LineAttrNode;
import jadx.core.dex.attributes.nodes.LoopInfo;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.GotoNode;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.InsnDecoder;
import jadx.core.dex.instructions.SwitchNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.instructions.args.TypeImmutableArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.IDexNode;
import jadx.core.dex.nodes.ILoadable;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.nodes.parser.SignatureParser;
import jadx.core.dex.regions.Region;
import jadx.core.dex.trycatch.ExcHandlerAttr;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.trycatch.TryCatchBlock;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.DecodeException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodNode
extends LineAttrNode
implements ILoadable,
IDexNode {
    private static final Logger LOG = LoggerFactory.getLogger(MethodNode.class);
    private final MethodInfo mthInfo;
    private final ClassNode parentClass;
    private final AccessInfo accFlags;
    private final ClassData.Method methodData;
    private int regsCount;
    private InsnNode[] instructions;
    private int codeSize;
    private int debugInfoOffset;
    private boolean noCode;
    private boolean methodIsVirtual;
    private ArgType retType;
    private RegisterArg thisArg;
    private List<RegisterArg> argsList;
    private List<SSAVar> sVars = Collections.emptyList();
    private Map<ArgType, List<ArgType>> genericMap;
    private List<BlockNode> blocks;
    private BlockNode enterBlock;
    private List<BlockNode> exitBlocks;
    private Region region;
    private List<ExceptionHandler> exceptionHandlers = Collections.emptyList();
    private List<LoopInfo> loops = Collections.emptyList();

    public MethodNode(ClassNode classNode, ClassData.Method mthData, boolean isVirtual) {
        this.mthInfo = MethodInfo.fromDex(classNode.dex(), mthData.getMethodIndex());
        this.parentClass = classNode;
        this.accFlags = new AccessInfo(mthData.getAccessFlags(), AccessInfo.AFType.METHOD);
        this.noCode = mthData.getCodeOffset() == 0;
        this.methodData = this.noCode ? null : mthData;
        this.methodIsVirtual = isVirtual;
    }

    @Override
    public void load() throws DecodeException {
        try {
            if (this.noCode) {
                this.regsCount = 0;
                this.codeSize = 0;
                this.initMethodTypes();
                return;
            }
            DexNode dex = this.parentClass.dex();
            Code mthCode = dex.readCode(this.methodData);
            this.regsCount = mthCode.getRegistersSize();
            this.initMethodTypes();
            InsnDecoder decoder = new InsnDecoder(this);
            decoder.decodeInsns(mthCode);
            this.instructions = decoder.process();
            this.codeSize = this.instructions.length;
            this.initTryCatches(mthCode);
            this.initJumps();
            this.debugInfoOffset = mthCode.getDebugInfoOffset();
        }
        catch (Exception e) {
            if (!this.noCode) {
                this.noCode = true;
                this.load();
                this.noCode = false;
            }
            throw new DecodeException(this, "Load method exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public void checkInstructions() {
        ArrayList<RegisterArg> list = new ArrayList<RegisterArg>();
        for (InsnNode insnNode : this.instructions) {
            if (insnNode == null) continue;
            list.clear();
            RegisterArg resultArg = insnNode.getResult();
            if (resultArg != null) {
                list.add(resultArg);
            }
            insnNode.getRegisterArgs(list);
            int argsCount = list.size();
            for (int i = 0; i < argsCount; ++i) {
                if (((RegisterArg)list.get(i)).getRegNum() < this.regsCount) continue;
                throw new JadxRuntimeException("Incorrect register number in instruction: " + insnNode + ", expected to be less than " + this.regsCount);
            }
        }
    }

    private void initMethodTypes() {
        if (!this.parseSignature()) {
            this.retType = this.mthInfo.getReturnType();
            this.initArguments(this.mthInfo.getArgumentsTypes());
        }
    }

    @Override
    public void unload() {
        if (this.noCode) {
            return;
        }
        this.instructions = null;
        this.blocks = null;
        this.exitBlocks = null;
        this.exceptionHandlers.clear();
    }

    private boolean parseSignature() {
        SignatureParser sp = SignatureParser.fromNode(this);
        if (sp == null) {
            return false;
        }
        try {
            this.genericMap = sp.consumeGenericMap();
            List<ArgType> argsTypes = sp.consumeMethodArgs();
            this.retType = sp.consumeType();
            List<ArgType> mthArgs = this.mthInfo.getArgumentsTypes();
            if (argsTypes.size() != mthArgs.size()) {
                if (argsTypes.isEmpty()) {
                    return false;
                }
                if (!this.mthInfo.isConstructor()) {
                    LOG.warn("Wrong signature parse result: {} -> {}, not generic version: {}", new Object[]{sp, argsTypes, mthArgs});
                    return false;
                }
                if (this.getParentClass().getAccessFlags().isEnum()) {
                    argsTypes.add(0, mthArgs.get(0));
                    argsTypes.add(1, mthArgs.get(1));
                } else {
                    argsTypes.add(0, mthArgs.get(0));
                }
                if (argsTypes.size() != mthArgs.size()) {
                    return false;
                }
            }
            this.initArguments(argsTypes);
        }
        catch (JadxRuntimeException e) {
            LOG.error("Method signature parse error: {}", (Object)this, (Object)e);
            return false;
        }
        return true;
    }

    private void initArguments(List<ArgType> args) {
        int pos;
        if (this.noCode) {
            pos = 1;
        } else {
            pos = this.regsCount;
            for (ArgType arg : args) {
                pos -= arg.getRegCount();
            }
        }
        if (this.accFlags.isStatic()) {
            this.thisArg = null;
        } else {
            TypeImmutableArg arg = InsnArg.typeImmutableReg(pos - 1, this.parentClass.getClassInfo().getType());
            arg.markAsThis();
            this.thisArg = arg;
        }
        if (args.isEmpty()) {
            this.argsList = Collections.emptyList();
            return;
        }
        this.argsList = new ArrayList<RegisterArg>(args.size());
        for (ArgType arg : args) {
            this.argsList.add(InsnArg.typeImmutableReg(pos, arg));
            pos += arg.getRegCount();
        }
    }

    public List<RegisterArg> getArguments(boolean includeThis) {
        if (includeThis && this.thisArg != null) {
            ArrayList<RegisterArg> list = new ArrayList<RegisterArg>(this.argsList.size() + 1);
            list.add(this.thisArg);
            list.addAll(this.argsList);
            return list;
        }
        return this.argsList;
    }

    public RegisterArg removeFirstArgument() {
        this.add(AFlag.SKIP_FIRST_ARG);
        return this.argsList.remove(0);
    }

    public RegisterArg getThisArg() {
        return this.thisArg;
    }

    public ArgType getReturnType() {
        return this.retType;
    }

    public Map<ArgType, List<ArgType>> getGenericMap() {
        return this.genericMap;
    }

    private void initTryCatches(Code mthCode) {
        Object[] insnByOffset = this.instructions;
        Code.CatchHandler[] catchBlocks = mthCode.getCatchHandlers();
        Code.Try[] tries = mthCode.getTries();
        if (catchBlocks.length == 0 && tries.length == 0) {
            return;
        }
        int hc = 0;
        HashSet<Integer> addrs = new HashSet<Integer>();
        ArrayList<TryCatchBlock> catches = new ArrayList<TryCatchBlock>(catchBlocks.length);
        for (Code.CatchHandler handler : catchBlocks) {
            TryCatchBlock tcBlock = new TryCatchBlock();
            catches.add(tcBlock);
            for (int i = 0; i < handler.getAddresses().length; ++i) {
                int addr = handler.getAddresses()[i];
                ClassInfo type = ClassInfo.fromDex(this.parentClass.dex(), handler.getTypeIndexes()[i]);
                tcBlock.addHandler(this, addr, type);
                addrs.add(addr);
                ++hc;
            }
            int addr = handler.getCatchAllAddress();
            if (addr < 0) continue;
            tcBlock.addHandler(this, addr, null);
            addrs.add(addr);
            ++hc;
        }
        if (hc > 0 && hc != addrs.size()) {
            for (TryCatchBlock ct1 : catches) {
                for (TryCatchBlock ct2 : catches) {
                    if (ct1 == ct2 || !ct2.containsAllHandlers(ct1)) continue;
                    for (ExceptionHandler h : ct1.getHandlers()) {
                        ct2.removeHandler(this, h);
                        h.setTryBlock(ct1);
                    }
                }
            }
        }
        addrs.clear();
        for (TryCatchBlock ct : catches) {
            for (ExceptionHandler eh : ct.getHandlers()) {
                int addr = eh.getHandleOffset();
                ExcHandlerAttr ehAttr = new ExcHandlerAttr(ct, eh);
                insnByOffset[addr].addAttr(ehAttr);
            }
        }
        for (Code.Try aTry : tries) {
            int catchNum = aTry.getCatchHandlerIndex();
            TryCatchBlock catchBlock = (TryCatchBlock)catches.get(catchNum);
            int offset = aTry.getStartAddress();
            int end = offset + aTry.getInstructionCount() - 1;
            InsnNode insn = insnByOffset[offset];
            insn.add(AFlag.TRY_ENTER);
            while (offset <= end && offset >= 0) {
                insn = insnByOffset[offset];
                catchBlock.addInsn(insn);
                offset = InsnDecoder.getNextInsnOffset(insnByOffset, offset);
            }
            if (insnByOffset[end] != null) {
                insnByOffset[end].add(AFlag.TRY_LEAVE);
                continue;
            }
            insn.add(AFlag.TRY_LEAVE);
        }
    }

    private void initJumps() {
        Object[] insnByOffset = this.instructions;
        block5: for (int offset = 0; offset < insnByOffset.length; ++offset) {
            InsnNode insn = insnByOffset[offset];
            if (insn == null) continue;
            switch (insn.getType()) {
                case SWITCH: {
                    SwitchNode sw = (SwitchNode)insn;
                    for (int target : sw.getTargets()) {
                        MethodNode.addJump((InsnNode[])insnByOffset, offset, target);
                    }
                    int nextInsnOffset = InsnDecoder.getNextInsnOffset(insnByOffset, offset);
                    if (nextInsnOffset == -1) continue block5;
                    MethodNode.addJump((InsnNode[])insnByOffset, offset, nextInsnOffset);
                    continue block5;
                }
                case IF: {
                    int next = InsnDecoder.getNextInsnOffset(insnByOffset, offset);
                    if (next != -1) {
                        MethodNode.addJump((InsnNode[])insnByOffset, offset, next);
                    }
                    MethodNode.addJump((InsnNode[])insnByOffset, offset, ((IfNode)insn).getTarget());
                    continue block5;
                }
                case GOTO: {
                    MethodNode.addJump((InsnNode[])insnByOffset, offset, ((GotoNode)insn).getTarget());
                    continue block5;
                }
            }
        }
    }

    private static void addJump(InsnNode[] insnByOffset, int offset, int target) {
        insnByOffset[target].addAttr(AType.JUMP, new JumpInfo(offset, target));
    }

    public String getName() {
        return this.mthInfo.getName();
    }

    public String getAlias() {
        return this.mthInfo.getAlias();
    }

    public ClassNode getParentClass() {
        return this.parentClass;
    }

    public boolean isNoCode() {
        return this.noCode;
    }

    public int getCodeSize() {
        return this.codeSize;
    }

    public InsnNode[] getInstructions() {
        return this.instructions;
    }

    public void unloadInsnArr() {
        this.instructions = null;
    }

    public void initBasicBlocks() {
        this.blocks = new ArrayList<BlockNode>();
        this.exitBlocks = new ArrayList<BlockNode>(1);
    }

    public void finishBasicBlocks() {
        ((ArrayList)this.blocks).trimToSize();
        ((ArrayList)this.exitBlocks).trimToSize();
        this.blocks = Collections.unmodifiableList(this.blocks);
        this.exitBlocks = Collections.unmodifiableList(this.exitBlocks);
        for (BlockNode block : this.blocks) {
            block.lock();
        }
    }

    public List<BlockNode> getBasicBlocks() {
        return this.blocks;
    }

    public BlockNode getEnterBlock() {
        return this.enterBlock;
    }

    public void setEnterBlock(BlockNode enterBlock) {
        this.enterBlock = enterBlock;
    }

    public List<BlockNode> getExitBlocks() {
        return this.exitBlocks;
    }

    public void addExitBlock(BlockNode exitBlock) {
        this.exitBlocks.add(exitBlock);
    }

    public void registerLoop(LoopInfo loop) {
        if (this.loops.isEmpty()) {
            this.loops = new ArrayList<LoopInfo>(5);
        }
        loop.setId(this.loops.size());
        this.loops.add(loop);
    }

    @Nullable
    public LoopInfo getLoopForBlock(BlockNode block) {
        if (this.loops.isEmpty()) {
            return null;
        }
        for (LoopInfo loop : this.loops) {
            if (!loop.getLoopBlocks().contains(block)) continue;
            return loop;
        }
        return null;
    }

    public List<LoopInfo> getAllLoopsForBlock(BlockNode block) {
        if (this.loops.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LoopInfo> list = new ArrayList<LoopInfo>(this.loops.size());
        for (LoopInfo loop : this.loops) {
            if (!loop.getLoopBlocks().contains(block)) continue;
            list.add(loop);
        }
        return list;
    }

    public int getLoopsCount() {
        return this.loops.size();
    }

    public Iterable<LoopInfo> getLoops() {
        return this.loops;
    }

    public ExceptionHandler addExceptionHandler(ExceptionHandler handler) {
        if (this.exceptionHandlers.isEmpty()) {
            this.exceptionHandlers = new ArrayList<ExceptionHandler>(2);
        } else {
            for (ExceptionHandler h : this.exceptionHandlers) {
                if (h != handler && h.getHandleOffset() != handler.getHandleOffset()) continue;
                return h;
            }
        }
        this.exceptionHandlers.add(handler);
        return handler;
    }

    public Iterable<ExceptionHandler> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public boolean isNoExceptionHandlers() {
        return this.exceptionHandlers.isEmpty();
    }

    public int getExceptionHandlersCount() {
        return this.exceptionHandlers.size();
    }

    public boolean isArgsOverload() {
        int argsCount = this.mthInfo.getArgumentsTypes().size();
        if (argsCount == 0) {
            return false;
        }
        String name = this.getName();
        for (MethodNode method : this.parentClass.getMethods()) {
            MethodInfo otherMthInfo = method.mthInfo;
            if (this == method || otherMthInfo.getArgumentsTypes().size() != argsCount || !otherMthInfo.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isDefaultConstructor() {
        boolean result = false;
        if (this.accFlags.isConstructor() && this.mthInfo.isConstructor()) {
            int defaultArgCount = 0;
            if (this.parentClass.getClassInfo().isInner() && !this.parentClass.getAccessFlags().isStatic()) {
                ClassNode outerCls = this.parentClass.getParentClass();
                if (this.argsList != null && !this.argsList.isEmpty() && this.argsList.get(0).getType().equals(outerCls.getClassInfo().getType())) {
                    defaultArgCount = 1;
                }
            }
            result = this.argsList == null || this.argsList.size() == defaultArgCount;
        }
        return result;
    }

    public boolean isVirtual() {
        return this.methodIsVirtual;
    }

    public int getRegsCount() {
        return this.regsCount;
    }

    public int getDebugInfoOffset() {
        return this.debugInfoOffset;
    }

    public SSAVar makeNewSVar(int regNum, int version, @NotNull RegisterArg assignArg) {
        SSAVar var = new SSAVar(regNum, version, assignArg);
        if (this.sVars.isEmpty()) {
            this.sVars = new ArrayList<SSAVar>();
        }
        this.sVars.add(var);
        return var;
    }

    public int getNextSVarVersion(int regNum) {
        int v = -1;
        for (SSAVar sVar : this.sVars) {
            if (sVar.getRegNum() != regNum) continue;
            v = Math.max(v, sVar.getVersion());
        }
        return ++v;
    }

    public void removeSVar(SSAVar var) {
        this.sVars.remove(var);
    }

    public List<SSAVar> getSVars() {
        return this.sVars;
    }

    public AccessInfo getAccessFlags() {
        return this.accFlags;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    @Override
    public DexNode dex() {
        return this.parentClass.dex();
    }

    @Override
    public RootNode root() {
        return this.dex().root();
    }

    public MethodInfo getMethodInfo() {
        return this.mthInfo;
    }

    public int hashCode() {
        return this.mthInfo.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MethodNode other = (MethodNode)obj;
        return this.mthInfo.equals(other.mthInfo);
    }

    public String toString() {
        return this.parentClass + "." + this.mthInfo.getName() + "(" + Utils.listToString(this.mthInfo.getArgumentsTypes()) + "):" + this.retType;
    }
}

