/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.instructions.mods.ConstructorInsn;
import jadx.core.dex.instructions.mods.TernaryInsn;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.EmptyBitSet;
import jadx.core.utils.InsnList;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class CodeShrinker
extends AbstractVisitor {
    @Override
    public void visit(MethodNode mth) {
        CodeShrinker.shrinkMethod(mth);
    }

    public static void shrinkMethod(MethodNode mth) {
        if (mth.isNoCode() || mth.contains(AFlag.DONT_SHRINK)) {
            return;
        }
        for (BlockNode block : mth.getBasicBlocks()) {
            CodeShrinker.shrinkBlock(mth, block);
            CodeShrinker.simplifyMoveInsns(block);
        }
    }

    private static void shrinkBlock(MethodNode mth, BlockNode block) {
        if (block.getInstructions().isEmpty()) {
            return;
        }
        InsnList insnList = new InsnList(block.getInstructions());
        int insnCount = insnList.size();
        ArrayList<ArgsInfo> argsList = new ArrayList<ArgsInfo>(insnCount);
        for (int i = 0; i < insnCount; ++i) {
            argsList.add(new ArgsInfo(insnList.get(i), argsList, i));
        }
        ArrayList<WrapInfo> wrapList = new ArrayList<WrapInfo>();
        for (ArgsInfo argsInfo : argsList) {
            List args = argsInfo.getArgs();
            if (args.isEmpty()) continue;
            ListIterator it = args.listIterator(args.size());
            while (it.hasPrevious()) {
                InsnNode assignInsn;
                RegisterArg arg = (RegisterArg)it.previous();
                SSAVar sVar = arg.getSVar();
                if (sVar == null || sVar.getVariableUseCount() != 1 && !arg.isThis() || sVar.contains(AFlag.DONT_INLINE) || (assignInsn = sVar.getAssign().getParentInsn()) == null || assignInsn.contains(AFlag.DONT_INLINE)) continue;
                int assignPos = insnList.getIndex(assignInsn);
                if (assignPos != -1) {
                    WrapInfo wrapInfo = argsInfo.checkInline(assignPos, arg);
                    if (wrapInfo == null) continue;
                    wrapList.add(wrapInfo);
                    continue;
                }
                BlockNode assignBlock = BlockUtils.getBlockByInsn(mth, assignInsn);
                if (assignBlock == null || assignInsn == arg.getParentInsn() || !CodeShrinker.canMoveBetweenBlocks(assignInsn, assignBlock, block, argsInfo.getInsn())) continue;
                CodeShrinker.inline(arg, assignInsn, assignBlock);
            }
        }
        if (!wrapList.isEmpty()) {
            for (WrapInfo wrapInfo : wrapList) {
                CodeShrinker.inline(wrapInfo.getArg(), wrapInfo.getInsn(), block);
            }
        }
    }

    private static boolean inline(RegisterArg arg, InsnNode insn, BlockNode block) {
        boolean replaced;
        InsnNode parentInsn = arg.getParentInsn();
        if (parentInsn != null && parentInsn.getType() == InsnType.RETURN) {
            parentInsn.setSourceLine(insn.getSourceLine());
        }
        boolean bl = replaced = arg.wrapInstruction(insn) != null;
        if (replaced) {
            InsnList.remove(block, insn);
        }
        return replaced;
    }

    private static boolean canMoveBetweenBlocks(InsnNode assignInsn, BlockNode assignBlock, BlockNode useBlock, InsnNode useInsn) {
        if (!BlockUtils.isPathExists(assignBlock, useBlock)) {
            return false;
        }
        List<RegisterArg> argsList = ArgsInfo.getArgs(assignInsn);
        BitSet args = new BitSet();
        for (RegisterArg registerArg : argsList) {
            args.set(registerArg.getRegNum());
        }
        boolean startCheck = false;
        for (InsnNode insn : assignBlock.getInstructions()) {
            if (startCheck && (!insn.canReorder() || ArgsInfo.usedArgAssign(insn, args))) {
                return false;
            }
            if (insn != assignInsn) continue;
            startCheck = true;
        }
        Set<BlockNode> set = BlockUtils.getAllPathsBlocks(assignBlock, useBlock);
        set.remove(assignBlock);
        set.remove(useBlock);
        for (BlockNode block : set) {
            for (InsnNode insn : block.getInstructions()) {
                if (insn.canReorder() && !ArgsInfo.usedArgAssign(insn, args)) continue;
                return false;
            }
        }
        for (InsnNode insn : useBlock.getInstructions()) {
            if (insn == useInsn) {
                return true;
            }
            if (insn.canReorder() && !ArgsInfo.usedArgAssign(insn, args)) continue;
            return false;
        }
        throw new JadxRuntimeException("Can't process instruction move : " + assignBlock);
    }

    private static void simplifyMoveInsns(BlockNode block) {
        List<InsnNode> insns = block.getInstructions();
        int size = insns.size();
        for (int i = 0; i < size; ++i) {
            InsnArg arg;
            InsnNode insn = insns.get(i);
            if (insn.getType() != InsnType.MOVE || !(arg = insn.getArg(0)).isInsnWrap()) continue;
            InsnNode wrapInsn = ((InsnWrapArg)arg).getWrapInsn();
            wrapInsn.setResult(insn.getResult());
            wrapInsn.copyAttributesFrom(insn);
            wrapInsn.setOffset(insn.getOffset());
            wrapInsn.remove(AFlag.WRAPPED);
            block.getInstructions().set(i, wrapInsn);
        }
    }

    private static final class WrapInfo {
        private final InsnNode insn;
        private final RegisterArg arg;

        public WrapInfo(InsnNode assignInsn, RegisterArg arg) {
            this.insn = assignInsn;
            this.arg = arg;
        }

        private InsnNode getInsn() {
            return this.insn;
        }

        private RegisterArg getArg() {
            return this.arg;
        }

        public String toString() {
            return "WrapInfo: " + this.arg + " -> " + this.insn;
        }
    }

    private static final class ArgsInfo {
        private final InsnNode insn;
        private final List<ArgsInfo> argsList;
        private final List<RegisterArg> args;
        private final int pos;
        private int inlineBorder;
        private ArgsInfo inlinedInsn;

        public ArgsInfo(InsnNode insn, List<ArgsInfo> argsList, int pos) {
            this.insn = insn;
            this.argsList = argsList;
            this.pos = pos;
            this.inlineBorder = pos;
            this.args = ArgsInfo.getArgs(insn);
        }

        public static List<RegisterArg> getArgs(InsnNode insn) {
            LinkedList<RegisterArg> args = new LinkedList<RegisterArg>();
            ArgsInfo.addArgs(insn, args);
            return args;
        }

        private static void addArgs(InsnNode insn, List<RegisterArg> args) {
            if (insn.getType() == InsnType.CONSTRUCTOR) {
                args.add(((ConstructorInsn)insn).getInstanceArg());
            } else if (insn.getType() == InsnType.TERNARY) {
                args.addAll(((TernaryInsn)insn).getCondition().getRegisterArgs());
            }
            for (InsnArg arg : insn.getArguments()) {
                if (!arg.isRegister()) continue;
                args.add((RegisterArg)arg);
            }
            for (InsnArg arg : insn.getArguments()) {
                if (!arg.isInsnWrap()) continue;
                ArgsInfo.addArgs(((InsnWrapArg)arg).getWrapInsn(), args);
            }
        }

        public InsnNode getInsn() {
            return this.insn;
        }

        private List<RegisterArg> getArgs() {
            return this.args;
        }

        public WrapInfo checkInline(int assignPos, RegisterArg arg) {
            if (!(arg.isThis() || assignPos < this.inlineBorder && this.canMove(assignPos, this.inlineBorder))) {
                return null;
            }
            this.inlineBorder = assignPos;
            return this.inline(assignPos, arg);
        }

        private boolean canMove(int from, int to) {
            BitSet movedSet;
            ArgsInfo startInfo = this.argsList.get(from);
            List<RegisterArg> movedArgs = startInfo.getArgs();
            int start = from + 1;
            if (start == to) {
                return true;
            }
            if (start > to) {
                throw new JadxRuntimeException("Invalid inline insn positions: " + start + " - " + to);
            }
            if (movedArgs.isEmpty()) {
                if (startInfo.insn.isConstInsn()) {
                    return true;
                }
                movedSet = EmptyBitSet.EMPTY;
            } else {
                movedSet = new BitSet();
                for (RegisterArg arg : movedArgs) {
                    movedSet.set(arg.getRegNum());
                }
            }
            for (int i = start; i < to; ++i) {
                InsnNode curInsn;
                ArgsInfo argsInfo = this.argsList.get(i);
                if (argsInfo.getInlinedInsn() == this || (curInsn = argsInfo.insn).canReorder() && !ArgsInfo.usedArgAssign(curInsn, movedSet)) continue;
                return false;
            }
            return true;
        }

        private static boolean usedArgAssign(InsnNode insn, BitSet args) {
            RegisterArg result = insn.getResult();
            return result != null && args.get(result.getRegNum());
        }

        public WrapInfo inline(int assignInsnPos, RegisterArg arg) {
            ArgsInfo argsInfo = this.argsList.get(assignInsnPos);
            argsInfo.inlinedInsn = this;
            return new WrapInfo(argsInfo.insn, arg);
        }

        public ArgsInfo getInlinedInsn() {
            ArgsInfo parent;
            if (this.inlinedInsn != null && (parent = this.inlinedInsn.getInlinedInsn()) != null) {
                this.inlinedInsn = parent;
            }
            return this.inlinedInsn;
        }

        public String toString() {
            return "ArgsInfo: |" + this.inlineBorder + " ->" + (this.inlinedInsn == null ? "-" : Integer.valueOf(this.inlinedInsn.pos)) + " " + this.args + " : " + this.insn;
        }
    }
}

