/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.api.IJadxArgs;
import jadx.core.codegen.TypeGen;
import jadx.core.deobf.Deobfuscator;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.files.FileUtils;
import jadx.core.utils.files.InputFile;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class RenameVisitor
extends AbstractVisitor {
    private Deobfuscator deobfuscator;

    @Override
    public void init(RootNode root) {
        IJadxArgs args = root.getArgs();
        List<DexNode> dexNodes = root.getDexNodes();
        if (dexNodes.isEmpty()) {
            return;
        }
        InputFile firstInputFile = dexNodes.get(0).getDexFile().getInputFile();
        String firstInputFileName = firstInputFile.getFile().getAbsolutePath();
        String inputPath = FilenameUtils.getFullPathNoEndSeparator((String)firstInputFileName);
        String inputName = FilenameUtils.getBaseName((String)firstInputFileName);
        File deobfMapFile = new File(inputPath, inputName + ".jobf");
        this.deobfuscator = new Deobfuscator(args, dexNodes, deobfMapFile);
        boolean deobfuscationOn = args.isDeobfuscationOn();
        if (deobfuscationOn) {
            this.deobfuscator.execute();
        }
        boolean isCaseSensitive = FileUtils.isCaseSensitiveFS(new File(inputPath));
        this.checkClasses(root, isCaseSensitive);
    }

    @Override
    public boolean visit(ClassNode cls) throws JadxException {
        this.checkFields(cls);
        this.checkMethods(cls);
        for (ClassNode inner : cls.getInnerClasses()) {
            this.visit(inner);
        }
        return false;
    }

    private void checkClasses(RootNode root, boolean caseSensitive) {
        HashSet<String> clsNames = new HashSet<String>();
        for (ClassNode cls : root.getClasses(true)) {
            ClassInfo classInfo;
            String clsFileName;
            this.checkClassName(cls);
            if (caseSensitive || clsNames.add((clsFileName = (classInfo = cls.getClassInfo()).getAlias().getFullPath()).toLowerCase())) continue;
            String newShortName = this.deobfuscator.getClsAlias(cls);
            String newFullName = classInfo.makeFullClsName(newShortName, true);
            classInfo.rename(cls.dex(), newFullName);
            clsNames.add(classInfo.getAlias().getFullPath().toLowerCase());
        }
    }

    private void checkClassName(ClassNode cls) {
        ClassInfo classInfo = cls.getClassInfo();
        String clsName = classInfo.getAlias().getShortName();
        String newShortName = null;
        char firstChar = clsName.charAt(0);
        if (Character.isDigit(firstChar)) {
            newShortName = "AnonymousClass" + clsName;
        } else if (firstChar == '$') {
            newShortName = "C" + clsName;
        }
        if (newShortName != null) {
            classInfo.rename(cls.dex(), classInfo.makeFullClsName(newShortName, true));
        }
        if (classInfo.getAlias().getPackage().isEmpty()) {
            String fullName = classInfo.makeFullClsName(classInfo.getAlias().getShortName(), true);
            String newFullName = "defpackage." + fullName;
            classInfo.rename(cls.dex(), newFullName);
        }
    }

    private void checkFields(ClassNode cls) {
        HashSet<String> names = new HashSet<String>();
        for (FieldNode field : cls.getFields()) {
            FieldInfo fieldInfo = field.getFieldInfo();
            if (names.add(fieldInfo.getAlias())) continue;
            fieldInfo.setAlias(this.deobfuscator.makeFieldAlias(field));
        }
    }

    private void checkMethods(ClassNode cls) {
        HashSet<String> names = new HashSet<String>();
        for (MethodNode mth : cls.getMethods()) {
            MethodInfo methodInfo;
            String signature;
            if (mth.contains(AFlag.DONT_GENERATE) || names.add(signature = RenameVisitor.makeMethodSignature(methodInfo = mth.getMethodInfo()))) continue;
            methodInfo.setAlias(this.deobfuscator.makeMethodAlias(mth));
        }
    }

    private static String makeMethodSignature(MethodInfo methodInfo) {
        StringBuilder signature = new StringBuilder();
        signature.append(methodInfo.getAlias());
        signature.append('(');
        for (ArgType arg : methodInfo.getArgumentsTypes()) {
            signature.append(TypeGen.signature(arg));
        }
        signature.append(')');
        return signature.toString();
    }
}

