/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions;

import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.visitors.regions.IRegionIterativeVisitor;
import jadx.core.dex.visitors.regions.IRegionVisitor;
import jadx.core.utils.exceptions.JadxOverflowException;
import java.util.Iterator;

public class DepthRegionTraversal {
    private static final int ITERATIVE_LIMIT = 500;

    private DepthRegionTraversal() {
    }

    public static void traverse(MethodNode mth, IRegionVisitor visitor) {
        DepthRegionTraversal.traverseInternal(mth, visitor, mth.getRegion());
    }

    public static void traverseIterative(MethodNode mth, IRegionIterativeVisitor visitor) {
        boolean repeat;
        int k = 0;
        do {
            repeat = DepthRegionTraversal.traverseIterativeStepInternal(mth, visitor, mth.getRegion());
            if (k++ <= 500) continue;
            throw new JadxOverflowException("Iterative traversal limit reached, method: " + mth);
        } while (repeat);
    }

    public static void traverseIncludingExcHandlers(MethodNode mth, IRegionIterativeVisitor visitor) {
        boolean repeat;
        int k = 0;
        do {
            if (!(repeat = DepthRegionTraversal.traverseIterativeStepInternal(mth, visitor, mth.getRegion()))) {
                ExceptionHandler h;
                Iterator<ExceptionHandler> iterator = mth.getExceptionHandlers().iterator();
                while (iterator.hasNext() && !(repeat = DepthRegionTraversal.traverseIterativeStepInternal(mth, visitor, (h = iterator.next()).getHandlerRegion()))) {
                }
            }
            if (k++ <= 500) continue;
            throw new JadxOverflowException("Iterative traversal limit reached, method: " + mth);
        } while (repeat);
    }

    private static void traverseInternal(MethodNode mth, IRegionVisitor visitor, IContainer container) {
        if (container instanceof IBlock) {
            visitor.processBlock(mth, (IBlock)container);
        } else if (container instanceof IRegion) {
            IRegion region = (IRegion)container;
            if (visitor.enterRegion(mth, region)) {
                for (IContainer subCont : region.getSubBlocks()) {
                    DepthRegionTraversal.traverseInternal(mth, visitor, subCont);
                }
            }
            visitor.leaveRegion(mth, region);
        }
    }

    private static boolean traverseIterativeStepInternal(MethodNode mth, IRegionIterativeVisitor visitor, IContainer container) {
        if (container instanceof IRegion) {
            IRegion region = (IRegion)container;
            if (visitor.visitRegion(mth, region)) {
                return true;
            }
            for (IContainer subCont : region.getSubBlocks()) {
                if (!DepthRegionTraversal.traverseIterativeStepInternal(mth, visitor, subCont)) continue;
                return true;
            }
        }
        return false;
    }
}

