/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.IAttributeNode;
import jadx.core.dex.attributes.nodes.JadxErrorAttr;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.exceptions.JadxOverflowException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorsCounter {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorsCounter.class);
    private final Set<IAttributeNode> errorNodes = new HashSet<IAttributeNode>();
    private int errorsCount;

    public int getErrorCount() {
        return this.errorsCount;
    }

    private void addError(IAttributeNode node, String msg, Throwable e) {
        this.errorNodes.add(node);
        ++this.errorsCount;
        if (e != null) {
            if (e.getClass() == JadxOverflowException.class) {
                e = new JadxOverflowException(e.getMessage());
                LOG.error("{}, message: {}", (Object)msg, (Object)e.getMessage());
            } else {
                LOG.error(msg, e);
            }
            node.addAttr(new JadxErrorAttr(e));
        } else {
            node.add(AFlag.INCONSISTENT_CODE);
            LOG.error(msg);
        }
    }

    public static String classError(ClassNode cls, String errorMsg, Throwable e) {
        String msg = ErrorsCounter.formatErrorMsg(cls, errorMsg);
        cls.dex().root().getErrorsCounter().addError(cls, msg, e);
        return msg;
    }

    public static String classError(ClassNode cls, String errorMsg) {
        return ErrorsCounter.classError(cls, errorMsg, null);
    }

    public static String methodError(MethodNode mth, String errorMsg, Throwable e) {
        String msg = ErrorsCounter.formatErrorMsg(mth, errorMsg);
        mth.dex().root().getErrorsCounter().addError(mth, msg, e);
        return msg;
    }

    public static String methodError(MethodNode mth, String errorMsg) {
        return ErrorsCounter.methodError(mth, errorMsg, null);
    }

    public void printReport() {
        if (this.getErrorCount() > 0) {
            LOG.error("{} errors occurred in following nodes:", (Object)this.getErrorCount());
            ArrayList<String> errors = new ArrayList<String>(this.errorNodes.size());
            for (IAttributeNode node : this.errorNodes) {
                String nodeName = node.getClass().getSimpleName().replace("Node", "");
                errors.add(nodeName + ": " + node);
            }
            Collections.sort(errors);
            for (String err : errors) {
                LOG.error("  {}", (Object)err);
            }
        }
    }

    public static String formatErrorMsg(ClassNode cls, String msg) {
        return msg + " in class: " + cls;
    }

    public static String formatErrorMsg(MethodNode mth, String msg) {
        return msg + " in method: " + mth;
    }

    private String formatException(Throwable e) {
        if (e == null || e.getMessage() == null) {
            return "";
        }
        return "\n error: " + e.getMessage();
    }

    public String formatErrorMsg(ClassNode cls, String msg, Throwable e) {
        return ErrorsCounter.formatErrorMsg(cls, msg) + this.formatException(e);
    }

    public String formatErrorMsg(MethodNode mth, String msg, Throwable e) {
        return ErrorsCounter.formatErrorMsg(mth, msg) + this.formatException(e);
    }
}

