/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils.files;

import com.android.dex.Dex;
import jadx.core.utils.AsmUtils;
import jadx.core.utils.exceptions.DecodeException;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.files.DexFile;
import jadx.core.utils.files.FileUtils;
import jadx.core.utils.files.JavaToDex;
import jadx.core.utils.files.ZipSecurity;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputFile {
    private static final Logger LOG = LoggerFactory.getLogger(InputFile.class);
    private final File file;
    private final List<DexFile> dexFiles = new ArrayList<DexFile>();

    public static void addFilesFrom(File file, List<InputFile> list, boolean ... skipSources) throws IOException, DecodeException {
        InputFile inputFile = new InputFile(file);
        inputFile.searchDexFiles(skipSources[0]);
        list.add(inputFile);
    }

    private InputFile(File file) throws IOException, DecodeException {
        if (!file.exists()) {
            throw new IOException("File not found: " + file.getAbsolutePath());
        }
        this.file = file;
    }

    private void searchDexFiles(boolean skipSources) throws IOException, DecodeException {
        String fileName = this.file.getName();
        if (fileName.endsWith(".dex")) {
            this.addDexFile(new Dex(this.file));
            return;
        }
        if (fileName.endsWith(".class")) {
            this.addDexFile(InputFile.loadFromClassFile(this.file));
            return;
        }
        if (FileUtils.isApkFile(this.file) || FileUtils.isZipDexFile(this.file)) {
            this.loadFromZip(".dex");
            return;
        }
        if (fileName.endsWith(".jar")) {
            if (this.loadFromZip(".dex")) {
                return;
            }
            if (fileName.endsWith(".jar")) {
                this.addDexFile(InputFile.loadFromJar(this.file));
                return;
            }
            if (fileName.endsWith(".aar")) {
                this.loadFromZip(".jar");
                return;
            }
            return;
        }
        if (skipSources) {
            return;
        }
        throw new DecodeException("Unsupported input file format: " + this.file);
    }

    private void addDexFile(Dex dexBuf) throws IOException {
        this.addDexFile("", dexBuf);
    }

    private void addDexFile(String fileName, Dex dexBuf) throws IOException {
        this.dexFiles.add(new DexFile(this, fileName, dexBuf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadFromZip(String ext) throws IOException, DecodeException {
        int index = 0;
        try (ZipFile zf = new ZipFile(this.file);){
            String instantRunDexSuffix = "classes" + ext;
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String entryName = entry.getName();
                if (!ZipSecurity.isValidZipEntry(entry)) continue;
                InputStream inputStream = zf.getInputStream(entry);
                try {
                    FileOutputStream fos;
                    File jarFile;
                    if (entryName.startsWith("classes") && entryName.endsWith(ext) || entryName.endsWith(instantRunDexSuffix)) {
                        if (ext.equals(".dex")) {
                            ++index;
                            this.addDexFile(entryName, new Dex(inputStream));
                            continue;
                        }
                        if (ext.equals(".jar")) {
                            ++index;
                            jarFile = FileUtils.createTempFile(entryName);
                            fos = new FileOutputStream(jarFile);
                            try {
                                IOUtils.copy((InputStream)inputStream, (OutputStream)fos);
                            }
                            finally {
                                FileUtils.close(fos);
                            }
                            this.addDexFile(entryName, InputFile.loadFromJar(jarFile));
                            continue;
                        }
                        throw new JadxRuntimeException("Unexpected extension in zip: " + ext);
                    }
                    if (!entryName.equals("instant-run.zip") || !ext.equals(".dex")) continue;
                    jarFile = FileUtils.createTempFile("instant-run.zip");
                    fos = new FileOutputStream(jarFile);
                    try {
                        IOUtils.copy((InputStream)inputStream, (OutputStream)fos);
                    }
                    finally {
                        FileUtils.close(fos);
                    }
                    InputFile tempFile = new InputFile(jarFile);
                    tempFile.loadFromZip(ext);
                    List<DexFile> dexFiles = tempFile.getDexFiles();
                    if (dexFiles.isEmpty()) continue;
                    index += dexFiles.size();
                    this.dexFiles.addAll(dexFiles);
                }
                finally {
                    FileUtils.close(inputStream);
                }
            }
        }
        return index > 0;
    }

    private static Dex loadFromJar(File jarFile) throws DecodeException {
        JavaToDex j2d = new JavaToDex();
        try {
            LOG.info("converting to dex: {} ...", (Object)jarFile.getName());
            byte[] ba = j2d.convert(jarFile.getAbsolutePath());
            if (ba.length == 0) {
                throw new JadxException("Empty dx output");
            }
            Dex dex = new Dex(ba);
            return dex;
        }
        catch (Throwable e) {
            throw new DecodeException("java class to dex conversion error:\n " + e.getMessage(), e);
        }
        finally {
            if (j2d.isError()) {
                LOG.warn("dx message: {}", (Object)j2d.getDxErrors());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Dex loadFromClassFile(File file) throws IOException, DecodeException {
        File outFile = FileUtils.createTempFile("cls.jar");
        FileOutputStream out = null;
        JarOutputStream jo = null;
        try {
            out = new FileOutputStream(outFile);
            jo = new JarOutputStream(out);
            String clsName = AsmUtils.getNameFromClassFile(file);
            if (clsName == null || ZipSecurity.isValidZipEntryName(clsName)) {
                throw new IOException("Can't read class name from file: " + file);
            }
            FileUtils.addFileToJar(jo, file, clsName + ".class");
        }
        catch (Throwable throwable) {
            FileUtils.close(jo);
            FileUtils.close(out);
            throw throwable;
        }
        FileUtils.close(jo);
        FileUtils.close(out);
        return InputFile.loadFromJar(outFile);
    }

    public File getFile() {
        return this.file;
    }

    public List<DexFile> getDexFiles() {
        return this.dexFiles;
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }
}

