/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils.files;

import java.io.File;
import java.util.zip.ZipEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipSecurity {
    private static final Logger LOG = LoggerFactory.getLogger(ZipSecurity.class);
    private static final int MAX_SIZE_DIFF = 25;

    private static boolean isInSubDirectory(File base, File file) {
        if (file == null) {
            return false;
        }
        if (file.equals(base)) {
            return true;
        }
        return ZipSecurity.isInSubDirectory(base, file.getParentFile());
    }

    public static boolean isValidZipEntryName(String entryName) {
        try {
            File currentPath = new File(".").getCanonicalFile();
            File canonical = new File(currentPath, entryName).getCanonicalFile();
            if (ZipSecurity.isInSubDirectory(currentPath, canonical)) {
                return true;
            }
            LOG.error("Path traversal attack detected, invalid name: {}", (Object)entryName);
            return false;
        }
        catch (Exception e) {
            LOG.error("Path traversal attack detected, invalid name: {}", (Object)entryName);
            return false;
        }
    }

    public static boolean isZipBomb(ZipEntry entry) {
        long compressedSize = entry.getCompressedSize();
        long uncompressedSize = entry.getSize();
        if (compressedSize < 0L || uncompressedSize < 0L) {
            LOG.error("Zip bomp attack detected, invalid sizes: compressed {}, uncompressed {}, name {}", new Object[]{compressedSize, uncompressedSize, entry.getName()});
            return true;
        }
        if (compressedSize * 25L < uncompressedSize) {
            LOG.error("Zip bomp attack detected, invalid sizes: compressed {}, uncompressed {}, name {}", new Object[]{compressedSize, uncompressedSize, entry.getName()});
            return true;
        }
        return false;
    }

    public static boolean isValidZipEntry(ZipEntry entry) {
        return ZipSecurity.isValidZipEntryName(entry.getName()) && !ZipSecurity.isZipBomb(entry);
    }
}

