/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import jadx.core.codegen.CodeWriter;
import jadx.core.utils.android.Res9patchStreamDecoder;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResContainer
implements Comparable<ResContainer> {
    private final String name;
    private final List<ResContainer> subFiles;
    @Nullable
    private CodeWriter content;
    @Nullable
    private BufferedImage image;

    private ResContainer(String name, List<ResContainer> subFiles) {
        this.name = name;
        this.subFiles = subFiles;
    }

    public static ResContainer singleFile(String name, CodeWriter content) {
        ResContainer resContainer = new ResContainer(name, Collections.emptyList());
        resContainer.content = content;
        return resContainer;
    }

    public static ResContainer singleImageFile(String name, InputStream content) {
        ResContainer resContainer = new ResContainer(name, Collections.emptyList());
        InputStream newContent = content;
        if (name.endsWith(".9.png")) {
            Res9patchStreamDecoder decoder = new Res9patchStreamDecoder();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                decoder.decode(content, os);
            }
            catch (JadxException e) {
                e.printStackTrace();
            }
            newContent = new ByteArrayInputStream(os.toByteArray());
        }
        try {
            resContainer.image = ImageIO.read(newContent);
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Image load error", e);
        }
        return resContainer;
    }

    public static ResContainer multiFile(String name) {
        return new ResContainer(name, new ArrayList<ResContainer>());
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.name.replace("/", File.separator);
    }

    @Nullable
    public CodeWriter getContent() {
        return this.content;
    }

    public void setContent(@Nullable CodeWriter content) {
        this.content = content;
    }

    @Nullable
    public BufferedImage getImage() {
        return this.image;
    }

    public List<ResContainer> getSubFiles() {
        return this.subFiles;
    }

    @Override
    public int compareTo(@NotNull ResContainer o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResContainer)) {
            return false;
        }
        ResContainer that = (ResContainer)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Res{" + this.name + ", subFiles=" + this.subFiles + "}";
    }
}

