local addonName, addon = ...

function getLocalizedStrings(locale)
local L = {}

if locale == "enUS" then

L.TITLE = addonName
L.GUIDE_WINDOW = "Guide window"
L.SHOW_MAINFRAME = "Show window"
L.LOCK_MAINFRAME = "Lock window"
L.LOAD_MESSAGE = "Guidelime: Loading guide \"%s\""
L.SHOW_COMPLETED_STEPS = "Show completed steps"
L.SHOW_UNAVAILABLE_STEPS = "Show skipped steps"
L.ARROW = "Arrow"
L.MAP_MARKERS_GOTO = "Waypoint markers (%s)"
L.MAP_MARKERS_LOC = "Additional markers (%s)"
L.CURRENT_GUIDE = "Current guide"
L.AVAILABLE_GUIDES = "Available guides"
L.DETAILS = "Details"
L.MAIN_FRAME_WIDTH = "Window width"
L.MAIN_FRAME_HEIGHT = "Window height"
L.MAIN_FRAME_ALPHA = "Window alpha"
L.MAIN_FRAME_FONT_SIZE = "Font size" 
L.MAIN_FRAME_SHOW_SCROLLBAR = "Show scroll bar"
L.RESET_POSITION = "Reset position"
L.SELECT_COLORS = "Select colors"
L.MAX_NUM_OF_STEPS = "Number of steps shown\n(0 = unlimited)"
L.MAX_NUM_OF_MARKERS = "Number of markers\n(0 = unlimited)"
L.SHOW_ARROW = "Show arrow"
L.SHOW_DISTANCE = "Show distance"
L.YARDS = "yards"
L.MAP_MARKER_STYLE = "Map marker style"
L.MAP_MARKER_SIZE = "Map marker size"
L.MAP_MARKER_ALPHA = "Map marker alpha"
L.SHOW_MARKERS_ON = "Show markers on "
L.MAP = "map"
L.MINIMAP = "minimap"
L.ARROW_ALPHA = "Arrow alpha"
L.ARROW_STYLE = "Arrow style"
L.ARROW_SIZE = "Arrow size"
L.ARROW_STYLE1 = "lime"
L.ARROW_STYLE2 = "arrow"
L.LOCK_ARROW = "Lock arrow"
L.ARROW_TOOLTIP_CORPSE = "Run to your corpse"
L.GENERAL_OPTIONS = "General options"
L.DEBUGGING_OPTIONS = "Editing / Debugging options"
L.DEBUGGING = "Enable debugging mode"
L.SHOW_LINE_NUMBERS = "Show line numbers"
L.SHOW_QUEST_IDS = "Show quest IDs"
L.DISPLAY_DEMO_GUIDES = "Display Demo guides"
L.SKIPPING_QUEST = "You are skipping this quest."
L.MISSING_PREQUEST = "Completing following quest is required:"
L.MISSING_PREQUESTS = "Completing following quests is required:"
L.OTHER_GUIDES = "Other guides"
L.LOAD_GUIDE = "Load guide"
L.RESET_GUIDE = "Reset guide"
L.EDIT_GUIDE = "Edit guide"
L.URL = "URL"
L.QUEST_REQUIRED_LEVEL = "Required level for %s is %s"
L.STEP_MANUAL = "Click here when you have completed this step"
L.STEP_SKIP = "Click here in order to skip this step"
L.STEP_FOLLOWUP_QUEST = "If you skip %s you will miss the following quest later on"
L.STEP_FOLLOWUP_QUESTS = "If you skip %s you will miss the following quests later on"
L.STEP_FOLLOWUP_QUEST_CONT = "When you do %s later this quest will get reactivated."
L.STEP_FOLLOWUP_QUESTS_CONT = "When you do %s later these quests will get reactivated."
L.SHOW_SUGGESTED_QUEST_LEVELS = "Show suggested level for a quest"
L.SHOW_MINIMUM_QUEST_LEVELS = "Show minimum level for a quest"
L.SHOW_TOOLTIPS = "Show tooltips"
L.ESTIMATE = "This is an estimated position only."
L.NO_GUIDE_LOADED = "You have not yet selected a guide. Click here in order to start by loading a guide."
L.GUIDE_FINISHED = "Your current guide has been finished. Click here in order to load another guide."
L.GUIDE_FINISHED_NEXT = "Your current guide has been finished. Click here in order to continue with %s."
L.GUIDE_FINISHED_NEXT_ALT = "Alternatively you can choose to click here in order to continue with %s."
L.DOWNLOAD_FULL_GUIDE = "This is a demo only. In order to obtain the full %s-%s guide you will have to install this guide's addon module %s. It can be downloaded for free from: %s"
L.GUIDE_LIST = "More guides are available on: %s"
L.AUTO_COMPLETE_QUESTS = "Automatically accept/turn in quests"
L.AUTO_SELECT_FLIGHT = "Automatically select a flight path"
L.EDITOR = "Editor"
L.SAVE_GUIDE = "Save guide"
L.CUSTOM_GUIDES = "Custom guides"
L.SAVE_MSG = "Save guide as \"%s\"?" 
L.OVERWRITE_MSG = "Overwrite existing guide \"%s\"?" 
L.DELETE_GUIDE = "Delete guide"
L.DELETE_MSG = "Guide \"%s\" will be deleted from your custom guides."
L.EDITOR_TOOLTIP_NAME = "Set name and level range of the guide\ne.g.: \"[N1-6Coldridge Valley]\""
L.EDITOR_TOOLTIP_NEXT = "Set name and level range of the next guide following the current guide\ne.g.: \"[NX6-12Dun Morogh]\""
L.EDITOR_TOOLTIP_DETAILS = "Enter detailed guide description\ne.g.: \"[D My personal guide to the gnome/dwarf starting zone]\""
L.EDITOR_TOOLTIP_GUIDE_APPLIES = "Set which faction/races/classes this guide applies to\ne.g.: \"[GA Dwarf,Gnome]\""
L.EDITOR_TOOLTIP_APPLIES = "Set which faction/races/classes the current step applies to\ne.g.: \"[A Dwarf,Rogue]\""
L.EDITOR_TOOLTIP_OPTIONAL = "Mark the current step as optional\ni.e.: \"[O]\""
L.EDITOR_TOOLTIP_OPTIONAL_COMPLETE_WITH_NEXT = "Mark the current step to be automatically completed whenever the following step is completed\ni.e.: \"[OC]\""
L.EDITOR_TOOLTIP_QUEST = "Add a quest\ne.g.: \"[QA179]\" or \"[QC3361,2 A Refugee's Quandary]\""
L.EDITOR_TOOLTIP_GOTO = "Add coordinates of a target location\ne.g.: \"[G 29.93,71.2 Dun Morogh]\""
L.EDITOR_TOOLTIP_LOC = "Add coordinates of an additional location\ne.g.: \"[L 29.93,71.2 Dun Morogh]\""
L.EDITOR_TOOLTIP_XP = "This step requires the player to have reached a certain level / amount of experience on the current level\ne.g.: \"[XP8.5 half way to 9]\""
L.EDITOR_TOOLTIP_HEARTH = "The player should use the hearthstone\ni.e.: \"[H]\""
L.EDITOR_TOOLTIP_FLY = "The player should take a flight\ni.e.: \"[F]\""
L.EDITOR_TOOLTIP_TRAIN = "The player should visit the trainer\ni.e.: \"[T]\""
L.EDITOR_TOOLTIP_SET_HEARTH = "The player should set the hearthstone at the inn\ni.e.: \"[S]\""
L.EDITOR_TOOLTIP_GET_FLIGHT_POINT = "The player should get a new flight point\ni.e.: \"[P]\""
L.EDITOR_TOOLTIP_VENDOR = "The player should vendor / resupply here\ni.e.: \"[V]\""
L.EDITOR_TOOLTIP_REPAIR = "The player should repair here\ni.e.: \"[R]\""
L.EDITOR_TOOLTIP_ZONE = "This is not required for all but the first coordinates. If omitted it is assumed that it is in the same zone as previous coordinates."
L.NAME = "Name"
L.MINIMUM_LEVEL = "Minimum level"
L.MAXIMUM_LEVEL = "Maximum level"
L.QUEST_ACCEPT = "Accept" 
L.QUEST_TURNIN = "Turn in"
L.QUEST_COMPLETE = "Complete" 
L.QUEST_SKIP = "Skip"
L.QUEST_S_TOOLTIP = "Only use this to point out to the player not to accept a certain quest"
L.QUEST_NAME = "Quest name"
L.QUEST_NAME_TOOLTIP = "Text to be shown. If omitted the name of the quest will be shown. If this is \"-\" no text will be shown"
L.QUEST_ID = "Quest id"
L.QUEST_ID_TOOLTIP = "Quest id. If omitted a quest of the given name is searched. Since names can be ambiguous you might have to enter the quest id."
L.QUEST_OBJECTIVE = "Quest objective"
L.QUEST_OBJECTIVE_TOOLTIP = "Number of the objective that should be completed (1 for first, 2 for second, ...). Can be specified when only a single objective is to be tracked. If omitted all objectives are required."
L.QUEST_ADD_COORDINATES = "Add coordinates"
L.QUEST_ADD_COORDINATES_TOOLTIP = "If coordinates for a quest step are present in the quests database, a go to step will be added"
L.XP_LEVEL = "Level only"
L["XP_LEVEL+"] = "Points obtained"
L["XP_LEVEL-"] = "Points remaining"
L["XP_LEVEL%"] = "Percentage"
L["XP_LEVEL+_TOOLTIP"] = "Player has to have reached the specified level and has to have obtained the specified amount of points"
L["XP_LEVEL-_TOOLTIP"] = "Player has to have at most the specified amount of points remaining until reaching the specified level"
L["XP_LEVEL%_TOOLTIP"] = "Player has to have reached the specified level and has to have obtained the specified percentage of points towards the next level"
L.XP_TEXT = "Text"
L.XP_TEXT_TOOLTIP = "Text to be shown. If omitted this element will be shown as \"%s\"."
L.SHOW_MAP = "Show on map"
L.QUEST_INFO = "Quest info"
L.SUGGESTED_LEVEL = "Suggested level"
L.TYPE = "Type" -- as in type of a quest; elite, ...
L.GOTO_INFO = "Coordinates info"
L.QUEST_ACCEPT_POS = "Started by"
L.QUEST_COMPLETE_POS = "Completed with"
L.QUEST_TURNIN_POS = "Turned in at"
L.AT = "at" -- as in npc xyz at (12,34)
L.MORE_POSITIONS = "more positions"
L.ERROR_CODE_NOT_RECOGNIZED = "Parsing guide \"%s\": code [%s] not recognized in line \"%s\""
L.ERROR_GUIDE_HAS_NO_NAME = "Guide has no name"
L.ERROR_CODE_ZONE_NOT_FOUND = "Parsing guide \"%s\": zone not found in code [%s] in line \"%s\""
L.ERROR_NOT_A_NUMBER = "%s is not a number"
L.ERROR_QUEST_NOT_FOUND = "Quest \"%s\" was not found"
L.ERROR_QUEST_NOT_UNIQUE = "There is more than one quest \"%s\". Enter one of these ids: "
L.ERROR_ZONE_NOT_FOUND = "\"%s\" is not a zone. Enter one of these zone names: "
L.ERROR_OUT_OF_RANGE = "%s is not between %s and %s"
L.ERROR_QUEST_RACE_ONLY = "This quest is for the following races only: "
L.ERROR_QUEST_CLASS_ONLY = "This quest is for the following classes only: "
L.ZONE = "Zone"
L.LEVEL = "Level"
L.PART = "part" -- as in quest series: "The Missing Diplomat" part 17
L.CATEGORY = "Category"
L.QUEST_CHAIN = "Quest chain"
L.NEXT = "Next" -- as in next quest
L.PREVIOUS = "Previous" -- as in previous quest
L.OBJECTIVE = "Objective"
L.ENGLISH_NAME = "English name"
L.SKIP_CUTSCENES = "Skip cutscenes"
L.USE_QUESTIE_AS_DATA_SOURCE = "Use 'Questie' as data source"
L.USE_QUESTIE_AS_DATA_SOURCE_TOOLTIP = "When the addon 'Questie' is installed, it can be used as data source for quest coordinates.\nIt might contain different information than the internal quest database e.g. for quest mob spawn locations."
L.USE_INTERNAL_DATA_SOURCE = "Use internal data source"
L.ADD_QUEST_COORDINATES = "Add quest coordinates"
L.ADD_QUEST_COORDINATES_MESSAGE = "Adds quest coordinates to all quest steps if available in the quest database. Existing quest coordinates will be replaced."
L.ADDED_QUEST_COORDINATES_MESSAGE = "%s quest coordinates have been added."
L.REMOVE_ALL_COORDINATES = "Remove all coordinates"
L.REMOVE_ALL_COORDINATES_MESSAGE = "All coordinate steps ([G...]) will be removed."
L.REMOVED_COORDINATES_MESSAGE = "%s coordinates have been removed."
L.DISCARD_CHANGES = "Discard changes"
L.IMPORT_GUIDE = "Import guide"
L.IMPORT_GUIDE_MESSAGE = "Import a guide written in plain text. Quest names should be in quotation marks(\"\"). Occasionally correct quest IDs have to be added manually. Lines with missing IDs or other errors will be marked. Marks are removed when you fix the errors and import again."
L.Alliance = "Alliance"
L.Horde = "Horde"
L.CHECK_QUESTS_COMPLETED = "%s quests completed"
L.CHECK_QUESTS_NO_INCONSISTENCIES = "no inconsistencies were detected"
L.CHECK_QUESTS = "Inconsistencies between your quest progress and the Guidelime quest database were detected. You can help improving the addon by sending this text as a private message to %s on Discord (alternatively to %s on Curseforge or %s on Reddit if you prefer). Thank you very much!"

-- Word lists used by the plain text parser
-- Spaces at the start and end of each word will make it so that a match cannot occur in the middle of a word. Spaces will match any whitespace or punctuation marks.

-- Word lists for detecting the type of a quest. matched expression can run over the quest itself but it has to start before the quest e.g. `turn "xyz" in`
L.WORD_LIST_ACCEPT = " accept ; get ; pick up ; pick .- up ; take "
L.WORD_LIST_COMPLETE = " do ; complete ; kill ; loot ; finish "
L.WORD_LIST_TURN_IN = " turn in ; turn .- in ; deliver "
L.WORD_LIST_SKIP = " skip ; ignore "

-- Word lists for detecting when a quest name is followed by its part in a quest series there is a general case (N) and as much specific ones as needed (1-...)
-- all of these should work without any whitespace (except at the end) to make finding quests more stable
L.WORD_LIST_PART_N = " *part ?(%d+) ; *(%d+)th ?part ; *p ?(%d+) " -- the part number must be captured with ()
L.WORD_LIST_PART_1 = " *first ?part ; *1st ?part "
L.WORD_LIST_PART_2 = " *second ?part ; *2nd ?part "
L.WORD_LIST_PART_3 = " *third ?part ; *3rd ?part "
L.WORD_LIST_PART_4 = " *fourth ?part "
L.WORD_LIST_NEXT_PART = " *next ?part "

-- Word lists for detecting when previous quest steps are being referenced
-- prefix and suffix which should not be part of the resulting quest tag can be captured with ()
L.WORD_LIST_COMPLETE_LAST = "( complete )it( );( finish )it( )"
L.WORD_LIST_TURN_IN_LAST = "( turn )it( in )"
L.WORD_LIST_COMPLETE_LAST_TWO = "( complete )both( );( finish )both( )"
L.WORD_LIST_TURN_IN_LAST_TWO = "( turn )both( in )"

-- Word lists for catching the word quest when no specific quest tag could be found e.g. `turn in all remaining quests`
L.WORD_LIST_QUESTS = " quests "
L.WORD_LIST_QUEST = " quest "

-- Word lists for detecting non-quest steps
-- Prefix and suffix which should not be part of the resulting quest tag can be captured with ()
L.WORD_LIST_XP = "( level )%d+( );( grind until )%d+( );( req. )%d+( )"
L.WORD_LIST_SET_HEARTH = "( set hearth in )%a+( );( set hearth to )%a+( );( set hearthstone in )%a+( );( set hearthstone to )%a+( );( )(set hearth );( )(set hearthstone );( )(set hs);( set hs in )%a+( );( set your hearth in )%a+( );( set your hearth to )%a+( )"
L.WORD_LIST_HEARTH = "( hearth to )%a+( );( )(hearth );( use .- )(hs );( use )(hs);( use .- )(hearthstone );( use )(hearthstone)"
L.WORD_LIST_FLY = "( fly to )%a+( );( )(fly )"
L.WORD_LIST_GET_FLIGHT_POINT = [[
( get flight ?point in )%a+( );( activate flight ?point in )%a+( );( get flight ?point )%a+( );( activate flight ?point )%a+( );( get )%a+( flight ?point );( activate )%a+( flight ?point );( )(flight ?point );
( get flight ?path in )%a+( );( activate flight ?path in )%a+( );( get flight ?path )%a+( );( activate flight ?path )%a+( );( get )%a+( flight ?path );( activate )%a+( flight ?path );( )(flight ?path );
( get fp in )%a+( );( activate fp in )%a+( );( get fp )%a+( );( activate fp )%a+( );( get the )(fp );( get )%a+( fp );( activate )%a+( fp )
]]
L.WORD_LIST_VENDOR = " purchase ; buy ; vendor "
L.WORD_LIST_REPAIR = " repair "
L.WORD_LIST_TRAIN = " train ; skills "
L.WORD_LIST_OPTIONAL_COMPLETE_WITH_NEXT = "( grind towards)( );( grind north)( );( grind south)( );( grind east)( );( grind west)( );( grind northwest)( );( grind northeast)( );( grind southwest)( );( grind southeast)( );( run into)( );( run through)( );( run to)( );( grind up to)( );( grind down to)( )"
L.WORD_LIST_GOTO = "( at )(%d+%.?%d*) ?, ?(%d+%.?%d*)( );( )@ ?(%d+%.?%d*) ?, ?(%d+%.?%d*)( );( at )(%d+) ?%. ?(%d+)( );( )@ ?(%d+) ?%. ?(%d+)( );( to )(%d+%.?%d*) ?, ?(%d+%.?%d*)( );( to )(%d+) ?%. ?(%d+)( )"

elseif locale == "zhCN" then

L.TITLE = addonName
L["ADD_QUEST_COORDINATES"] = "添加任务座标"
L["ADD_QUEST_COORDINATES_MESSAGE"] = "如果数据库中有任务座标，将它们添加到所有步骤内；这会取代目前导航内的任务座标。"
L["ADDED_QUEST_COORDINATES_MESSAGE"] = "已添加%s的任务座标。"
L["Alliance"] = "联盟"
L["ARROW"] = "箭头"
L["ARROW_ALPHA"] = "箭头透明度"
L["ARROW_STYLE"] = "箭头样式"
L["ARROW_STYLE1"] = "青柠"
L["ARROW_STYLE2"] = "箭头"
L["ARROW_TOOLTIP_CORPSE"] = "跑去找你的尸体"
L["AT"] = "在"
L["AUTO_COMPLETE_QUESTS"] = "自动交接任务"
L["AUTO_SELECT_FLIGHT"] = "自动选择飞行点"
L["AVAILABLE_GUIDES"] = "可用导航"
L["CATEGORY"] = "类别"
L["CURRENT_GUIDE"] = "目前导航"
L.ARROW_SIZE = "箭头大小"
L["CUSTOM_GUIDES"] = "自制导航"
L["DEBUGGING"] = "启用除错模式"
L["DEBUGGING_OPTIONS"] = "编辑与除错选项"
L["DELETE_GUIDE"] = "删除导航"
L["DELETE_MSG"] = "“%s”已自你的导航书中删除。"
L["DETAILS"] = "描述"
L["DISCARD_CHANGES"] = "舍弃改动"
L["DISPLAY_DEMO_GUIDES"] = "显示导航范本"
L["DOWNLOAD_FULL_GUIDE"] = "这只是一个范本。要取得完整的 %s-%s 导航，需要安装 %s 模块，你可以在这里取得：%s"
L["EDIT_GUIDE"] = "编辑导航"
L["EDITOR"] = "编辑器"
L["EDITOR_TOOLTIP_APPLIES"] = "设定目前这个步骤的对象，阵营、种族、职业等等，例如 [A Dwarf,Rogue]」"
L["EDITOR_TOOLTIP_DETAILS"] = "设定这本导航导航的说明，例如「矮人新手村」、「个人地精导航」等"
L["EDITOR_TOOLTIP_FLY"] = "指示玩家使用鸟点时，使用 [F]"
L["EDITOR_TOOLTIP_GET_FLIGHT_POINT"] = "指示玩家开新鸟点时，使用 [P]"
L["EDITOR_TOOLTIP_GOTO"] = "替目标地点添加座标，例如 [G 29.93,71.2 Dun Morogh]"
L["EDITOR_TOOLTIP_GUIDE_APPLIES"] = "设定这本导航导航的对象，阵营、种族、职业等等，例如 [GA Dwarf,Gnome]"
L["EDITOR_TOOLTIP_HEARTH"] = "指示玩家使用炉石时，使用 [H]"
L["EDITOR_TOOLTIP_LOC"] = "替补充地点添加座标，例如 [L 29.93,71.2 Dun Morogh]"
L["EDITOR_TOOLTIP_NAME"] = "设定这本导航的名字与适用等级范围，例如 [N1-6Coldridge Valley]"
L["EDITOR_TOOLTIP_NEXT"] = "设定后续导航的名字与适用等级范围，例如 [NX6-12Dun Morogh]"
L["EDITOR_TOOLTIP_OPTIONAL"] = "指示目前步骤为选择性时，使用 [O]"
L["EDITOR_TOOLTIP_OPTIONAL_COMPLETE_WITH_NEXT"] = "若任务的下一步会自动完成，标记这个步骤为 [OC]"
L["EDITOR_TOOLTIP_QUEST"] = "添加一个任务，例如 [QA179] 或 [QC3361,2 A Refugee's Quandary]"
L["EDITOR_TOOLTIP_REPAIR"] = "指示玩家去修装时，使用 [R]"
L["EDITOR_TOOLTIP_SET_HEARTH"] = "指示玩家绑定炉石时，使用 [S]"
L["EDITOR_TOOLTIP_TRAIN"] = "指示玩家去找训练师时，使用 [T]"
L["EDITOR_TOOLTIP_VENDOR"] = "指示玩家去找商人时，使用 [V]"
L["EDITOR_TOOLTIP_XP"] = "这个步骤可以添加对玩家等级和经验值的要求，例如 [XP8.5 half way to 9]"
L["EDITOR_TOOLTIP_ZONE"] = "除了第一个座标外，后续都不是必需的。如果省略，则假定它与先前坐标位于同一区域中。（意思是同一张地图只要标记第一个座标，后续会自动匹配。）"
L["ENGLISH_NAME"] = "英文名字"
L["ERROR_CODE_NOT_RECOGNIZED"] = "解析导航“%1$s”：第%3$s行的代码 [%2$s] 不是有效代码"
L["ERROR_CODE_ZONE_NOT_FOUND"] = "解析导航“%1$s”：第%3$s行的地区 [%2$s] 不是有效编号"
L["ERROR_GUIDE_HAS_NO_NAME"] = "尚未命名导航"
L["ERROR_NOT_A_NUMBER"] = "%s不是数字"
L["ERROR_OUT_OF_RANGE"] = "%s 不在 %s 和 %s 之间"
L["ERROR_QUEST_CLASS_ONLY"] = "这个任务仅适用下列职业："
L["ERROR_QUEST_NOT_FOUND"] = "未找到任务“%s”"
L["ERROR_QUEST_NOT_UNIQUE"] = "有多个叫做“%s”的任务，请选择目前对应的任务ID："
L["ERROR_QUEST_RACE_ONLY"] = "这个任务只适用下列种族："
L["ERROR_ZONE_NOT_FOUND"] = "“%s”不是一个地区，请选择一个地区名："
L["ESTIMATE"] = "这只是一个大概的位置"
L["GENERAL_OPTIONS"] = "一般选项"
L["GOTO_INFO"] = "座标信息"
L["GUIDE_FINISHED"] = "目前的导航已经导航完成，点击这里载入别的导航。"
L["GUIDE_FINISHED_NEXT"] = "目前的导航已经导航完成，点击这里载入 %s 继续导航。"
L["GUIDE_FINISHED_NEXT_ALT"] = "或者点击这里继续 %s。"
L["GUIDE_LIST"] = "更多可用导航：%s"
L["GUIDE_WINDOW"] = "导航窗口"
L["Horde"] = "部落"
L["IMPORT_GUIDE"] = "导入导航"
L["IMPORT_GUIDE_MESSAGE"] = "导入纯文本导航，任务名字必需加上英文引号 \"\" ，必要时需要手动添加任务ID，缺少ID或编写错误的那一行会被标记，标记将在错误被修正并重新导入后消失。"
L["LEVEL"] = "等级"
L["LOAD_GUIDE"] = "载入导航"
L["LOAD_MESSAGE"] = "Guidelime：正在载入导航“%s”"
L["LOCK_ARROW"] = "锁定箭头"
L["LOCK_MAINFRAME"] = "锁定窗口"
L["MAIN_FRAME_ALPHA"] = "窗口透明度"
L["MAIN_FRAME_FONT_SIZE"] = "字号"
L["MAIN_FRAME_HEIGHT"] = "窗口高度"
L["MAIN_FRAME_SHOW_SCROLLBAR"] = "显示滚动条"
L["MAIN_FRAME_WIDTH"] = "窗口宽度"
L["MAP"] = "大地图"
L["MAP_MARKER_ALPHA"] = "地图标记透明度"
L["MAP_MARKER_SIZE"] = "地图标记大小"
L["MAP_MARKER_STYLE"] = "地图标记样式"
L["MAP_MARKERS_GOTO"] = "指路标记（%s）"
L["MAP_MARKERS_LOC"] = "额外标记（%s）"
L["MAX_NUM_OF_MARKERS"] = "显示目标数 0 = 无限"
L["MAX_NUM_OF_STEPS"] = "显示步骤数 0 = 无限"
L["MAXIMUM_LEVEL"] = "最高等级"
L["MINIMAP"] = "小地图"
L["MINIMUM_LEVEL"] = "最低等级"
L["MISSING_PREQUEST"] = "下列任务被跳过："
L["MISSING_PREQUESTS"] = "下列任务被跳过："
L["MORE_POSITIONS"] = "更多位置"
L["NAME"] = "名字"
L["NEXT"] = "下一个"
L["NO_GUIDE_LOADED"] = "你尚未选择导航，点击这里选择一本导航开始导航。"
L["OBJECTIVE"] = "目标"
L["OTHER_GUIDES"] = "其他导航"
L["OVERWRITE_MSG"] = "复盖现有的“%s”导航？"
L["PART"] = "部份"
L["PREVIOUS"] = "上一个"
L["QUEST_ACCEPT"] = "接受"
L["QUEST_ACCEPT_POS"] = "起始于"
L["QUEST_ADD_COORDINATES"] = "添加座标"
L["QUEST_ADD_COORDINATES_TOOLTIP"] = "如果资料库中包含某一个步骤中的座标，自动添加一个「前往」步骤"
L["QUEST_CHAIN"] = "任务串"
L["QUEST_COMPLETE"] = "完成"
L["QUEST_COMPLETE_POS"] = "完成于"
L["QUEST_ID"] = "任务ID"
L["QUEST_ID_TOOLTIP"] = "任务ID，如果不输入任务ID，使用任务名可以自动搜寻后匹配，但任务名可能不准确或重名而使你仍要输入任务ID。"
L["QUEST_INFO"] = "任务信息"
L["QUEST_NAME"] = "任务名"
L["QUEST_NAME_TOOLTIP"] = "要显示的文本。如果省略则显示任务名字，如果是“-”则不显示文字。"
L["QUEST_OBJECTIVE"] = "任务目标"
L["QUEST_OBJECTIVE_TOOLTIP"] = "要完成的目标数量（1是第一项、2是第二项），如果要追踪特定一项时可以指定任务目标，如果省略则会要求所有的任务目标。"
L["QUEST_REQUIRED_LEVEL"] = "%s需要等级%s"
L["QUEST_S_TOOLTIP"] = "只在玩家没有接受某个任务时显示这个提示"
L["QUEST_SKIP"] = "跳过"
L["QUEST_TURNIN"] = "提交"
L["QUEST_TURNIN_POS"] = "提交给"
L["REMOVE_ALL_COORDINATES"] = "移除所有座标"
L["REMOVE_ALL_COORDINATES_MESSAGE"] = "所有包含座标的步骤（[G...]）都将被移除。"
L["REMOVED_COORDINATES_MESSAGE"] = "已将座标 %s 移除。"
L["RESET_GUIDE"] = "重置导航"
L["RESET_POSITION"] = "重置位置"
L["SAVE_GUIDE"] = "储存导航"
L["SAVE_MSG"] = "储存为“%s”？"
L["SELECT_COLORS"] = "颜色"
L["SHOW_ARROW"] = "显示箭头"
L["SHOW_COMPLETED_STEPS"] = "显示已完成的步骤"
L["SHOW_DISTANCE"] = "显示距离"
L["SHOW_LINE_NUMBERS"] = "显示行数"
L["SHOW_MAINFRAME"] = "显示窗口"
L["SHOW_MAP"] = "显示于地图"
L["SHOW_MARKERS_ON"] = "显示标记于"
L["SHOW_MINIMUM_QUEST_LEVELS"] = "显示任务的最低等级"
L["SHOW_QUEST_IDS"] = "显示任务ID"
L["SHOW_SUGGESTED_QUEST_LEVELS"] = "显示建议的任务等级"
L["SHOW_TOOLTIPS"] = "显示鼠标提示"
L["SHOW_UNAVAILABLE_STEPS"] = "显示跳过的步骤"
L["SKIP_CUTSCENES"] = "跳过过场动画"
L["STEP_FOLLOWUP_QUEST"] = "若跳过 %s 将会错过下列任务"
L["STEP_FOLLOWUP_QUEST_CONT"] = "你可以之后再做 %s，这个任务的步骤会再度出现在导航里。"
L["STEP_FOLLOWUP_QUESTS"] = "若跳过 %s 将会错过下列任务"
L["STEP_FOLLOWUP_QUESTS_CONT"] = "你可以之后再做 %s，这些任务的步骤会再度出现在导航里。"
L["STEP_MANUAL"] = "如果完成此步骤，点击这里"
L["STEP_SKIP"] = "点击这里跳过此步骤"
L["SUGGESTED_LEVEL"] = "建议等级"
L["TYPE"] = "类型"
L["URL"] = "地址"
L["USE_INTERNAL_DATA_SOURCE"] = "使用内部数据库"
L["USE_QUESTIE_AS_DATA_SOURCE"] = "使用Questie数据库"
L["USE_QUESTIE_AS_DATA_SOURCE_TOOLTIP"] = "若同时启用Questie，可以将之作为任务座标数据库，但它可能会提供与内建数据库不同的数据，例如任务怪的重生点。"
L["WORD_LIST_COMPLETE"] = "做；完成；击杀；战利品；结束"
L["WORD_LIST_NEXT_PART"] = "*下一个？部分"
L["WORD_LIST_PART_1"] = "*第一部分；*第1部分"
L["WORD_LIST_PART_2"] = "*第二部分；*第2部分"
L["WORD_LIST_PART_3"] = "*第三部分；第3部分"
L["WORD_LIST_PART_4"] = "*第四？部分"
L["WORD_LIST_QUEST"] = "任务"
L["WORD_LIST_QUESTS"] = "任务"
L["WORD_LIST_REPAIR"] = "修理"
L["WORD_LIST_SKIP"] = "跳过；忽略"
L["WORD_LIST_TRAIN"] = "训练；技能"
L["WORD_LIST_VENDOR"] = "购买；买；供应商"
L["XP_LEVEL"] = "只要求等级"
L["XP_LEVEL-"] = "经验值高于"
L["XP_LEVEL%"] = "百分比"
L["XP_LEVEL%_TOOLTIP"] = "玩家要达到指定的等级和经验值百分比，例如 [XP8%20] 8级又20%经验值以上"
L["XP_LEVEL-_TOOLTIP"] = "指定玩家还差多少经验值升级，例如 [XP8-2000] 距离8级最多差2000经验值"
L["XP_LEVEL+"] = "经验值尚馀"
L["XP_LEVEL+_TOOLTIP"] = "玩家要达到指定的等级和经验值数值，例如 [XP8+2000] 8级又2000经验值以上"
L["XP_TEXT"] = "文本"
L["XP_TEXT_TOOLTIP"] = "要显示的文字。如果省略，会显示为“%s”"
L["YARDS"] = "码"
L["ZONE"] = "地区"

elseif locale == "zhTW" then

L.TITLE = addonName
L["ADD_QUEST_COORDINATES"] = "添加任務座標"
L["ADD_QUEST_COORDINATES_MESSAGE"] = "如果資料庫中有任務座標，將它們添加到所有步驟內；這會取代目前导航內的任務座標。"
L["ADDED_QUEST_COORDINATES_MESSAGE"] = "已添加%s的任務座標。"
L["Alliance"] = "聯盟"
L["ARROW"] = "箭頭"
L["ARROW_ALPHA"] = "箭頭透明度"
L["ARROW_STYLE"] = "箭頭樣式"
L["ARROW_STYLE1"] = "萊姆"
L["ARROW_STYLE2"] = "箭頭"
L["ARROW_TOOLTIP_CORPSE"] = "跑去找你的屍體"
L["AT"] = "在"
L["AUTO_COMPLETE_QUESTS"] = "自動交接任務"
L["AUTO_SELECT_FLIGHT"] = "自動選擇飛行點"
L["AVAILABLE_GUIDES"] = "可用导航"
L["CATEGORY"] = "類別"
L["CURRENT_GUIDE"] = "目前导航"
L["CUSTOM_GUIDES"] = "自製导航"
L["DEBUGGING"] = "啟用除錯模式"
L["DEBUGGING_OPTIONS"] = "編輯與除錯選項"
L["DELETE_GUIDE"] = "刪除导航"
L["DELETE_MSG"] = "「%s」已自你的导航書中刪除。"
L["DETAILS"] = "描述"
L["DISCARD_CHANGES"] = "捨棄改動"
L["DISPLAY_DEMO_GUIDES"] = "顯示导航範本"
L["DOWNLOAD_FULL_GUIDE"] = "這只是一個範本。要取得完整的 %s-%s 导航，需要安裝 %s 模組，你可以在這裡取得：%s"
L["EDIT_GUIDE"] = "編輯导航"
L["EDITOR"] = "編輯器"
L["EDITOR_TOOLTIP_APPLIES"] = "設定目前這個步驟的對象，陣營、種族、職業等等，例如 [A Dwarf,Rogue]」"
L["EDITOR_TOOLTIP_DETAILS"] = "設定這本导航導航的說明，例如「矮人新手村」、「個人地精导航」等"
L["EDITOR_TOOLTIP_FLY"] = "指示玩家使用飛行點時，使用 [F]"
L["EDITOR_TOOLTIP_GET_FLIGHT_POINT"] = "指示玩家開新飛行點時，使用 [P]"
L["EDITOR_TOOLTIP_GOTO"] = "替目標地點添加座標，例如 [G 29.93,71.2 Dun Morogh]"
L["EDITOR_TOOLTIP_GUIDE_APPLIES"] = "設定這本导航導航的對象，陣營、種族、職業等等，例如 [GA Dwarf,Gnome]"
L["EDITOR_TOOLTIP_HEARTH"] = "指示玩家使用爐石時，使用 [H]"
L["EDITOR_TOOLTIP_LOC"] = "替補充地點添加座標，例如 [L 29.93,71.2 Dun Morogh]"
L["EDITOR_TOOLTIP_NAME"] = "設定這本导航的名字與適用等級範圍，例如 [N1-6Coldridge Valley]"
L["EDITOR_TOOLTIP_NEXT"] = "設定後續导航的名字與適用等級範圍，例如 [NX6-12Dun Morogh]"
L["EDITOR_TOOLTIP_OPTIONAL"] = "指示目前步驟為選擇性時，使用 [O]"
L["EDITOR_TOOLTIP_OPTIONAL_COMPLETE_WITH_NEXT"] = "若任務的下一步會自動完成，標記這個步驟為 [OC]"
L["EDITOR_TOOLTIP_QUEST"] = "添加一個任務，例如 [QA179] 或 [QC3361,2 A Refugee's Quandary]"
L["EDITOR_TOOLTIP_REPAIR"] = "指示玩家去修裝時，使用 [R]"
L["EDITOR_TOOLTIP_SET_HEARTH"] = "指示玩家綁定爐石時，使用 [S]"
L["EDITOR_TOOLTIP_TRAIN"] = "指示玩家去找訓練師時，使用 [T]"
L["EDITOR_TOOLTIP_VENDOR"] = "指示玩家去找商人時，使用 [V]"
L["EDITOR_TOOLTIP_XP"] = "這個步驟可以添加對玩家等級和經驗值的要求，例如 [XP8.5 half way to 9]"
L["EDITOR_TOOLTIP_ZONE"] = "除了第一個座標外，後續都不是必需的。如果省略，則假定它與先前坐標位於同一區域中。（意思是同一張地圖只要標記第一個座標，後續會自動匹配。）"
L["ENGLISH_NAME"] = "英文名字"
L["ERROR_CODE_NOT_RECOGNIZED"] = "解析导航「%1$s」：第%3$s行的代碼 [%2$s] 不是有效代碼"
L["ERROR_CODE_ZONE_NOT_FOUND"] = "解析导航「%1$s」：第%3$s行的地區 [%2$s] 不是有效編號"
L["ERROR_GUIDE_HAS_NO_NAME"] = "尚未命名导航"
L["ERROR_NOT_A_NUMBER"] = "%s不是數字"
L["ERROR_OUT_OF_RANGE"] = "%s 不在 %s 和 %s 之間"
L["ERROR_QUEST_CLASS_ONLY"] = "這個任務僅適用下列職業："
L["ERROR_QUEST_NOT_FOUND"] = "未找到任務「%s」"
L["ERROR_QUEST_NOT_UNIQUE"] = "有多個叫做「%s」的任務，請選擇目前對應的任務ID："
L["ERROR_QUEST_RACE_ONLY"] = "這個任務只適用下列種族："
L["ERROR_ZONE_NOT_FOUND"] = "「%s」不是一個地區，請選擇一個地區名："
L["ESTIMATE"] = "這只是個大概的位置。"
L["GENERAL_OPTIONS"] = "一般選項"
L["GOTO_INFO"] = "座標資訊"
L["GUIDE_FINISHED"] = "目前的导航已經導航完成，點擊這裡載入別的导航。"
L["GUIDE_FINISHED_NEXT"] = "目前的导航已經導航完成，點擊這裡載入 %s 繼續導航。"
L["GUIDE_FINISHED_NEXT_ALT"] = "或者點擊這裡繼續 %s。"
L["GUIDE_LIST"] = "更多可用导航：%s"
L["GUIDE_WINDOW"] = "导航視窗"
L["Horde"] = "部落"
L["IMPORT_GUIDE"] = "導入导航"
L["IMPORT_GUIDE_MESSAGE"] = "導入純文本导航，任務名字必需加上英文引號「\"\"」，必要時需要手動添加任務ID，缺少ID或編寫錯誤的那一行會被標記，標記將在錯誤被修正並重新導入後消失。"
L["LEVEL"] = "等級"
L["LOAD_GUIDE"] = "載入导航"
L["LOAD_MESSAGE"] = "Guidelime：正在載入导航「%s」"
L["LOCK_ARROW"] = "鎖定箭頭"
L["LOCK_MAINFRAME"] = "鎖定視窗"
L["MAIN_FRAME_ALPHA"] = "視窗透明度"
L["MAIN_FRAME_FONT_SIZE"] = "字型大小"
L["MAIN_FRAME_HEIGHT"] = "視窗高度"
L["MAIN_FRAME_SHOW_SCROLLBAR"] = "顯示滾動條"
L["MAIN_FRAME_WIDTH"] = "視窗寬度"
L["MAP"] = "大地圖"
L["MAP_MARKER_ALPHA"] = "地圖標記透明度"
L["MAP_MARKER_SIZE"] = "地圖標記大小"
L["MAP_MARKER_STYLE"] = "地圖標記樣式"
L["MAP_MARKERS_GOTO"] = "指路標記（%s）"
L["MAP_MARKERS_LOC"] = "額外標記（%s）"
L["MAX_NUM_OF_MARKERS"] = "顯示目標數\\n0 = 無限"
L["MAX_NUM_OF_STEPS"] = "顯示步驟數\\n0 = 無限"
L["MAXIMUM_LEVEL"] = "最高等級"
L["MINIMAP"] = "小地圖"
L["MINIMUM_LEVEL"] = "最低等級"
L["MISSING_PREQUEST"] = "下列任務被跳過："
L["MISSING_PREQUESTS"] = "下列任務被跳過："
L["MORE_POSITIONS"] = "更多位置"
L["NAME"] = "名字"
L["NEXT"] = "下一個"
L["NO_GUIDE_LOADED"] = "你尚未選擇导航，點擊這裡選擇一本导航開始導航。"
L["OBJECTIVE"] = "目標"
L["OTHER_GUIDES"] = "其他导航"
L["OVERWRITE_MSG"] = "覆蓋現有的「%s」导航？"
L["PART"] = "部份"
L["PREVIOUS"] = "上一個"
L["QUEST_ACCEPT"] = "接受"
L["QUEST_ACCEPT_POS"] = "起始於"
L["QUEST_ADD_COORDINATES"] = "添加座標"
L["QUEST_ADD_COORDINATES_TOOLTIP"] = "如果資料庫中包含某一個步驟中的座標，自動添加一個「前往」步驟"
L["QUEST_CHAIN"] = "任務串"
L["QUEST_COMPLETE"] = "完成"
L["QUEST_COMPLETE_POS"] = "完成於"
L["QUEST_ID"] = "任務ID"
L["QUEST_ID_TOOLTIP"] = "任務ID，如果不輸入任務ID，使用任務名字可以自動搜尋後匹配，但任務名字可能不準確或重名而使你仍要輸入任務ID。"
L["QUEST_INFO"] = "任務資訊"
L["QUEST_NAME"] = "任務名字"
L["QUEST_NAME_TOOLTIP"] = "要顯示的文本。如果省略則顯示任務名字，如果是「-」則不顯示文字。"
L["QUEST_OBJECTIVE"] = "任務目標"
L["QUEST_OBJECTIVE_TOOLTIP"] = "要完成的目標數量（1是第一項、2是第二項），如果要追蹤特定一項時可以指定任務目標，如果省略則會要求所有的任務目標。"
L["QUEST_REQUIRED_LEVEL"] = "%s需要等級%s"
L["QUEST_S_TOOLTIP"] = "只在玩家沒有接受某個任務時顯示這個提示"
L["QUEST_SKIP"] = "跳過"
L["QUEST_TURNIN"] = "回報"
L["QUEST_TURNIN_POS"] = "回報給"
L["REMOVE_ALL_COORDINATES"] = "移除所有座標"
L["REMOVE_ALL_COORDINATES_MESSAGE"] = "所有包含座標的步驟（[G...]）都將被移除。"
L["REMOVED_COORDINATES_MESSAGE"] = "已將座標 %s 移除。"
L["RESET_GUIDE"] = "重置导航"
L["RESET_POSITION"] = "重設位置"
L["SAVE_GUIDE"] = "儲存导航"
L["SAVE_MSG"] = "儲存為「%s」？"
L["SELECT_COLORS"] = "顏色"
L["SHOW_ARROW"] = "顯示箭頭"
L["SHOW_COMPLETED_STEPS"] = "顯示已完成的步驟"
L["SHOW_DISTANCE"] = "顯示距離"
L["SHOW_LINE_NUMBERS"] = "顯示行數"
L["SHOW_MAINFRAME"] = "顯示視窗"
L["SHOW_MAP"] = "顯示於地圖"
L["SHOW_MARKERS_ON"] = "顯示標記於"
L["SHOW_MINIMUM_QUEST_LEVELS"] = "顯示任務的最低等級"
L["SHOW_QUEST_IDS"] = "顯示任務ID"
L["SHOW_SUGGESTED_QUEST_LEVELS"] = "顯示建議的任務等級"
L["SHOW_TOOLTIPS"] = "顯示滑鼠提示"
L["SHOW_UNAVAILABLE_STEPS"] = "顯示跳過的步驟"
L["SKIP_CUTSCENES"] = "跳過過場動畫"
L["STEP_FOLLOWUP_QUEST"] = "若跳過 %s 將會錯過下列任務"
L["STEP_FOLLOWUP_QUEST_CONT"] = "如果之後你重新回來做 %s，這個任務的步驟會再度出現在导航里。"
L["STEP_FOLLOWUP_QUESTS"] = "若跳過 %s 將會錯過下列任務"
L["STEP_FOLLOWUP_QUESTS_CONT"] = "如果之後你重新回來做 %s，這些任務的步驟會再度出現在导航里。"
L["STEP_MANUAL"] = "如果完成此步驟，點擊這裡"
L["STEP_SKIP"] = "點擊這裡跳過此步驟"
L["SUGGESTED_LEVEL"] = "建議等級"
L["TYPE"] = "類型"
L["URL"] = "網址"
L["USE_INTERNAL_DATA_SOURCE"] = "使用內部資料庫"
L["USE_QUESTIE_AS_DATA_SOURCE"] = "使用Questie資料庫"
L["USE_QUESTIE_AS_DATA_SOURCE_TOOLTIP"] = "若同時啟用Questie，可以將之作為任務座標資料庫，但它可能會提供與內建資料庫不同的資料，例如任務怪的重生點。"
L["WORD_LIST_NEXT_PART"] = "*下個 ?部分"
L["WORD_LIST_QUEST"] = "任務"
L["WORD_LIST_QUESTS"] = "任務"
L["WORD_LIST_REPAIR"] = "修理"
L["WORD_LIST_SKIP"] = "跳過；忽略"
L["WORD_LIST_TRAIN"] = "訓練 ; 技能"
L["WORD_LIST_VENDOR"] = "購買 ; 買 ; 商人"
L["WORD_LIST_XP"] = "( 等級 )%d+( );( 狩獵直至 )%d+( );( req. )%d+( )"
L["XP_LEVEL"] = "只要求等級"
L["XP_LEVEL-"] = "經驗值高於"
L["XP_LEVEL%"] = "百分比"
L["XP_LEVEL%_TOOLTIP"] = "玩家要達到指定的等級和經驗值百分比，例如 [XP8%20] 8級又20%經驗值以上"
L["XP_LEVEL-_TOOLTIP"] = "指定玩家還差多少經驗值升級，例如 [XP8-2000] 距離8級最多差2000經驗值"
L["XP_LEVEL+"] = "經驗值尚餘"
L["XP_LEVEL+_TOOLTIP"] = "玩家要達到指定的等級和經驗值數值，例如 [XP8+2000] 8級又2000經驗值以上"
L["XP_TEXT"] = "文本"
L["XP_TEXT_TOOLTIP"] = "要顯示的文字。如果省略，會顯示為「%s」"
L["YARDS"] = "碼"
L["ZONE"] = "地區"

elseif locale == "deDE" then

L.TITLE = addonName
L["ADD_QUEST_COORDINATES"] = "Koordinaten hinzufügen"
L["ADD_QUEST_COORDINATES_MESSAGE"] = "Es werden Quest-Koordinaten zu allen Schritten hinzugefügt, sofern diese in der Quest-Datenbank vorliegen. Vorhandene Quest-Koordinaten werden ersetzt."
L["ADDED_QUEST_COORDINATES_MESSAGE"] = "%s Quest-Koordinaten wurden hinzugefügt."
L["Alliance"] = "Allianz"
L["ARROW"] = "Richtungspfeil"
L["ARROW_ALPHA"] = "Richtungspfeil-Alpha"
L["ARROW_SIZE"] = "Richtungspfeil-Größe"
L["ARROW_STYLE"] = "Richtungspfeil-Stil"
L["ARROW_STYLE1"] = "Limette"
L["ARROW_STYLE2"] = "Pfeil"
L["ARROW_TOOLTIP_CORPSE"] = "Laufe zu deinem Leichnam"
L["AT"] = "in"
L["AUTO_COMPLETE_QUESTS"] = "Quests automatisch annehmen/einlösen"
L["AUTO_SELECT_FLIGHT"] = "Flugroute automatisch auswählen"
L["AVAILABLE_GUIDES"] = "Verfügbare Guides"
L["CATEGORY"] = "Kategorie"
L["CHECK_QUESTS"] = "Es wurden Unstimmigkeiten zwischen der Guidelime-Questdatenbank und deinem Quest-Fortschritt entdeckt. Du kannst helfen das Addon zu verbessern, indem du diesen Text als private Nachricht an %s auf Discord (oder an %s auf Curseforge oder %s auf Reddit) schickst. Vielen Dank!"
L["CHECK_QUESTS_COMPLETED"] = "%s Quests erledigt"
L["CHECK_QUESTS_NO_INCONSISTENCIES"] = "Es wurden keine Unstimmigkeiten festgestellt"
L["CURRENT_GUIDE"] = "Aktueller Guide"
L["CUSTOM_GUIDES"] = "Eigene Guides"
L["DEBUGGING"] = "Debugging-Modus aktivieren"
L["DEBUGGING_OPTIONS"] = "Editor- / Debugging-Optionen"
L["DELETE_GUIDE"] = "Guide löschen"
L["DELETE_MSG"] = "Guide \"%s\" wird aus deinen eigenen Guides gelöscht."
L["DETAILS"] = "Details"
L["DISCARD_CHANGES"] = "Änderungen verwerfen"
L["DISPLAY_DEMO_GUIDES"] = "Demo-Guides anzeigen"
L["DOWNLOAD_FULL_GUIDE"] = "Dies ist nur ein Demo-Guide. Um den vollständigen Guide für Stufe %s-%s zu erhalten, musst Du das Addon-Modul des Guides %s installieren. Du kannst es auf folgender Seite kostenlos herunterladen: %s"
L["EDIT_GUIDE"] = "Guide bearbeiten"
L["EDITOR"] = "Editor"
L["EDITOR_TOOLTIP_APPLIES"] = [=[Einstellen für welche Faktion/Rassen/Klassen der aktuelle Schritt gültig ist (englische Bezeichnungen)
z.B.: "[A Dwarf,Rogue]"]=]
L["EDITOR_TOOLTIP_DETAILS"] = [=[Detaillierte Guidebeschreibung eingeben
z.B.: "[D Mein eigener Guide für das Startgebiet der Gnome und Zwerge]"]=]
L["EDITOR_TOOLTIP_FLY"] = [=[Der Spieler soll eine Flugroute nehmen
d.h.: "[F]"]=]
L["EDITOR_TOOLTIP_GET_FLIGHT_POINT"] = [=[Der Spieler soll einen neuen Flugpunkt aktivieren
d.h.: "[P]"]=]
L["EDITOR_TOOLTIP_GOTO"] = [=[Koordinaten eines Zielpunktes hinzufügen (englischer Zonenname)
z.B.: "[G 29.93,71.2 Dun Morogh]"]=]
L["EDITOR_TOOLTIP_GUIDE_APPLIES"] = [=[Einstellen für welche Faktion/Rassen/Klassen der Guide verwendet werden kann (englische Bezeichnungen)
z.B.: "[GA Dwarf,Gnome]"]=]
L["EDITOR_TOOLTIP_HEARTH"] = [=[Der Spieler soll den Ruhestein verwenden
d.h.: "[H]"]=]
L["EDITOR_TOOLTIP_LOC"] = "Koordinaten eines zusätzlichen Punktes hinzufügen (englischer Zonenname)\\nz.B.: \\\"[L 29.93,71.2 Dun Morogh]\\\""
L["EDITOR_TOOLTIP_NAME"] = [=[Namen und Stufenbereich des Guides angeben
z.B.: "[N1-6Coldridgetal]"]=]
L["EDITOR_TOOLTIP_NEXT"] = [=[Namen und Stufenbereich des Guides angeben der auf diesen folgt
z.B.: "[NX6-12Dun Morogh]"]=]
L["EDITOR_TOOLTIP_OPTIONAL"] = [=[Den aktuellen Schritt als optional markieren
d.h.: "[O]"]=]
L["EDITOR_TOOLTIP_OPTIONAL_COMPLETE_WITH_NEXT"] = [=[Der aktuelle Schritt soll automatisch als erledigt markiert werden, sobald der darauffolgende Schritt erledigt ist
d.h.: "[OC]"]=]
L["EDITOR_TOOLTIP_QUEST"] = [=[Eine Quest hinzufügen
z.B.: "[QA179]" oder "[QC3361,2 Dilemma eines Flüchtlings]"]=]
L["EDITOR_TOOLTIP_REPAIR"] = [=[Der Spieler soll reparieren
d.h.: "[R]"]=]
L["EDITOR_TOOLTIP_SET_HEARTH"] = [=[Der Spieler soll den Ruhestein in der Taverne binden
d.h.: "[S]"]=]
L["EDITOR_TOOLTIP_TRAIN"] = [=[Der Spieler soll den Trainer aufsuchen
d.h.: "[T]"]=]
L["EDITOR_TOOLTIP_VENDOR"] = [=[Der Spieler soll verkaufen / sich neu ausrüsten
d.h.: "[V]"]=]
L["EDITOR_TOOLTIP_XP"] = [=[Bei diesem Schritt wird vom Spieler erwartet, dass eine bestimmter Stufe / ein bestimmtes Maß an Erfahrung erreicht worden ist
z.B.: "[XP8.5 die Hälfte der Stufe bis 9]"]=]
L["EDITOR_TOOLTIP_ZONE"] = "Diese Angabe ist nur für die ersten Koordinaten erforderlich. Wenn keine Zone angegeben wird, wird angenommen, dass die Zone dieselbe ist wie bei vorangehenden Koordinaten."
L["ENGLISH_NAME"] = "Name (Englisch)"
L["ERROR_CODE_NOT_RECOGNIZED"] = "Lese Guide \"%s\": Code [%s] nicht erkannt in Zeile \"%s\""
L["ERROR_CODE_ZONE_NOT_FOUND"] = "Lese Guide \"%s\": Zone nicht gefunden in Code [%s] in Zeile \"%s\""
L["ERROR_GUIDE_HAS_NO_NAME"] = "Guide hat keinen Namen"
L["ERROR_NOT_A_NUMBER"] = "%s ist keine Zahl"
L["ERROR_OUT_OF_RANGE"] = "%s ist nicht zwischen %s und %s"
L["ERROR_QUEST_CLASS_ONLY"] = "Diese Quest ist nur für die folgenden Klassen verfügbar: "
L["ERROR_QUEST_NOT_FOUND"] = "Quest \"%s\" nicht gefunden"
L["ERROR_QUEST_NOT_UNIQUE"] = "Es gibt mehr als eine Quest \"%s\". Eine der folgenden IDs angeben: "
L["ERROR_QUEST_RACE_ONLY"] = "Diese Quest ist nur für die folgenden Rassen verfügbar: "
L["ERROR_ZONE_NOT_FOUND"] = "\"%s\" ist keine Zone. Bitte einer der folgenden Zonen eingeben: "
L["ESTIMATE"] = "Dies ist nur eine geschätzte Position."
L["GENERAL_OPTIONS"] = "Allgemeine Optionen"
L["GOTO_INFO"] = "Koordinaten-Info"
L["GUIDE_FINISHED"] = "Der aktuelle Guide ist abgeschlossen. Klicke hier um einen neuen Guide auszuwählen."
L["GUIDE_FINISHED_NEXT"] = "Der aktuelle Guide ist abgeschlossen. Klicke hier um mit %s fortzufahren."
L["GUIDE_FINISHED_NEXT_ALT"] = "Alternativ kannst Du auch hier klicken um stattdessen mit %s fortzufahren."
L["GUIDE_LIST"] = "Weitere Guides sind verfügbar auf: %s"
L["GUIDE_WINDOW"] = "Guide-Fenster"
L["Horde"] = "Horde"
L["IMPORT_GUIDE"] = "Guide importieren"
L["IMPORT_GUIDE_MESSAGE"] = "Importiere einen als Text geschriebenen Guide. Quest-Namen müssen in Anführungszeichen(\"\") gesetzt werden. Es kann vorkommen, dass Quest-IDs manuell ergänzt werden müssen. Zeilen, in denen eine ID fehlt oder in denen ein anderer Fehler vorliegt, werden markiert. Wenn die Fehler beseitigt und erneut importiert wird, werden die Markierungen entfernt."
L["LEVEL"] = "Stufe"
L["LOAD_GUIDE"] = "Guide laden"
L["LOAD_MESSAGE"] = "Guidelime: Lade Guide \"%s\""
L["LOCK_ARROW"] = "Richtungspfeil feststellen"
L["LOCK_MAINFRAME"] = "Fenster feststellen"
L["MAIN_FRAME_ALPHA"] = "Fenster-Alpha"
L["MAIN_FRAME_FONT_SIZE"] = "Schriftgröße"
L["MAIN_FRAME_HEIGHT"] = "Fensterhöhe"
L["MAIN_FRAME_SHOW_SCROLLBAR"] = "Scrollbalken anzeigen"
L["MAIN_FRAME_WIDTH"] = "Fensterbreite"
L["MAP"] = "Karte"
L["MAP_MARKER_ALPHA"] = "Alpha der Kartenmarkierungen"
L["MAP_MARKER_SIZE"] = "Größe der Kartenmarkierungen"
L["MAP_MARKER_STYLE"] = "Kartenmarkierungs-Stil"
L["MAP_MARKERS_GOTO"] = "Wegpunkt-Kartenmarkierungen (%s)"
L["MAP_MARKERS_LOC"] = "Weitere Kartenmarkierungen (%s)"
L["MAX_NUM_OF_MARKERS"] = "Anzahl der Kartenmarkierungen (0 = unbegrenzt)"
L["MAX_NUM_OF_STEPS"] = "Angezeigte Schritte (0 = unbegrenzt)"
L["MAXIMUM_LEVEL"] = "Maximal-Stufe"
L["MINIMAP"] = "Minimap"
L["MINIMUM_LEVEL"] = "Minimal-Stufe"
L["MISSING_PREQUEST"] = "Folgende Quest muss noch erledigt werden:"
L["MISSING_PREQUESTS"] = "Folgende Quests müssen noch erledigt:"
L["MORE_POSITIONS"] = "weitere Positionen"
L["NAME"] = "Name"
L["NEXT"] = "Nächste"
L["NO_GUIDE_LOADED"] = "Du hast noch keinen Guide ausgewählt. Klicke hier um einen Guide auszuwählen."
L["OBJECTIVE"] = "Ziel"
L["OTHER_GUIDES"] = "Andere Guides"
L["OVERWRITE_MSG"] = "Den vorhandenen Guide \"%s\" überschreiben?"
L["PART"] = "Teil"
L["PREVIOUS"] = "Vorhergehende"
L["QUEST_ACCEPT"] = "Annehmen"
L["QUEST_ACCEPT_POS"] = "Fängt an bei"
L["QUEST_ADD_COORDINATES"] = "Koordinaten hinzufügen"
L["QUEST_ADD_COORDINATES_TOOLTIP"] = "Sofern in der Quest-Datenbank verfügbar, wird ein Koordinaten-Schritt ([G...]) hinzugefügt"
L["QUEST_CHAIN"] = "Quest-Reihe"
L["QUEST_COMPLETE"] = "Erledigen"
L["QUEST_COMPLETE_POS"] = "Erledigt durch"
L["QUEST_ID"] = "Quest-ID"
L["QUEST_ID_TOOLTIP"] = "Quest-ID. Wenn nicht angegeben wird nach einer Quest mit dem angegebenen Namen gesucht. Da der Name nicht eindeutig sein muss, kann es erforderlich sein die ID anzugeben."
L["QUEST_INFO"] = "Quest-Info"
L["QUEST_NAME"] = "Quest-Name"
L["QUEST_NAME_TOOLTIP"] = "Angezeigter Text. Wenn nicht angegeben wird der Name der Quest angezeigt. Wird \"-\" angegeben wird kein Text angezeigt."
L["QUEST_OBJECTIVE"] = "Questziel"
L["QUEST_OBJECTIVE_TOOLTIP"] = "Nummer des Questziel welches vervollständigt werden soll (1 für das Erste, 2 für das Zweite, ...). Kann angegeben werden wenn nur ein einzelnes Ziel verfolgt wird. Wenn es nicht angegeben wird, sind alle Ziele erforderlich."
L["QUEST_REQUIRED_LEVEL"] = "Mindeststufe für %s ist %s"
L["QUEST_S_TOOLTIP"] = "Verwenden wenn der Spieler darauf aufmerksam gemacht werden soll eine bestimmte Quest nicht anzunehmen"
L["QUEST_SKIP"] = "Überspringen"
L["QUEST_TURNIN"] = "Abgeben"
L["QUEST_TURNIN_POS"] = "Abgegeben bei"
L["REMOVE_ALL_COORDINATES"] = "Koordinaten entfernen"
L["REMOVE_ALL_COORDINATES_MESSAGE"] = "Alle Koordinaten-Schritte ([G...]) werden entfernt."
L["REMOVED_COORDINATES_MESSAGE"] = "%s Koordinaten wurden entfernt."
L["RESET_GUIDE"] = "Guide zurücksetzen"
L["RESET_POSITION"] = "Position zurücksetzen"
L["SAVE_GUIDE"] = "Guide speichern"
L["SAVE_MSG"] = "Guide speichern als \"%s\"?"
L["SELECT_COLORS"] = "Farben auswählen"
L["SHOW_ARROW"] = "Richtungspfeil anzeigen"
L["SHOW_COMPLETED_STEPS"] = "Abgeschlossene Schritte anzeigen"
L["SHOW_DISTANCE"] = "Entfernung anzeigen"
L["SHOW_LINE_NUMBERS"] = "Zeilennummern anzeigen"
L["SHOW_MAINFRAME"] = "Fenster anzeigen"
L["SHOW_MAP"] = "Auf der Karte anzeigen"
L["SHOW_MARKERS_ON"] = "Kartenmarkierungen anzeigen auf"
L["SHOW_MINIMUM_QUEST_LEVELS"] = "Erforderliche Stufe einer Quest anzeigen"
L["SHOW_QUEST_IDS"] = "Quest ID-Nummern anzeigen"
L["SHOW_SUGGESTED_QUEST_LEVELS"] = "Empfohlene Stufe einer Quest anzeigen"
L["SHOW_TOOLTIPS"] = "Tooltips anzeigen"
L["SHOW_UNAVAILABLE_STEPS"] = "Nicht verfügbare Schritte anzeigen"
L["SKIP_CUTSCENES"] = "Zwischensequenzen überspringen"
L["SKIPPING_QUEST"] = "Diese Quest wird übersprungen"
L["STEP_FOLLOWUP_QUEST"] = "Wenn du %s überspringst, kannst du folgende Quest später nicht erledigen"
L["STEP_FOLLOWUP_QUEST_CONT"] = "When %s später gemacht wird, wird diese Quest reaktiviert."
L["STEP_FOLLOWUP_QUESTS"] = "Wenn du %s überspringst, kannst du folgende Quests nicht erledigen"
L["STEP_FOLLOWUP_QUESTS_CONT"] = "When %s später gemacht wird, weden diese Quests reaktiviert."
L["STEP_MANUAL"] = "Hier klicken, wenn dieser Schritt erledigt ist"
L["STEP_SKIP"] = "Hier klicken, um diesen Schritt zu überspringen"
L["SUGGESTED_LEVEL"] = "Empfohlene Stufe"
L["TYPE"] = "Art"
L["URL"] = "URL"
L["USE_INTERNAL_DATA_SOURCE"] = "Interne Quest-Datenbank verwenden"
L["USE_QUESTIE_AS_DATA_SOURCE"] = "'Questie' als Datenquelle verwenden"
L["USE_QUESTIE_AS_DATA_SOURCE_TOOLTIP"] = [=[Wenn das Addon 'Questie' installiert ist, kann dieses als Datenquelle für Quest-Koordinaten genutzt werden.
Dort sind eventuell teilweise andere Informationen vorhanden, z.B. für Koordinaten von Quest-Gegnern.]=]
L["XP_LEVEL"] = "Nur Stufe"
L["XP_LEVEL-"] = "Verbleibende Punkte"
L["XP_LEVEL%"] = "Prozentualer Anteil"
L["XP_LEVEL%_TOOLTIP"] = "Der Spieler muss die angegebene Stufe sowie zusätzlich den angebenen prozentualen Anteil an Erfahrungspunkten bis zum Erreichen der nächsten Stufe erreicht haben"
L["XP_LEVEL-_TOOLTIP"] = "Dem Spieler dürfen höchstens die angegebene Anzahl Erfahrungspunkte bis zum Erreichen der angegebenen Stufe fehlen"
L["XP_LEVEL+"] = "Erhaltene Punkte"
L["XP_LEVEL+_TOOLTIP"] = "Der Spieler muss die angegebene Stufe sowie zusätzlich die angegebene Anzahl Erfahrungspunkte erreicht haben"
L["XP_TEXT"] = "Text"
L["XP_TEXT_TOOLTIP"] = "Angezeigter Text. Wenn kein Text angegeben wird, wird \"%s\" angezeigt."
L["YARDS"] = "Meter"
L["ZONE"] = "Zone"

elseif locale == "frFR" then

L.TITLE = addonName
L["ADD_QUEST_COORDINATES"] = "Ajouter les coordonnées de la quête"
L["ADD_QUEST_COORDINATES_MESSAGE"] = "Ajoute les coordonnées de toutes les étapes de la quête si elle est disponible dans la base de données de quêtes. Les coordonnées existantes de la quête seront remplacées."
L["ADDED_QUEST_COORDINATES_MESSAGE"] = "Les coordonnées de la quête %s ont été ajoutées."
L["Alliance"] = "Alliance"
L["ARROW"] = "Flèche"
L["ARROW_ALPHA"] = "Transparence de la flèche"
L["ARROW_STYLE"] = "Style de la flèche"
L["ARROW_STYLE1"] = "lime"
L["ARROW_STYLE2"] = "flèche"
L["ARROW_TOOLTIP_CORPSE"] = "Récupérez votre corps"
L["AT"] = "à"
L["AUTO_COMPLETE_QUESTS"] = "Automatiquement accepter / rendre les quêtes"
L["AUTO_SELECT_FLIGHT"] = "Sélectionner automatiquement un trajet aérien"
L["AVAILABLE_GUIDES"] = "Guides disponibles"
L["CATEGORY"] = "Catégorie "
L["CURRENT_GUIDE"] = "Guide actuel"
L["CUSTOM_GUIDES"] = "Guides personnalisés"
L["DEBUGGING"] = "Activer le mode débogage"
L["DEBUGGING_OPTIONS"] = "Options d’édition / de débogage "
L["DELETE_GUIDE"] = "Supprimer le guide"
L["DELETE_MSG"] = "Le guide \"%\" va être supprimé de vos guides personnalisés."
L["DETAILS"] = "Détails"
L["DISCARD_CHANGES"] = "Annuler les changements"
L["DISPLAY_DEMO_GUIDES"] = "Afficher les guides de démonstration"
L["DOWNLOAD_FULL_GUIDE"] = "Ceci est un guide de démonstration. Afin d'obtenir le guide complet niveau %s-%s, vous devrez installer le guide nommé %s sous forme d'addon complémentaire. Il est téléchargeable gratuitement depuis: %s"
L["EDIT_GUIDE"] = "Modifier le guide"
L["EDITOR"] = "Éditeur"
L["EDITOR_TOOLTIP_APPLIES"] = [=[Indiquer à quelle faction / races / classes s'applique l'étape actuelle,
par exemple : "[A Dwarf,Rogue]"]=]
L["EDITOR_TOOLTIP_DETAILS"] = [=[Entrer une description détaillée du guide,
par exemple : "[D Mon guide pour la zone de départ nain / gnome]"]=]
L["EDITOR_TOOLTIP_FLY"] = "Le joueur devrait prendre un trajet aérien : \"[F]\""
L["EDITOR_TOOLTIP_GET_FLIGHT_POINT"] = "Le joueur devrait prendre un nouveau point de trajet aérien : \"[P]\""
L["EDITOR_TOOLTIP_GOTO"] = [=[Ajouter les coordonnées d'une destination cible,
par exemple : "[G 29.93,71.2 Dun Morogh]"]=]
L["EDITOR_TOOLTIP_GUIDE_APPLIES"] = [=[Indiquer à quelle faction / races / classes s'applique ce guide,
par exemple : "[GA Dwarf,Gnome]"]=]
L["EDITOR_TOOLTIP_HEARTH"] = "Le joueur devrait utiliser sa pierre de foyer : \"[H]\""
L["EDITOR_TOOLTIP_LOC"] = "Ajouter les coordonnées d'un lieu supplémentaire, par exemple : \"[L 29.93,71.2 Dun Morogh]\""
L["EDITOR_TOOLTIP_NAME"] = [=[Entrer le nom et la fourchette de niveau du guide,
par exemple : "[N1-6Coldridge Valley]"]=]
L["EDITOR_TOOLTIP_NEXT"] = [=[Entrer le nom et la fourchette de niveau du guide suivant le guide actuel,
par exemple : "[NX6-12Dun Morogh]"]=]
L["EDITOR_TOOLTIP_OPTIONAL"] = "Marque l'étape actuelle comme étant optionnelle : \"[O]\""
L["EDITOR_TOOLTIP_OPTIONAL_COMPLETE_WITH_NEXT"] = "Marque l'étape actuelle pour être automatiquement complétée dès que l'étape suivante est complétée : \"[OC]\""
L["EDITOR_TOOLTIP_QUEST"] = [=[Ajouter une quête,
par exemple : "[QA179]" ou "[QC3361,2 Les malheurs d'un réfugié]"]=]
L["EDITOR_TOOLTIP_REPAIR"] = "Le joueur devrait réparer ici : \"[R]\""
L["EDITOR_TOOLTIP_SET_HEARTH"] = "Le joueur devrait lier sa pierre de foyer à l'auberge : \"[S]\""
L["EDITOR_TOOLTIP_TRAIN"] = "Le joueur devrait visiter l'entraineur de sa classe : \"[T]\""
L["EDITOR_TOOLTIP_VENDOR"] = "Le joueur devrait vendre / se réapprovisionner ici : \"[V]\""
L["EDITOR_TOOLTIP_XP"] = [=[Cette étape nécessite que le joueur ait atteint un certain niveau / une certaine quantité d'expérience du niveau actuel,
par exemple : "[XP8.5 à mi-chemin de 9]"]=]
L["EDITOR_TOOLTIP_ZONE"] = "Ce n'est pas nécessaire pour toutes les coordonnées sauf la première. Si omis, il est supposé qu'il se trouve dans la même zone que les coordonnées précédentes."
L["ENGLISH_NAME"] = "Nom anglais"
L["ERROR_CODE_NOT_RECOGNIZED"] = "Analyse du guide \"%s\" : le code [%s] n'est pas reconnu à la ligne \"%s\""
L["ERROR_CODE_ZONE_NOT_FOUND"] = "Analyse du guide \"%s\" : la zone [%s] n'est pas trouvée à la ligne \"%s\""
L["ERROR_GUIDE_HAS_NO_NAME"] = "Le guide n'a pas de nom"
L["ERROR_NOT_A_NUMBER"] = "%s n'est pas un nombre"
L["ERROR_OUT_OF_RANGE"] = "%s n'est pas entre %s et %s"
L["ERROR_QUEST_CLASS_ONLY"] = "Cette quête est seulement pour les classes suivantes :"
L["ERROR_QUEST_NOT_FOUND"] = "La quête \"%s\" n'a pas été trouvée"
L["ERROR_QUEST_NOT_UNIQUE"] = "Il y a plus d'une fois la quête \"%s\". Entrer un de ces identifiants :"
L["ERROR_QUEST_RACE_ONLY"] = "Cette quête est seulement pour les races suivantes :"
L["ERROR_ZONE_NOT_FOUND"] = "\"%s\" n'est pas une zone. Entrer un de ces noms de zone :"
L["ESTIMATE"] = "Ceci n'est qu'une estimation du lieu"
L["GENERAL_OPTIONS"] = "Options générales"
L["GOTO_INFO"] = "Coordonnées"
L["GUIDE_FINISHED"] = "Le guide actuel est terminé. Cliquer ici pour charger un autre guide."
L["GUIDE_FINISHED_NEXT"] = "Le guide actuel est terminé. Cliquer ici pour continuer avec %s."
L["GUIDE_FINISHED_NEXT_ALT"] = "Vous pouvez également choisir de cliquer ici pour continuer votre route avec %s."
L["GUIDE_LIST"] = "Plus de guides sont disponibles sur: %s"
L["GUIDE_WINDOW"] = "Panneau du guide"
L["Horde"] = "Horde"
L["IMPORT_GUIDE"] = "Importer le guide"
L["IMPORT_GUIDE_MESSAGE"] = "Importer un guide écrit en texte brut. Le nom des quêtes doit être entre guillemets (\"\"). De temps en temps, l'identifiant de quête correct (numéro ID) doit être ajouté manuellement. Les lignes avec un identifiant manquant ou d'autres erreurs seront marquées. Les erreurs sont supprimées lorsque vous corrigez les erreurs et que vous cliquez de nouveau sur importer le guide."
L["LEVEL"] = "Niveau"
L["LOAD_GUIDE"] = "Charger le guide"
L["LOAD_MESSAGE"] = "Guidelime : Chargement du guide \"%s\""
L["LOCK_ARROW"] = "Verrouiller la flèche"
L["LOCK_MAINFRAME"] = "Verrouiller la fenêtre"
L["MAIN_FRAME_ALPHA"] = "Transparence de la fenêtre"
L["MAIN_FRAME_FONT_SIZE"] = "Taille de la police"
L["MAIN_FRAME_HEIGHT"] = "Hauteur de la fenêtre"
L["MAIN_FRAME_SHOW_SCROLLBAR"] = "Afficher la barre de défilement"
L["MAIN_FRAME_WIDTH"] = "Largeur de la fenêtre"
L["MAP"] = "carte"
L["MAP_MARKER_ALPHA"] = "Opacité des indications de carte"
L["MAP_MARKER_SIZE"] = "Taille des indications de carte"
L["MAP_MARKER_STYLE"] = "Style des indications de carte"
L["MAP_MARKERS_GOTO"] = "Indications de destinations (%s)"
L["MAP_MARKERS_LOC"] = "Indications supplémentaires de lieux (%s)"
L["MAX_NUM_OF_MARKERS"] = "Nombre d'indications de carte (0 = illimitées)"
L["MAX_NUM_OF_STEPS"] = "Nombre d'étapes affichées (0 = illimité)"
L["MAXIMUM_LEVEL"] = "Niveau maximum"
L["MINIMAP"] = "minimap"
L["MINIMUM_LEVEL"] = "Niveau minimum "
L["MISSING_PREQUEST"] = "La quête suivante a été passée :"
L["MISSING_PREQUESTS"] = "Les quêtes suivantes ont été passées :"
L["MORE_POSITIONS"] = "emplacements supplémentaires"
L["NAME"] = "Nom "
L["NEXT"] = "Suivant"
L["NO_GUIDE_LOADED"] = "Vous n'avez pas sélectionné de guide. Cliquez ici pour charger un guide."
L["OBJECTIVE"] = "Objectif "
L["OTHER_GUIDES"] = "Autres guides"
L["OVERWRITE_MSG"] = "Écraser le guide existant \"%s\" ?"
L["PART"] = "partie"
L["PREVIOUS"] = "Précédent"
L["QUEST_ACCEPT"] = "Accepter"
L["QUEST_ACCEPT_POS"] = "Commencée avec"
L["QUEST_ADD_COORDINATES"] = "Ajouter des coordonnées"
L["QUEST_ADD_COORDINATES_TOOLTIP"] = "Si les coordonnées d'une étape de quête sont présentes dans la base de données de quêtes, une étape de déplacement sera créée."
L["QUEST_CHAIN"] = "Suite de quête"
L["QUEST_COMPLETE"] = "Compléter"
L["QUEST_COMPLETE_POS"] = "Complétée avec"
L["QUEST_ID"] = "Identifiant de la quête"
L["QUEST_ID_TOOLTIP"] = "Identifiant de la quête. Si omis, une quête du nom donné est recherchée. Comme les noms peuvent être ambigus, vous devrez peut-être entrer l'identifiant de la quête."
L["QUEST_INFO"] = "Quête"
L["QUEST_NAME"] = "Nom de la quête"
L["QUEST_NAME_TOOLTIP"] = "Texte à afficher. Si omis, le nom de la quête sera affiché. Si \"-\" est entré aucun texte ne s'affichera."
L["QUEST_OBJECTIVE"] = "Objectif de la quête"
L["QUEST_OBJECTIVE_TOOLTIP"] = "Nombre d'objectifs à compléter (1 pour le premier, 2 pour le second...). Peut être spécifié quand un seul objectif doit être suivi. Si omis, tous les objectifs sont requis."
L["QUEST_REQUIRED_LEVEL"] = "Le niveau requis pour %s est %s"
L["QUEST_S_TOOLTIP"] = "Ne l'utilisez que pour indiquer au joueur de ne pas accepter une quête précise"
L["QUEST_SKIP"] = "Passer"
L["QUEST_TURNIN"] = "Rendre"
L["QUEST_TURNIN_POS"] = "Rendue à"
L["REMOVE_ALL_COORDINATES"] = "Supprimer toutes les coordonnées"
L["REMOVE_ALL_COORDINATES_MESSAGE"] = "Toutes les étapes de coordonnées ([G...]) seront supprimées."
L["REMOVED_COORDINATES_MESSAGE"] = "%s coordonnées ont été supprimées."
L["RESET_GUIDE"] = "Réinitialiser le guide"
L["RESET_POSITION"] = "Réinitialiser la position"
L["SAVE_GUIDE"] = "Enregistrer le guide"
L["SAVE_MSG"] = "Enregistrer le guide sous \"%s\" ?"
L["SELECT_COLORS"] = "Choisir les couleurs"
L["SHOW_ARROW"] = "Afficher la flèche"
L["SHOW_COMPLETED_STEPS"] = "Afficher les étapes terminées"
L["SHOW_DISTANCE"] = "Afficher la distance"
L["SHOW_LINE_NUMBERS"] = "Afficher la numérotation des lignes"
L["SHOW_MAINFRAME"] = "Afficher la fenêtre"
L["SHOW_MAP"] = "Afficher sur la carte"
L["SHOW_MARKERS_ON"] = "Afficher les indications de carte"
L["SHOW_MINIMUM_QUEST_LEVELS"] = "Affiche le niveau minimum d'une quête"
L["SHOW_QUEST_IDS"] = "Afficher l'ID des quêtes"
L["SHOW_SUGGESTED_QUEST_LEVELS"] = "Afficher le niveau recommandé d'une quête"
L["SHOW_TOOLTIPS"] = "Afficher les infobulles"
L["SHOW_UNAVAILABLE_STEPS"] = "Afficher les étapes non disponibles"
L["SKIP_CUTSCENES"] = "Passer les cinématiques"
L["STEP_FOLLOWUP_QUEST"] = "Si vous passez la quête %s vous n'aurez pas accès à la quête suivante plus tard"
L["STEP_FOLLOWUP_QUEST_CONT"] = "Quand vous ferez %s plus tard, cette quête sera réactivée."
L["STEP_FOLLOWUP_QUESTS"] = "Si vous passez la quête %s vous n'aurez accès aux quêtes suivantes plus tard"
L["STEP_FOLLOWUP_QUESTS_CONT"] = "Quand vous ferez %s plus tard, ces quêtes seront réactivées."
L["STEP_MANUAL"] = "Cliquez ici lorsque vous avez complété cette étape"
L["STEP_SKIP"] = "Cliquez ici pour passer cette étape"
L["SUGGESTED_LEVEL"] = "Niveau recommandé"
L["TYPE"] = "Type"
L["URL"] = "URL"
L["USE_INTERNAL_DATA_SOURCE"] = "Utiliser la base de données de quêtes interne de Guidelime"
L["USE_QUESTIE_AS_DATA_SOURCE"] = "Utiliser \"Questie\" comme base de données de quêtes interne"
L["USE_QUESTIE_AS_DATA_SOURCE_TOOLTIP"] = "Quand l'addon \"Questie\" est installé, il peut être utilisé comme source de données pour les coordonnées de quêtes. Il peut contenir plus de données que la base de données interne de quêtes de Guidelime avec par exemple les emplacements de spawn de mobs de quêtes."
L["WORD_LIST_ACCEPT"] = "accepter ; prendre ; prenez ; acceptez ; accepte ; prends"
L["XP_LEVEL"] = "Niveau seulement"
L["XP_LEVEL-"] = "Points d'expérience restants"
L["XP_LEVEL%"] = "Pourcentage"
L["XP_LEVEL%_TOOLTIP"] = "Le joueur doit avoir atteint le niveau spécifié et doit avoir obtenu le pourcentage spécifié de points d'expérience vers le niveau suivant"
L["XP_LEVEL-_TOOLTIP"] = "Le joueur doit avoir au plus la quantité de points d'expérience restants spécifiée pour atteindre le niveau spécifié"
L["XP_LEVEL+"] = "Points d'expérience obtenus"
L["XP_LEVEL+_TOOLTIP"] = "Le joueur doit avoir atteint le niveau spécifié et doit avoir obtenu la quantité spécifiée de points d'expérience"
L["XP_TEXT"] = "Texte"
L["XP_TEXT_TOOLTIP"] = "Texte à afficher. Si omis, cette élément s'affichera comme \"%s\"."
L["YARDS"] = "mètres"
L["ZONE"] = "Zone"

elseif locale == "ruRU" then

L.TITLE = addonName
L["ADD_QUEST_COORDINATES"] = "Добавить координаты задания"
L["ADD_QUEST_COORDINATES_MESSAGE"] = "Добавляет координаты ко всем заданиям, если они доступны в базе данных. Существующие координаты заданий будут заменены."
L["ADDED_QUEST_COORDINATES_MESSAGE"] = "%s координат(а) добавлено."
L["Alliance"] = "Альянс"
L["ARROW"] = "Стрела"
L["ARROW_ALPHA"] = "Прозрачность стрелы "
L["ARROW_STYLE"] = "Стиль стрелы "
L["ARROW_STYLE1"] = "лайм "
L["ARROW_STYLE2"] = "стрела "
L["ARROW_TOOLTIP_CORPSE"] = "Бежать к вашему трупу"
L["AT"] = "в "
L["AUTO_COMPLETE_QUESTS"] = "Автоматически принимать/сдавать задания"
L["AUTO_SELECT_FLIGHT"] = "Автоматически выбирать путь полёта"
L["AVAILABLE_GUIDES"] = "Библиотека руководств "
L["CATEGORY"] = "Категория"
L["CURRENT_GUIDE"] = "Текущее руководство "
L["CUSTOM_GUIDES"] = "Пользовательские руководства "
L["DEBUGGING"] = "Включить режим отладки"
L["DEBUGGING_OPTIONS"] = "Опции редактирования / отладки"
L["DELETE_GUIDE"] = "Удалить руководство "
L["DELETE_MSG"] = "Руководство \"%s\" будет удалено."
L["DETAILS"] = "Описание"
L["DISCARD_CHANGES"] = "Отменить ввод"
L["DISPLAY_DEMO_GUIDES"] = "Отображать пробные руководства"
L["DOWNLOAD_FULL_GUIDE"] = "Это пробное руководство. Чтобы получить полную версию %s-%s вам нужно установить модуль %s. Он может быть загружен бесплатно с: %s"
L["EDIT_GUIDE"] = "Редактировать"
L["EDITOR"] = "Редактирование"
L["EDITOR_TOOLTIP_APPLIES"] = "Укажите, к какой фракции/рассе/классу применяется текущий шаг (на английском), например: \"[A Dwarf,Rogue]\""
L["EDITOR_TOOLTIP_DETAILS"] = "Введите подробное описание руководства, например: \"[D Моё личное руководство по начальной локации Дворфа/Разбойника]\""
L["EDITOR_TOOLTIP_FLY"] = "Игрок должен воспользоваться воздушным такси. \"[F]\""
L["EDITOR_TOOLTIP_GET_FLIGHT_POINT"] = "Игрок должен выучить новую точку полёта. \"[P]\""
L["EDITOR_TOOLTIP_GOTO"] = "Добавить маркер со стрелкой (на английском), например: \"[G 29.93,71.2 Dun Morogh]\""
L["EDITOR_TOOLTIP_GUIDE_APPLIES"] = "Укажите, к какой фракции/рассе/классу относится это руководство (на английском), например: \"[GA Dwarf,Rogue]\""
L["EDITOR_TOOLTIP_HEARTH"] = "Игрок должен воспользоваться камнем возвращения. \"[H]\""
L["EDITOR_TOOLTIP_LOC"] = "Добавить маркер без стрелки (на английском), например: \"[L 29.93,71.2 Dun Morogh]\""
L["EDITOR_TOOLTIP_NAME"] = "Укажите название и диапазон уровней для руководства, например: \"[N1-6Дун Морог]\""
L["EDITOR_TOOLTIP_NEXT"] = "Укажите название и диапазон уровней следующего руководства, например: \"[NX6-12Дун Морог]\""
L["EDITOR_TOOLTIP_OPTIONAL"] = "Пометить текущий шаг, как необязательный. \"[O]\""
L["EDITOR_TOOLTIP_OPTIONAL_COMPLETE_WITH_NEXT"] = "Пометить текущий шаг, для автоматического завершения после выполнения следующего шага. \"[OC]\""
L["EDITOR_TOOLTIP_QUEST"] = "Добавить задание, например: \"[QA179]\" или \"[QC3361,2 A Refugee's Quandary]\""
L["EDITOR_TOOLTIP_REPAIR"] = "Здесь игрок может починить экипировку. \"[R]\""
L["EDITOR_TOOLTIP_SET_HEARTH"] = "Игрок должен установить камень возвращения. \"[S]\""
L["EDITOR_TOOLTIP_TRAIN"] = "Игрок должен посетить тренера. \"[T]\""
L["EDITOR_TOOLTIP_VENDOR"] = "Здесь игрок может продать/купить предметы. \"[V]\""
L["EDITOR_TOOLTIP_XP"] = "Указать, какого уровня следует быть игроку, а также количество необходимого опыта, например: \"[XP3+150]\""
L["EDITOR_TOOLTIP_ZONE"] = "Это не обязательно. Но если пропустить, координаты будут указаны для той же локации, что и прежде."
L["ENGLISH_NAME"] = "Английское название"
L["ERROR_CODE_NOT_RECOGNIZED"] = "Ошибка синтаксиса в руководстве \"%s\": не распознанный код [%s] на строке \"%s\""
L["ERROR_CODE_ZONE_NOT_FOUND"] = "Ошибка синтаксиса \"%s\": неправильное название локации в коде [%s] на строке \"%s\""
L["ERROR_GUIDE_HAS_NO_NAME"] = "Укажите название руководства"
L["ERROR_NOT_A_NUMBER"] = "%s введите число"
L["ERROR_OUT_OF_RANGE"] = "%s не верное число, пожалуйста введите число между %s и %s"
L["ERROR_QUEST_CLASS_ONLY"] = "Это задание доступно только для следующих классов:"
L["ERROR_QUEST_NOT_FOUND"] = "Задание \"%s\" не найдено"
L["ERROR_QUEST_NOT_UNIQUE"] = "Существует более одного задания с названием \"%s\". Введите id задания:"
L["ERROR_QUEST_RACE_ONLY"] = "Это задание доступно только для следующих расс:"
L["ERROR_ZONE_NOT_FOUND"] = "\"%s\" неверное название локации. Введите одно из этих:"
L["ESTIMATE"] = "Это только оценочная позиция"
L["GENERAL_OPTIONS"] = "Основные настройки"
L["GOTO_INFO"] = "Информация о координатах"
L["GUIDE_FINISHED"] = "Текущее руководство закончилось. Нажмите здесь, чтобы загрузить другое."
L["GUIDE_FINISHED_NEXT"] = "Текущее руководство закончилось. Нажмите здесь, чтобы продолжить с %s."
L["GUIDE_FINISHED_NEXT_ALT"] = "Вы также можете нажать здесь, чтобы продолжить с %s."
L["GUIDE_LIST"] = "Дополнительные руководства: %s"
L["GUIDE_WINDOW"] = "Настройки окна"
L["Horde"] = "Орда"
L["IMPORT_GUIDE"] = "Исправление синтаксиса"
L["IMPORT_GUIDE_MESSAGE"] = "Импортируйте руководство, в виде текста. Названия заданий должны быть в кавычках (\"\"). Из за одинаковых названий иногда задания необходимо добавлять вручную. Строки с отсутствующими id или другими ошибками будут отмечены."
L["LEVEL"] = "Уровень"
L["LOAD_GUIDE"] = "Загрузить руководство"
L["LOAD_MESSAGE"] = "Guidelime: Загружаю руководство \"%s\""
L["LOCK_ARROW"] = "Заблокировать стрелу"
L["LOCK_MAINFRAME"] = "Заблокировать окно"
L["MAIN_FRAME_ALPHA"] = "Прозрачность окна"
L["MAIN_FRAME_FONT_SIZE"] = "Размер шрифта"
L["MAIN_FRAME_HEIGHT"] = "Высота окна"
L["MAIN_FRAME_SHOW_SCROLLBAR"] = "Показать полосу прокрутки"
L["MAIN_FRAME_WIDTH"] = "Ширина окна"
L["MAP"] = "карте"
L["MAP_MARKER_ALPHA"] = "Прозрачность маркера"
L["MAP_MARKER_SIZE"] = "Размер маркера"
L["MAP_MARKER_STYLE"] = "Стиль маркера"
L["MAP_MARKERS_GOTO"] = "Направляющие маркеры"
L["MAP_MARKERS_LOC"] = "Дополнительные маркеры"
L["MAX_NUM_OF_MARKERS"] = "Количество маркеров (0 = не ограниченно)"
L["MAX_NUM_OF_STEPS"] = "Отображаемых шагов (0 = не ограниченно)"
L["MAXIMUM_LEVEL"] = "Макс-ый уровень"
L["MINIMAP"] = "миникарте"
L["MINIMUM_LEVEL"] = "Мин-ый уровень"
L["MISSING_PREQUEST"] = "Следующее задание было пропущено:"
L["MISSING_PREQUESTS"] = "Следующие задания были пропущены:"
L["MORE_POSITIONS"] = "позиций"
L["NAME"] = "Название"
L["NEXT"] = "Следующий"
L["NO_GUIDE_LOADED"] = "Нажмите здесь, чтобы выбрать руководство."
L["OBJECTIVE"] = "Цель"
L["OTHER_GUIDES"] = "Другие руководства"
L["OVERWRITE_MSG"] = "Перезаписать текущее руководство \"%s\"?"
L["PART"] = "часть"
L["PREVIOUS"] = "Предыдущий "
L["QUEST_ACCEPT"] = "Принять"
L["QUEST_ACCEPT_POS"] = "Начинает"
L["QUEST_ADD_COORDINATES"] = "Добавить координаты"
L["QUEST_ADD_COORDINATES_TOOLTIP"] = "Если координаты для задания присутствуют в базе данных, к этому шагу будет добавлена стрелка."
L["QUEST_CHAIN"] = "Цепочка заданий"
L["QUEST_COMPLETE"] = "Завершить"
L["QUEST_COMPLETE_POS"] = "Для выполнения"
L["QUEST_ID"] = "ID задания"
L["QUEST_ID_TOOLTIP"] = "ID задания. В случае если существует несколько заданий с похожим названием."
L["QUEST_INFO"] = "Информация о задании"
L["QUEST_NAME"] = "Название задания"
L["QUEST_NAME_TOOLTIP"] = "Отображаемый в окне текст. Если написать \"-\" ничего не отобразится"
L["QUEST_OBJECTIVE"] = "Цель задания"
L["QUEST_OBJECTIVE_TOOLTIP"] = "Количество целей которые необходимо выполнить (1 для первой, 2 для второй, ...). Можно использовать когда нужно отслеживать одну цель."
L["QUEST_REQUIRED_LEVEL"] = "Рекомендуемый уровень для %s %s"
L["QUEST_S_TOOLTIP"] = "Используйте это для того, чтобы указать игроку не принимать задание."
L["QUEST_SKIP"] = "Пропуск"
L["QUEST_TURNIN"] = "Сдать"
L["QUEST_TURNIN_POS"] = "Заканчивает"
L["REMOVE_ALL_COORDINATES"] = "Удалить координаты"
L["REMOVE_ALL_COORDINATES_MESSAGE"] = "Координаты со всех шагов ([G...]) будут удалены."
L["REMOVED_COORDINATES_MESSAGE"] = "%s координат(а) удалено."
L["RESET_GUIDE"] = "Восстановить"
L["RESET_POSITION"] = "Сброс позиции"
L["SAVE_GUIDE"] = "Сохранить руководство"
L["SAVE_MSG"] = "Сохранить как \"%s\"?"
L["SELECT_COLORS"] = "Выбрать цвет"
L["SHOW_ARROW"] = "Отображать стрелу"
L["SHOW_COMPLETED_STEPS"] = "Отображать выполненные шаги"
L["SHOW_DISTANCE"] = "Отображать расстояние"
L["SHOW_LINE_NUMBERS"] = "Нумерация строк"
L["SHOW_MAINFRAME"] = "Показать окно"
L["SHOW_MAP"] = "Показать на карте"
L["SHOW_MARKERS_ON"] = "Отображать маркеры на"
L["SHOW_MINIMUM_QUEST_LEVELS"] = "Минимальный уровень для задания"
L["SHOW_QUEST_IDS"] = "Показать ID задания"
L["SHOW_SUGGESTED_QUEST_LEVELS"] = "Рекомендуемый уровень для задания"
L["SHOW_TOOLTIPS"] = "Показывать подсказки"
L["SHOW_UNAVAILABLE_STEPS"] = "Отображать пропущенные шаги"
L["SKIP_CUTSCENES"] = "Пропускать видео заставки "
L["STEP_FOLLOWUP_QUEST"] = "Если вы пропустите %s вы не сможете выполнить следующее задание"
L["STEP_FOLLOWUP_QUEST_CONT"] = "Вы можете выполнить %s позже, шаги по выполнению появятся заново."
L["STEP_FOLLOWUP_QUESTS"] = "Если вы пропустите %s вы не сможете выполнить следующие задания"
L["STEP_FOLLOWUP_QUESTS_CONT"] = "Вы можете выполнить %s позже, шаги по выполнению появятся заново."
L["STEP_MANUAL"] = "Нажмите здесь, после выполнения этого шага"
L["STEP_SKIP"] = "Нажмите здесь, для пропуска этого шага"
L["SUGGESTED_LEVEL"] = "Рекомендуемый уровень"
L["TYPE"] = "Тип"
L["URL"] = "URL"
L["USE_INTERNAL_DATA_SOURCE"] = "Использовать внутреннюю базу данных"
L["USE_QUESTIE_AS_DATA_SOURCE"] = "Использовать 'Questie' как базу данных"
L["USE_QUESTIE_AS_DATA_SOURCE_TOOLTIP"] = [=[Если установлен 'Questie', его можно использовать в качестве источника данных для координат заданий. Он может содержать информацию, отличную от внутренней базы данных заданий, например для мест появления нпц.
]=]
L["WORD_LIST_ACCEPT"] = "принять ; достать ; поднять ; выбрать .- вверх ; взять"
L["WORD_LIST_COMPLETE"] = "сделать ;  завершить ; убить ; обыскать ; закончить"
L["WORD_LIST_COMPLETE_LAST"] = "( завершить )это( );( закончить )это( )"
L["WORD_LIST_COMPLETE_LAST_TWO"] = "( завершить )оба( );( закончить )оба( )"
L["WORD_LIST_FLY"] = "( лететь к )%a+( );( )(лететь )"
L["XP_LEVEL"] = "Только уровень"
L["XP_LEVEL-"] = "Опыта осталось"
L["XP_LEVEL%"] = "Процент"
L["XP_LEVEL%_TOOLTIP"] = "Игрок должен иметь определённый процент опыта до следующего уровня"
L["XP_LEVEL-_TOOLTIP"] = "Игроку должно не хватать определённого количества очков опыта до следующего уровня"
L["XP_LEVEL+"] = "Опыта получено"
L["XP_LEVEL+_TOOLTIP"] = "Игрок должен иметь определённое количество очков опыта до следующего уровня"
L["XP_TEXT"] = "Текст"
L["XP_TEXT_TOOLTIP"] = "Текст который будет отображен. Если пропустить будет \"%s\"."
L["YARDS"] = "метров"
L["ZONE"] = "Локация"

elseif locale == "esES" then

L.TITLE = addonName
L["ADD_QUEST_COORDINATES"] = "Agregar coordenadas de misión."
L["ADD_QUEST_COORDINATES_MESSAGE"] = "Agrega coordenadas a todos los pasos de la misión si están disponibles en la base de datos. Las coordenadas existentes serán reemplazadas."
L["ADDED_QUEST_COORDINATES_MESSAGE"] = "Se han agregado las coordenadas de la misión %s"
L["Alliance"] = "Alianza"
L["ARROW"] = "Flecha"
L["ARROW_ALPHA"] = "Transparencia de flecha"
L["ARROW_STYLE"] = "Estilo de flecha"
L["ARROW_STYLE1"] = "Lima"
L["ARROW_STYLE2"] = "flecha"
L["ARROW_TOOLTIP_CORPSE"] = "Ve a tu cuerpo"
L["AT"] = "a"
L["AUTO_COMPLETE_QUESTS"] = "Automáticamente aceptar/entregar misiones"
L["AUTO_SELECT_FLIGHT"] = "Automáticamente seleccionar una ruta de vuelo"
L["AVAILABLE_GUIDES"] = "Guías disponibles"
L["CATEGORY"] = "Categoría"
L["CURRENT_GUIDE"] = "Guía actual"
L["CUSTOM_GUIDES"] = "Guías personalizadas"
L["DEBUGGING"] = "Habilitar modo depuración"
L["DEBUGGING_OPTIONS"] = "Editando / Opciones de depuración"
L["DELETE_GUIDE"] = "Borrar guía"
L["DELETE_MSG"] = "La guía \"%s\" sera borrada de tus guías personalizadas."
L["DETAILS"] = "Detalles"
L["DISCARD_CHANGES"] = "Descartar cambios"
L["DISPLAY_DEMO_GUIDES"] = "Mostrar guías de demostración"
L["DOWNLOAD_FULL_GUIDE"] = "Esto es solamente una demostración. Para obtener la guía %s-%s completa deberás instalar el Addon %s. Este se puede descargar gratuitamente de: %s"
L["EDIT_GUIDE"] = "Editar guía"
L["EDITOR"] = "Editor"
L["EDITOR_TOOLTIP_APPLIES"] = "Establece a cual facción/raza/clase se aplica al paso actual. Ej.: \"[Enano,Ladrón]\""
L["EDITOR_TOOLTIP_DETAILS"] = "Ingrese la descripción detallada de la guía, Ej: \"[Mi guía personal para la zona de inicio de gnomos/enanos]\""
L["EDITOR_TOOLTIP_FLY"] = "El jugador debe tomar un vuelo. Es decir: \"[F]\""
L["EDITOR_TOOLTIP_GET_FLIGHT_POINT"] = "El jugador debe obtener un nuevo punto de vuelo, Es decir: \"[P]\""
L["EDITOR_TOOLTIP_GOTO"] = "Agregar coordenadas de una ubicación de destino, por ejemplo: \"[G 29.93,71.2 Dun Morogh]\""
L["EDITOR_TOOLTIP_GUIDE_APPLIES"] = "Establece a qué facción/raza/clase se aplica esta guía, por ejemplo: \"[Enano, Gnomo]\""
L["EDITOR_TOOLTIP_HEARTH"] = "El jugador debe usar la piedra de hogar, es decir: \"[H]\""
L["EDITOR_TOOLTIP_LOC"] = "Agregue coordenadas de una ubicación adicional, por ejemplo: \"[L 29.93,71.2 Dun Morogh]\""
L["EDITOR_TOOLTIP_NAME"] = "Establezca el nombre y el rango de nivel de la guía, por ejemplo: \"[N1-6 Valle de Crestanevada]\""
L["EDITOR_TOOLTIP_NEXT"] = "Establezca el nombre y el rango de nivel de la siguiente guía siguiendo la guía actual, por ejemplo: \"[NX6-12Dun Morogh]\""
L["EDITOR_TOOLTIP_OPTIONAL"] = "Marque el paso actual como opcional, es decir: \"[O]\""
L["EDITOR_TOOLTIP_OPTIONAL_COMPLETE_WITH_NEXT"] = "Marque el paso actual para que se complete automáticamente cada vez que se complete el siguiente paso, es decir: \"[OC]\""
L["EDITOR_TOOLTIP_QUEST"] = "Agregue una búsqueda, por ejemplo: \"[QA179]\" o \"[QC3361,2 Las penurias de un refugiado]\""
L["EDITOR_TOOLTIP_REPAIR"] = "El jugador debe reparar aquí, es decir: \"[R]\""
L["EDITOR_TOOLTIP_SET_HEARTH"] = "El jugador debe establecer la piedra de hogar en la posada, es decir: \"[S]\""
L["EDITOR_TOOLTIP_TRAIN"] = "El jugador debe visitar al entrenador, es decir: \"[T]\""
L["EDITOR_TOOLTIP_VENDOR"] = "El jugador debe vender / reabastecerse aquí, es decir: \"[V]\""
L["EDITOR_TOOLTIP_XP"] = "Este paso requiere que el jugador haya alcanzado un cierto nivel / cantidad de experiencia en el nivel actual, por ejemplo: \"[XP8.5 a medio camino de 9]\""
L["EDITOR_TOOLTIP_ZONE"] = "Esto no es necesario para todas las coordenadas excepto las primeras. Si se omite, se supone que está en la misma zona que las coordenadas anteriores."
L["ENGLISH_NAME"] = "Nombre en inglés"
L["ERROR_CODE_NOT_RECOGNIZED"] = "Análisis de guía \"%s\": código [%s] no reconocido en la línea \"%s\""
L["ERROR_CODE_ZONE_NOT_FOUND"] = "Análisis de guía \"%s\": zona no encontrada en el código [%s] en la línea \"%s\""
L["ERROR_GUIDE_HAS_NO_NAME"] = "La guía no tiene nombre"
L["ERROR_NOT_A_NUMBER"] = "%s no es un número"
L["ERROR_OUT_OF_RANGE"] = "%s no está entre %s y %s"
L["ERROR_QUEST_CLASS_ONLY"] = "Esta misión es solo para las siguientes clases:"
L["ERROR_QUEST_NOT_FOUND"] = "La misión \"%s\" no se encontró"
L["ERROR_QUEST_NOT_UNIQUE"] = "Hay más de una misión \"%s\". Ingrese uno de estos ids:"
L["ERROR_QUEST_RACE_ONLY"] = "Esta misión es solo para las siguientes razas:"
L["ERROR_ZONE_NOT_FOUND"] = "\"%s\" no es una zona. Ingrese uno de estos nombres de zona:"
L["ESTIMATE"] = "Esta es una posición estimada solamente."
L["GENERAL_OPTIONS"] = "Opciones generales"
L["GOTO_INFO"] = "Información de coordenadas"
L["GUIDE_FINISHED"] = "Su guía actual ha sido terminada. Haga clic aquí para cargar otra guía."
L["GUIDE_FINISHED_NEXT"] = "Su guía actual ha sido terminada. Haga clic aquí para continuar con %s."
L["GUIDE_FINISHED_NEXT_ALT"] = "Alternativamente, puede elegir hacer clic aquí para continuar con %s."
L["GUIDE_LIST"] = "Más guías están disponibles en: %s"
L["GUIDE_WINDOW"] = "Ventana de guía"
L["Horde"] = "Horda"
L["IMPORT_GUIDE"] = "Importar guía"
L["IMPORT_GUIDE_MESSAGE"] = "Importar una guía escrita en texto plano. Los nombres de las misiones deben estar entre comillas (\"\"). Ocasionalmente, las ID de misiones correctas deben agregarse manualmente. Se marcarán las líneas con ID faltantes u otros errores. Las marcas se eliminan cuando se corrijan los errores y se importe nuevamente."
L["LEVEL"] = "Nivel"
L["LOAD_GUIDE"] = "Cargar guía"
L["LOAD_MESSAGE"] = "Guidelime: cargando la guía \"%s\""
L["LOCK_ARROW"] = "Bloquear flecha"
L["LOCK_MAINFRAME"] = "Bloquear ventana"
L["MAIN_FRAME_ALPHA"] = "Transparencia de ventana"
L["MAIN_FRAME_FONT_SIZE"] = "Tamaño de fuente."
L["MAIN_FRAME_HEIGHT"] = "Altura de ventana"
L["MAIN_FRAME_SHOW_SCROLLBAR"] = "Mostrar barra de desplazamiento"
L["MAIN_FRAME_WIDTH"] = "Ancho de ventana"
L["MAP"] = "mapa"
L["MAP_MARKER_ALPHA"] = "Transparencia del marcador de mapa"
L["MAP_MARKER_SIZE"] = "Tamaño del marcador de mapa"
L["MAP_MARKER_STYLE"] = "Estilo del marcador de mapa"
L["MAP_MARKERS_GOTO"] = "Marcadores de puntos de referencia (%s)"
L["MAP_MARKERS_LOC"] = "Marcadores adicionales (%s)"
L["MAX_NUM_OF_MARKERS"] = "Número de marcadores (0 = ilimitado)"
L["MAX_NUM_OF_STEPS"] = "Número de pasos mostrados (0 = ilimitado)"
L["MAXIMUM_LEVEL"] = "Nivel maximo"
L["MINIMAP"] = "Minimapa"
L["MINIMUM_LEVEL"] = "Nivel mínimo"
L["MISSING_PREQUEST"] = "Se omitió la siguiente misión:"
L["MISSING_PREQUESTS"] = "Se omitieron las siguientes misiones:"
L["MORE_POSITIONS"] = "mas posiciones"
L["NAME"] = "Nombre"
L["NEXT"] = "Siguiente"
L["NO_GUIDE_LOADED"] = "Aún no ha seleccionado una guía. Haga clic aquí para comenzar cargando una guía."
L["OBJECTIVE"] = "Objetivo"
L["OTHER_GUIDES"] = "Otras guías"
L["OVERWRITE_MSG"] = "¿Sobrescribir la guía existente \"%s\"?"
L["PART"] = "parte"
L["PREVIOUS"] = "Anterior"
L["QUEST_ACCEPT"] = "Aceptar"
L["QUEST_ACCEPT_POS"] = "Iniciado por"
L["QUEST_ADD_COORDINATES"] = "Agregar coordenadas"
L["QUEST_ADD_COORDINATES_TOOLTIP"] = "Si las coordenadas para un paso de misión están presentes en la base de datos de misiones, se agregará un paso al siguiente."
L["QUEST_CHAIN"] = "Cadena de misiones"
L["QUEST_COMPLETE"] = "Completa"
L["QUEST_COMPLETE_POS"] = "Completada con"
L["QUEST_ID"] = "Id de misión"
L["QUEST_ID_TOOLTIP"] = "Id de misión. Si se omite, una misión del nombre especificado sera buscada. Como los nombres pueden ser ambiguos, es posible que deba ingresar el id de misión."
L["QUEST_INFO"] = "Información de la misión"
L["QUEST_NAME"] = "Nombre de la misión"
L["QUEST_NAME_TOOLTIP"] = "Texto a mostrar. Si se omite, se mostrará el nombre de la misión. Si esto es \"-\" no se mostrará ningún texto"
L["QUEST_OBJECTIVE"] = "Objetivo de la misión"
L["QUEST_OBJECTIVE_TOOLTIP"] = "Número del objetivo que debe completarse (1 para el primero, 2 para el segundo, ...). Se puede especificar cuando solo se debe rastrear un único objetivo. Si se omite, se requieren todos los objetivos."
L["QUEST_REQUIRED_LEVEL"] = "El nivel requerido para %s es %s"
L["QUEST_S_TOOLTIP"] = "Solo use esto para indicarle al jugador que no debe aceptar una determinada misión"
L["QUEST_SKIP"] = "Omitir"
L["QUEST_TURNIN"] = "Entregar"
L["QUEST_TURNIN_POS"] = "Entregado a"
L["REMOVE_ALL_COORDINATES"] = "Eliminar todas las coordenadas"
L["REMOVE_ALL_COORDINATES_MESSAGE"] = "Se eliminarán todos los pasos de coordenadas ([G ...])."
L["REMOVED_COORDINATES_MESSAGE"] = "Se han eliminado las coordenadas %s."
L["RESET_GUIDE"] = "Restablecer guía"
L["RESET_POSITION"] = "Restablecer posición"
L["SAVE_GUIDE"] = "Guardar guía"
L["SAVE_MSG"] = "¿Guardar guía como \"%s\"?"
L["SELECT_COLORS"] = "Seleccionar colores"
L["SHOW_ARROW"] = "Mostrar flecha"
L["SHOW_COMPLETED_STEPS"] = "Mostrar pasos completados"
L["SHOW_DISTANCE"] = "Mostrar distancia"
L["SHOW_LINE_NUMBERS"] = "Mostrar números de línea"
L["SHOW_MAINFRAME"] = "Mostrar ventana"
L["SHOW_MAP"] = "Mostrar en el mapa"
L["SHOW_MARKERS_ON"] = "Mostrar marcadores en"
L["SHOW_MINIMUM_QUEST_LEVELS"] = "Mostrar nivel mínimo para una misión"
L["SHOW_QUEST_IDS"] = "Mostrar ID de misiones"
L["SHOW_SUGGESTED_QUEST_LEVELS"] = "Mostrar nivel sugerido para una misión"
L["SHOW_TOOLTIPS"] = "Mostrar tooltips"
L["SHOW_UNAVAILABLE_STEPS"] = "Mostrar pasos omitidos"
L["SKIP_CUTSCENES"] = "Saltar escenas"
L["STEP_FOLLOWUP_QUEST"] = "Si omite %s, perderá la siguiente misión más adelante"
L["STEP_FOLLOWUP_QUEST_CONT"] = "Cuando hagas %s más tarde, esta misión se reactivará."
L["STEP_FOLLOWUP_QUESTS"] = "Si omites %s, te perderás las siguientes misiones más adelante"
L["STEP_FOLLOWUP_QUESTS_CONT"] = "Cuando hagas %s más tarde, estas misiones se reactivarán."
L["STEP_MANUAL"] = "Haga clic aquí cuando haya completado este paso"
L["STEP_SKIP"] = "Haga clic aquí para omitir este paso."
L["SUGGESTED_LEVEL"] = "Nivel sugerido"
L["TYPE"] = "tipo"
L["URL"] = "URL"
L["USE_INTERNAL_DATA_SOURCE"] = "Usar fuente de datos interna"
L["USE_QUESTIE_AS_DATA_SOURCE"] = "Usar 'Questie' como fuente de datos"
L["USE_QUESTIE_AS_DATA_SOURCE_TOOLTIP"] = "Cuando se instala el complemento 'Questie', se puede utilizar como fuente de datos para las coordenadas de misiones. Puede contener información diferente a la base de datos de búsqueda interna, p. Ej. para el spawn de los mobs de las misiones.."
L["WORD_LIST_ACCEPT"] = "aceptar ; obtener ; recoger ; recoger ; tomar"
L["WORD_LIST_COMPLETE"] = "hacer ; completo ; matar ; botín ; terminar"
L["WORD_LIST_COMPLETE_LAST"] = "( completar )( );( terminar )( )"
L["WORD_LIST_COMPLETE_LAST_TWO"] = "( completar )ambos( );( terminar )ambos( )"
L["WORD_LIST_FLY"] = "( volar hacia )%a+( );( )(volar )"
L["WORD_LIST_GET_FLIGHT_POINT"] = "( obtener punto de vuelo en )%a+( );( activar punto de vuelo en )%a+( );( obtener punto de vuelo )%a+( );( activar punto de vuelo )%a+( );( obtener )%a+( punto de vuelo );( activar )%a+( punto de vuelo );( )(punto de vuelo ); ( obtener ruta de vuelo en )%a+( );( activar ruta de vuelo en )%a+( );( obtener ruta de vuelo )%a+( );( activar ruta de vuelo )%a+( );( obtener )%a+( ruta de vuelo );( activar )%a+( ruta de vuelo );( )(ruta de vuelo ); ( obtener rv en )%a+( );( activar rv en )%a+( );( obtener rv )%a+( );( activar rv )%a+( );( obtener el )(rv );( obtener )%a+( rv );( activar )%a+( rv )"
L["WORD_LIST_GOTO"] = "( a )(%d+%.?%d*) ?, ?(%d+%.?%d*)( );( )@ ?(%d+%.?%d*) ?, ?(%d+%.?%d*)( );( a )(%d+) ?%. ?(%d+)( );( )@ ?(%d+) ?%. ?(%d+)( );( hacia )(%d+%.?%d*) ?, ?(%d+%.?%d*)( );( hacia )(%d+) ?%. ?(%d+)( )"
L["WORD_LIST_HEARTH"] = "( hogar en )%a+( );( )(hogar );( usar .- )(hs );( usar )(hs);( usar .- )(piedra de hogar );( usar )(piedra de hogar)"
L["WORD_LIST_NEXT_PART"] = "siguiente ?parte"
L["WORD_LIST_OPTIONAL_COMPLETE_WITH_NEXT"] = "( farmear hacia)( );( farmear al norte)( );( farmear al sur)( );( farmear al este)( );( farmear al oeste)( );( farmear al noroeste)( );( farmear al noreste)( );( farmear al suroeste)( );( farmear al sureste)( );( ir hacia)( );( ir a travez)( );( ir hacia)( );( farmear arriba hacia)( );( farmear abajo hacia)( )"
L["WORD_LIST_PART_1"] = "*primera ?parte ; *1ra ?parte"
L["WORD_LIST_PART_2"] = "*segunda ?parte ; *2da ?parte"
L["WORD_LIST_PART_3"] = "*tercera ?parte ; *3ra ?parte"
L["WORD_LIST_PART_4"] = "*cuarta ?parte"
L["WORD_LIST_PART_N"] = "*parte ?(%d+) ; *(%d+)th ?parte ; *p ?(%d+)"
L["WORD_LIST_QUEST"] = "misión"
L["WORD_LIST_QUESTS"] = "misiones"
L["WORD_LIST_REPAIR"] = "reparar"
L["WORD_LIST_SET_HEARTH"] = "( establecer hogar en )%a+( );( establecer hogar hacia )%a+( );( establecer piedra de hogar en )%a+( );( establecer piedra de hogar hacia )%a+( );( )(establecer hogar );( )(establecer piedra de hogar );( )(establecer ph);( establecer ph en )%a+( );( establece tu hogar en )%a+( );( establece tu hogar hacia )%a+( )"
L["WORD_LIST_SKIP"] = "saltar ; ignorar"
L["WORD_LIST_TRAIN"] = "entrenar ; habilidades"
L["WORD_LIST_TURN_IN"] = "Entregar ; Entregar .- en ; entregar"
L["WORD_LIST_TURN_IN_LAST"] = "( Entregar )( en )"
L["WORD_LIST_TURN_IN_LAST_TWO"] = "( Entregar )ambas( en )"
L["WORD_LIST_VENDOR"] = "comprar ; comprar ; vendedor"
L["WORD_LIST_XP"] = "( nivel )%d+( );( farmear hasta )%d+( );( req. )%d+( )"
L["XP_LEVEL"] = "Solo nivel"
L["XP_LEVEL-"] = "Puntos restantes"
L["XP_LEVEL%"] = "Porcentaje"
L["XP_LEVEL%_TOOLTIP"] = "El jugador debe haber alcanzado el nivel especificado y debe haber obtenido el porcentaje especificado de puntos hacia el siguiente nivel"
L["XP_LEVEL-_TOOLTIP"] = "El jugador debe tener como máximo la cantidad especificada de puntos restantes hasta alcanzar el nivel especificado"
L["XP_LEVEL+"] = "Puntos obtenidos"
L["XP_LEVEL+_TOOLTIP"] = "El jugador debe haber alcanzado el nivel especificado y debe haber obtenido la cantidad especificada de puntos"
L["XP_TEXT"] = "Texto"
L["XP_TEXT_TOOLTIP"] = "Texto a mostrar. Si se omite, este elemento se mostrará como \"%s\"."
L["YARDS"] = "yardas"
L["ZONE"] = "Zona"

elseif locale == "koKR" then

L.TITLE = addonName
L["ADD_QUEST_COORDINATES"] = "퀘스트 좌표 추가"
L["ADD_QUEST_COORDINATES_MESSAGE"] = [=[퀘스트 데이터베이스에 정보가 있을 경우 모든 퀘스트 단계에 퀘스트 좌표를 추가합니다.
이미 존재하는 퀘스트 좌표는 교체됩니다.]=]
L["ADDED_QUEST_COORDINATES_MESSAGE"] = "%s 퀘스트 좌표가 추가되었습니다."
L["Alliance"] = "얼라이언스"
L["ARROW"] = "화살표"
L["ARROW_ALPHA"] = "화살표 알파"
L["ARROW_STYLE"] = "화살표 스타일"
L["AUTO_COMPLETE_QUESTS"] = "퀘스트를 자동으로 수락/완료합니다."
L["AVAILABLE_GUIDES"] = "사용 가능한 가이드"
L["CATEGORY"] = "범주"
L["CURRENT_GUIDE"] = "현재 가이드"
L["CUSTOM_GUIDES"] = "임의 설정 가이드"
L["DEBUGGING"] = "디버깅 모드 활성화"
L["DELETE_GUIDE"] = "가이드 삭제"

end
return L
end

addon.defaultL = getLocalizedStrings("enUS")
addon.L = setmetatable(getLocalizedStrings(GetLocale()), {__index = addon.defaultL})

function addon.testLocalization()
	if not addon.debugging then return end
	for i, locale in ipairs({"deDE", "enGB", "enUS", "esES", "esMX", "frFR", "itIT", "koKR", "ptBR", "ruRU", "zhCN", "zhTW"}) do
		local L = getLocalizedStrings(locale)
		if next(L) ~= nil then
			for key, value in pairs(addon.defaultL) do
				if key:sub(1, 9) ~= "WORD_LIST" and L[key] == nil then
					print("LIME: " .. locale .. " L." .. key .. " is missing")
				end
			end
		else
			--print("LIME: " .. locale .. " is missing")
		end		
	end	
end
