/*
 * Copyright 2008-2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.hasor.dataway.dal.providers.db;
import net.hasor.db.JdbcUtils;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.utils.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * 数据库存储层访问 DAO 层公共方法。
 * @author 赵永春 (zyc@hasor.net)
 * @version : 2020-09-11
 */
public abstract class AbstractDal {
    /** 不参与更新的列 */
    protected static final Set<String>  wontUpdateColumn = new HashSet<String>() {{
        add("api_id");
        add("api_path");
        add("api_create_time");
        //
        add("pub_id");
        add("pub_api_id");
        add("pub_path");
        add("pub_type");
        add("pub_comment");
        add("pub_script");
        add("pub_script_ori");
        add("pub_schema");
        add("pub_sample");
        add("pub_option");
        add("pub_release_time");
    }};
    protected final        JdbcTemplate jdbcTemplate;
    private final          String       dbType;

    public AbstractDal(JdbcTemplate jdbcTemplate, String dbType) {
        this.jdbcTemplate = jdbcTemplate;
        this.dbType = dbType;
    }

    public abstract String getTableName();

    protected String fixString(String key, String val) {
        if ("COMMENT".equalsIgnoreCase(key)) {
            if (JdbcUtils.ORACLE.equalsIgnoreCase(this.dbType) && StringUtils.isBlank(val)) {
                // Oracle 下 NULL 和 '' 是一个意思 - see：https://www.cnblogs.com/memory4young/p/use-null-empty-space-in-oracle.html
                return "there is no comment";
            }
        }
        //
        return val;
    }
}