CREATE TABLE "INTERFACE_RELEASE" (
  "PUB_ID"         VARCHAR2(64)   NOT NULL,
  "PUB_API_ID"     VARCHAR2(64)   NOT NULL,
  "PUB_METHOD"     VARCHAR2(12)   NOT NULL,
  "PUB_PATH"       VARCHAR2(512)  NOT NULL,
  "PUB_STATUS"     VARCHAR2(4)    NOT NULL,
  "PUB_COMMENT"    VARCHAR2(255)  NOT NULL,
  "PUB_TYPE"       VARCHAR2(24)   NOT NULL,
  "PUB_SCRIPT"     CLOB           NOT NULL,
  "PUB_SCRIPT_ORI" CLOB           NOT NULL,
  "PUB_SCHEMA"     CLOB           NOT NULL,
  "PUB_SAMPLE"     CLOB           NOT NULL,
  "PUB_OPTION"     CLOB           NOT NULL,
  "PUB_RELEASE_TIME" VARCHAR2(32) NOT NULL,
  CONSTRAINT "PK_INTERFACE_RELEASE" NOT CLUSTER PRIMARY KEY("PUB_ID")
) STORAGE(ON "MAIN", CLUSTERBTR);

COMMENT ON TABLE "INTERFACE_RELEASE" IS 'Dataway API 发布记录';
COMMENT ON COLUMN "INTERFACE_RELEASE"."PUB_API_ID" IS '所属API ID';
COMMENT ON COLUMN "INTERFACE_RELEASE"."PUB_COMMENT" IS '注释';
COMMENT ON COLUMN "INTERFACE_RELEASE"."PUB_ID" IS 'Publish ID';
COMMENT ON COLUMN "INTERFACE_RELEASE"."PUB_METHOD" IS 'HttpMethod：GET、PUT、POST';
COMMENT ON COLUMN "INTERFACE_RELEASE"."PUB_OPTION" IS '扩展配置信息';
COMMENT ON COLUMN "INTERFACE_RELEASE"."PUB_PATH" IS '拦截路径';
COMMENT ON COLUMN "INTERFACE_RELEASE"."PUB_RELEASE_TIME" IS '发布时间（下线不更新）';
COMMENT ON COLUMN "INTERFACE_RELEASE"."PUB_SAMPLE" IS '请求/响应/请求头样本数据';
COMMENT ON COLUMN "INTERFACE_RELEASE"."PUB_SCHEMA" IS '接口的请求/响应数据结构';
COMMENT ON COLUMN "INTERFACE_RELEASE"."PUB_SCRIPT" IS '查询脚本：xxxxxxx';
COMMENT ON COLUMN "INTERFACE_RELEASE"."PUB_SCRIPT_ORI" IS '原始查询脚本，仅当类型为SQL时不同';
COMMENT ON COLUMN "INTERFACE_RELEASE"."PUB_STATUS" IS '状态：-1-删除, 0-草稿，1-发布，2-有变更，3-禁用';
COMMENT ON COLUMN "INTERFACE_RELEASE"."PUB_TYPE" IS '脚本类型：SQL、DataQL';

CREATE  INDEX "IDX_INTERFACE_RELEASE_API" ON "INTERFACE_RELEASE"("PUB_API_ID" ASC) STORAGE(ON "MAIN", CLUSTERBTR);
CREATE  INDEX "IDX_INTERFACE_RELEASE_PATH" ON "INTERFACE_RELEASE"("PUB_PATH" ASC) STORAGE(ON "MAIN", CLUSTERBTR);