/*
 * Copyright 2008-2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.hasor.test.spring.mod1;
import net.hasor.core.ApiBinder;
import net.hasor.core.Module;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

/**
 *
 * @version : 2016年2月15日
 * @author 赵永春 (zyc@hasor.net)
 */
@Component
public class TestDimModuleC implements Module {
    @Autowired
    private ApplicationContext applicationContext;

    public TestDimModuleC() {
    }

    public ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void loadModule(ApiBinder apiBinder) {
        apiBinder.bindType(TestDimModuleC.class).toInstance(this);
    }
}
