# Reporting Issues

**Before** submitting an issue, read [Reporting Issues](https://github.com/mcedit/mcedit/wiki/Reporting-Issues) and be sure to include all of the required info in your description:

* **Steps to Reproduce** - Step by step, tell us exactly which buttons to click on, text to enter, and keys to press that lead you to discover the problem.
* **MCEdit Version Number** - Found in the title bar of the main window.
* **Minecraft Version Number** - You should already know how to find this. Also include a list of the mods you are using.
* **Operating System Version** - At the very least, say whether you are on Windows, Mac, or Linux. To get a more exact version (e.g. "Windows Vista SP1 64-bit", "Mac OS X 10.6.4"):
 + Windows: click Start, then right-click Computer and choose "Properties". 
 + Mac OS X: Choose "About This Mac" from the Apple menu.  
 + Linux: See your distro's documentation to find out how to get the version number.
 + An animal is not a version number.<br><br>

* **Error log** - If MCEdit tells you it had an error, there will be vital information inside the console window and/or error log file. On Windows, this is the file `mcedit.log` inside the `MCEdit-<version>-<platform>` folder. Use [pastebin](http://pastebin.com/) or [gist](https://gist.github.com/) for logs longer than a dozen lines. On Mac OS X, error info can be copied from the Console utility. (`mcedit.log` is also present on OS X, though it's buried deep inside the application bundle.) On Linux, the error log will be shown on the terminal you started MCEdit from.


The issue tracker is the preferred channel for [bug reports](#bugs),
[features requests](#features) and [submitting pull
requests](#pull-requests), but please respect the following restrictions:

* Please **do not** use the issue tracker for personal support requests (use the thread on the Minecraft forums or the official MCEdit forums (not yet available)). Asking for help is a personal support request.

<a name="bugs"></a>
## Bug reports

A bug is a _demonstrable problem_ when using MCEdit itself, or when loading a MCEdit-modified world into a vanilla Minecraft game. Modified versions of Minecraft are not officially supported.
Good bug reports are extremely helpful - thank you!

Guidelines for bug reports:

1. **Use the GitHub issue search** &mdash; check if the issue has already been
   reported. The search box is right next to the "New Issue" button.

2. **Check if the issue has been fixed** &mdash; try to reproduce it using the
   latest development builds from http://www.mcedit.net/


A good bug report shouldn't leave others needing to chase you up for more
information. Please try to be as detailed as possible in your report. What steps will reproduce the issue? What OS and Minecraft versions
experience the problem? What would you expect to be the outcome? If you use mods, have you tried a vanilla Minecraft install to confirm the problem is not mod-related? All these
details will help people to fix any potential bugs.

Example:

> Short and descriptive example bug report title
>
> Minecraft version(s):
> MCEdit version(s):
> Operating system(s):
> Mods installed:
>
> A summary of the issue. If suitable, include the steps required to reproduce the bug.
>
> 1. This is the first step
> 2. This is the second step
> 3. Further steps, etc.
>
> Any other information you want to share that is relevant to the issue being
> reported. This might include the lines of code that you have identified as
> causing the bug, and potential solutions (and your opinions on their
> merits).


<a name="features"></a>
## Feature requests

Feature requests are welcome. But take a moment to find out whether your idea
fits with the scope and aims of the project. It's up to *you* to make a strong
case to convince the project's developers of the merits of this feature. Please
provide as much detail and context as possible.

## Contributing



