--------------------
--Nova World Buffs--
--------------------
--Classic WoW world buff timers and pre warnings.
--Novaspark-Arugal OCE (classic).
--https://www.curseforge.com/members/venomisto/projects
--汉化内容参考了网易有爱插件(http://wowui.w.163.com/163ui/)
NWB.options = {
	name = "|TInterface\\AddOns\\NovaWorldBuffs\\Media\\logo32:24:24:0:5|t NovaWorldBuffs v" .. GetAddOnMetadata("NovaWorldBuffs", "Version"),
	handler = NWB,
	type = 'group',
	args = {
		desc = {
			type = "description",
			name = "|CffDEDE42世界buff插件设置 (聊天框输入 /wb config打开设置).\n"
					.. "输入 /wb 显示自己的buff计时器.\n"
					.. "输入 /wb <频道名> 发送buff计时到指定频道.\n"
					.. "下拉设置更多选项",
			fontSize = "medium",
			order = 1,
		},
		showBuffs = {
			type = "execute",
			name = "点此显示账号角色的世界BUFF计时",
			desc = "显示你当前所有角色的世界buff计时，点击此按钮或输入/buffs 打开界面 "
					.. "on the [WorldBuffs] prefix in chat.",
			func = "openBuffListFrame",
			order = 2,
			width = 1.7,
		},
		colorHeader = {
			type = "header",
			name = "通用设置",
			order = 3,
		},
		showWorldMapMarkers = {
			type = "toggle",
			name = "主城地图计时器",
			desc = "在奥格和暴风城地图上显示计时器",
			order = 4,
			get = "getShowWorldMapMarkers",
			set = "setShowWorldMapMarkers",
		},
		disableAllGuildMsgs = {
			type = "toggle",
			name = "关闭公会信息",
			desc = "关闭buff计时的所有公会提示信息。注意: 你可以在下面的公会设置中一一关闭选项 "
					.. "并保持某些功能开启，例如!wb命令",
			order = 5,
			get = "getDisableAllGuildMsgs",
			set = "setDisableAllGuildMsgs",
		},
		receiveGuildDataOnly  = {
			type = "toggle",
			name = "仅限公会信息",
			desc = "勾选这个会让你无法从公会外的玩家中获取buff信息. 如果你认为有人故意提供 "
					.. "错误的计时数据，才开启此选项，但这会降低buff计时器的准确性 "
					.. "因为可获得数据的用户量减少了. 这会极大影响风歌花计时器"
					.. "因为它们CD很短",
			order = 6,
			get = "getReceiveGuildDataOnly",
			set = "setReceiveGuildDataOnly",
		},
		chatColor = {
			type = "color",
			name = "聊天频道信息颜色",
			desc = "选择计时器信息在聊天频道中的颜色",
			order = 7,
			get = "getChatColor",
			set = "setChatColor",
			hasAlpha = false,
		},
		middleColor = {
			type = "color",
			name = "屏幕信息颜色",
			desc = "选择屏幕中央的提示信息的颜色",
			order = 8,
			get = "getMiddleColor",
			set = "setMiddleColor",
			hasAlpha = false,
		},
		resetColors = {
			type = "execute",
			name = "重置颜色",
			desc = "将颜色重置为默认",
			func = "resetColors",
			order = 9,
		},
		showTimeStamp = {
			type = "toggle",
			name = "显示时间戳",
			desc = "在计时器信息中显示一个时间戳 (1:23pm) ",
			order = 10,
			get = "getShowTimeStamp",
			set = "setShowTimeStamp",
		},
		timeStampFormat = {
			type = "select",
			name = "时间戳格式",
			desc = "设置时间戳格式, 12小时制 (1:23pm) 或 24小时制 (13:23).",
			values = {
				[12] = "12 hour",
				[24] = "24 hour",
			},
			sorting = {
				[1] = 12,
				[2] = 24,
			},
			order = 11,
			get = "getTimeStampFormat",
			set = "setTimeStampFormat",
		},
		timeStampZone = {
			type = "select",
			name = "本地时间 / 服务器时间",
			desc = "时间戳使用本地时间还是服务器时间？",
			values = {
				["local"] = "本地时间",
				["server"] = "服务器时间",
			},
			sorting = {
				[1] = "local",
				[2] = "server",
			},
			order = 12,
			get = "getTimeStampZone",
			set = "setTimeStampZone",
		},
		guildCommand = {
			type = "toggle",
			name = "公会命令",
			desc = "针对公会聊天频道中的 !wb 和 !dmf 命令回复计时器信息? 你应该启用此功能来帮助你的公会, " 
					.. "如果您确实要禁用所有公会消息并且仅保留此命令，则取消选中其他所有内容位于"
					.. "公会部分，不要在顶部勾选“关闭所有公会信息”.",
			order = 14,
			get = "getGuildCommand",
			set = "setGuildCommand",
		},
		colorizePrefixLinks = {
			type = "toggle",
			name = "彩色前缀链接",
			desc = "设定聊天频道 [WorldBuffs] 前缀链接的颜色 ? 这个前缀会出现在聊天频道中，可点击" 
					.. "显示你当前角色的世界BUFF计时.",
			order = 15,
			get = "getColorizePrefixLinks",
			set = "setColorizePrefixLinks",
		},
		showAllAlts = {
			type = "toggle",
			name = "显示所有小号",
			desc = "在 /buffs 窗口中显示你的小号，即使他们没有激活任何buff",
			order = 16,
			get = "getShowAllAlts",
			set = "setShowAllAlts",
		},
		flashMinimized = {
			type = "toggle",
			name = "最小化闪烁",
			desc = "当你最小化客户端，且有buff倒计时提示时，以及当龙头挂上时的几秒中内  "
					.. "闪烁游戏客户端的任务栏图标",
			order = 17,
			get = "getFlashMinimized",
			set = "setFlashMinimized",
		},
		minimapButton = {
			type = "toggle",
			name = "显示小地图按钮",
			desc = "在小地图上显示 NWB 按钮?",
			order = 20,
			get = "getMinimapButton",
			set = "setMinimapButton",
		},
		logonHeader = {
			type = "header",
			name = "登录信息",
			order = 23,
		},
		logonPrint = {
			type = "toggle",
			name = "登录计时器",
			desc = "当你登录游戏时在聊天窗口中显示计时器, 可以取消这个设置.",
			order = 24,
			get = "getLogonPrint",
			set = "setLogonPrint",
		},
		logonRend = {
			type = "toggle",
			name = "雷德黑手",
			desc = "登录时在聊天窗口中显示雷德黑手计时器.",
			order = 25,
			get = "getLogonRend",
			set = "setLogonRend",
		},
		logonOny = {
			type = "toggle",
			name = "奥妮克希亚",
			desc = "登录时在聊天窗口中显示奥妮克希亚计时器",
			order = 26,
			get = "getLogonOny",
			set = "setLogonOny",
		},
		logonNef = {
			type = "toggle",
			name = "奈法利安",
			desc = "登录时在聊天窗口中显示奈法利亚计时器",
			order = 27,
			get = "getLogonNef",
			set = "setLogonNef",
		},
		logonDmfSpawn = {
			type = "toggle",
			name = "暗月马戏团刷新",
			desc = "显示暗月马戏团刷新时间, 只有马戏团6小时内刷新/消失时才会显示",
			order = 8,
			get = "getLogonDmfSpawn",
			set = "setLogonDmfSpawn",
		},
		logonDmfBuffCooldown = {
			type = "toggle",
			name = "暗月马戏团buff冷却",
			desc = "显示马戏团BUFF 4小时的冷却, 只有暗月马戏团存在且你有马戏团BUFF时才显示.",
			order = 29,
			get = "getLogonDmfBuffCooldown",
			set = "setLogonDmfBuffCooldown",
		},
		chatWarningHeader = {
			type = "header",
			name = "聊天窗口计时信息提示",
			order = 30,
		},
		chat30 = {
			type = "toggle",
			name = "30分钟",
			desc = "倒计时30分钟时在聊天窗口中发送一条信息",
			order = 31,
			get = "getChat30",
			set = "setChat30",
		},
		chat15 = {
			type = "toggle",
			name = "15分钟",
			desc = "倒计时15分钟时在聊天窗口中发送一条信息",
			order = 32,
			get = "getChat15",
			set = "setChat15",
		},
		chat10 = {
			type = "toggle",
			name = "10分钟",
			desc = "倒计时10分钟时在聊天窗口中发送一条信息",
			order = 33,
			get = "getChat10",
			set = "setChat10",
		},
		chat5 = {
			type = "toggle",
			name = "5 分钟",
			desc = "倒计时5分钟时在聊天窗口中发送一条信息",
			order = 34,
			get = "getChat5",
			set = "setChat5",
		},
		chat1 = {
			type = "toggle",
			name = "1 分钟",
			desc = "倒计时1分钟时在聊天窗口中发送一条信息",
			order = 35,
			get = "getChat1",
			set = "setChat1",
		},
		chatReset = {
			type = "toggle",
			name = "buff已重置",
			desc = "当buff已重置且可以获得新buff时在聊天窗口中发送一条信息",
			order = 36,
			get = "getChat0",
			set = "setChat0",
		},
		chatZan = {
			type = "toggle",
			name = "赞达拉buff提示",
			desc = "在赞达拉NPC开始大喊给予buff前30秒在聊天窗口中发送一条信息",
			order = 37,
			get = "getChatZan",
			set = "setChatZan",
		},
		middleWarningHeader = {
			type = "header",
			name = "屏幕中央计时信息提示",
			order = 40,
		},
		middle30 = {
			type = "toggle",
			name = "30 分钟",
			desc = "倒计时30分钟时在屏幕中央中发送一条信息",
			order = 41,
			get = "getMiddle30",
			set = "setMiddle30",
		},
		middle15 = {
			type = "toggle",
			name = "15 分钟",
			desc = "倒计时15分钟时在屏幕中央中发送一条信息",
			order = 42,
			get = "getMiddle15",
			set = "setMiddle15",
		},
		middle10 = {
			type = "toggle",
			name = "10 分钟",
			desc = "倒计时10分钟时在屏幕中央中发送一条信息",
			order = 43,
			get = "getMiddle10",
			set = "setMiddle10",
		},
		middle5 = {
			type = "toggle",
			name = "5 分钟",
			desc = "倒计时5分钟时在屏幕中央中发送一条信息",
			order = 44,
			get = "getMiddle5",
			set = "setMiddle5",
		},
		middle1 = {
			type = "toggle",
			name = "1 分钟",
			desc = "倒计时1分钟时在屏幕中央中发送一条信息",
			order = 45,
			get = "getMiddle1",
			set = "setMiddle1",
		},
		middleReset = {
			type = "toggle",
			name = "Buff已重置",
			desc = "当buff已重置且可以获得新buff时在屏幕中央发送一条信息",
			order = 46,
			get = "getMiddle0",
			set = "setMiddle0",
		},
		middleBuffWarning = {
			type = "toggle",
			name = "BUFF获取提示",
			desc = "当有人即将获得buff且NPC开始通告时 "
					.. "在屏幕中央发送一条信息",
			order = 47,
			get = "getMiddleBuffWarning",
			set = "setMiddleBuffWarning",
		},
		guildWarningHeader = {
			type = "header",
			name = "公会计时器信息提示",
			order = 50,
		},
		--[[guild30 = {
			type = "toggle",
			name = "30 Minutes",
			desc = "Send a message to guild chat when 30 minutes left.",
			order = 51,
			get = "getGuild30",
			set = "setGuild30",
		},
		guild15 = {
			type = "toggle",
			name = "15 Minutes",
			desc = "Send a message to guild chat when 15 minutes left.",
			order = 52,
			get = "getGuild15",
			set = "setGuild15",
		},]]
		guild10 = {
			type = "toggle",
			name = "10 分钟",
			desc = "倒计时10分钟时在公会频道发送一条信息",
			order = 53,
			get = "getGuild10",
			set = "setGuild10",
		},
		--[[guild5 = {
			type = "toggle",
			name = "5 Minutes",
			desc = "Send a message to guild chat when 5 minutes left.",
			order = 54,
			get = "getGuild5",
			set = "setGuild5",
		},]]
		guild1 = {
			type = "toggle",
			name = "1 分钟",
			desc = "倒计时1分钟时在公会频道发送一条信息",
			order = 55,
			get = "getGuild1",
			set = "setGuild1",
		},
		--[[guildReset = {
			type = "toggle",
			name = "Buff Has Reset",
			desc = "Send a message to guild chat when a buff has reset and a new one can be dropped.",
			order = 56,
			get = "getGuild0",
			set = "setGuild0",
		},]]
		guildNpcDialogue = {
			type = "toggle",
			name = "NPC念台词",
			desc = "在有人准备开BUFF且NPC开始念台词时在公会频道发送一条信息",
			order = 57,
			get = "getGuildNpcDialogue",
			set = "setGuildNpcDialogue",
		},
		guildBuffDropped = {
			type = "toggle",
			name = "可获得新buff",
			desc = "当拿到一个新buff时，在公会频道中发送一条信息，这个信息只会在NPC念完台词后发送, "
					.. " 这时候你已经拿到一个新BUFF (萨尔大喊6秒后, 奥妮克希亚龙头的NPC大喊14秒后） "
					.. " 奈法利安龙头的NPC大喊15秒后)",
			order = 58,
			get = "getGuildBuffDropped",
			set = "setGuildBuffDropped",
		},
		guildNpcKilled = {
			type = "toggle",
			name = "NPC已被击杀",
			desc = "奥格或暴风城的世界BUFF的NPC被击杀后在公会频道中发一条信息 (通过心灵控制重置).",
			order = 59,
			get = "getGuildNpcKilled",
			set = "setGuildNpcKilled",
		},
		guildZanDialogue = {
			type = "toggle",
			name = "赞达拉之魂BUFF提示",
			desc = "当赞达拉buff可以获得时在公会中发送一条信息 (如果你不想看到这个buffde信息 "
					.. "需要公会的所有人都关闭它).",
			order = 60,
			get = "getGuildZanDialogue",
			set = "setGuildZanDialogue",
		},
		songflowers = {
			type = "header",
			name = "风歌花",
			order = 70,
		},
		guildSongflower = {
			type = "toggle",
			name = "采集后告知公会",
			desc = "当一个风歌花被采集、开启重置时在公会频道发送一个信息",
			order = 71,
			get = "getGuildSongflower",
			set = "setGuildSongflower",
		},
		mySongflowerOnly = {
			type = "toggle",
			name = "只有当我采集时才告知",
			desc = "只有当我自己亲手采了风歌花，而不是我之前的其他人采集时，发送一条公会信息"
					.. "这个设置是以防其他人的错误的风歌花计时器.因为目前尚无办法 "
					.. "判断其他人的buff是否是新获得的。因此，如果某个人带着风歌花BUFF上线进入游戏时，正好在你旁边， "
					.. "会罕见地触发这个通知信息",
			order = 72,
			get = "getMySongflowerOnly",
			set = "setMySongflowerOnly",
		},
		syncFlowersAll = {
			type = "toggle",
			name = "向所有人同步风歌花",
			desc = "启用此选项会覆盖前面的[仅限公会信息]设置，这样你就可以在公会外共享风歌花BUFF的刷新计时"
					.. "但任只会在公会中共享其他世界BUFF数据",
			order = 73,
			get = "getSyncFlowersAll",
			set = "setSyncFlowersAll",
		},
		showNewFlower = {
			type = "toggle",
			name = "显示新的风歌花计时",
			desc = "有一个其他公会的玩家采集了风歌花时，在聊天窗口中发送提示信息"
					.. " (当风歌花被采集时，公会频道也会出现提示).",
			order = 74,
			get = "getShowNewFlower",
			set = "setShowNewFlower",
		},
		showSongflowerWorldmapMarkers = {
			type = "toggle",
			name = "世界地图风歌花",
			desc = "在世界地图上显示风歌花图标.",
			order = 75,
			get = "getShowSongflowerWorldmapMarkers",
			set = "setShowSongflowerWorldmapMarkers",
		},
		showSongflowerMinimapMarkers = {
			type = "toggle",
			name = "小地图风歌花",
			desc = "在小地图上显示风歌花.",
			order = 76,
			get = "getShowSongflowerMinimapMarkers",
			set = "setShowSongflowerMinimapMarkers",
		},
		showTuberWorldmapMarkers = {
			type = "toggle",
			name = "世界地图鞭根块茎",
			desc = "在世界地图上显示鞭根块茎.",
			order = 77,
			get = "getShowTuberWorldmapMarkers",
			set = "setShowTuberWorldmapMarkers",
		},
		showTuberMinimapMarkers = {
			type = "toggle",
			name = "小地图鞭根块茎",
			desc = "在小地图上显示鞭根块茎",
			order = 78,
			get = "getShowTuberMinimapMarkers",
			set = "setShowTuberMinimapMarkers",
		},
		showDragonWorldmapMarkers = {
			type = "toggle",
			name = "世界地图夜龙之息",
			desc = "在世界地图上显示夜龙之息.",
			order = 79,
			get = "getShowDragonWorldmapMarkers",
			set = "setShowDragonWorldmapMarkers",
		},
		showDragonMinimapMarkers = {
			type = "toggle",
			name = "小地图夜龙之息",
			desc = "在小底图上显示夜龙之息",
			order = 80
			,
			get = "getShowDragonMinimapMarkers",
			set = "setShowDragonMinimapMarkers",
		},
		showExpiredTimers = {
			type = "toggle",
			name = "显示过期时间计时器",
			desc = "在费伍德显示过期时间计时器？它们将以红色文字显示，计时器已计时多长时间，默认"
					.. "时间是5分钟 (玩家总是说风歌花刷新后只存在5分钟?).",
			order = 81,
			get = "getShowExpiredTimers",
			set = "setShowExpiredTimers",
		},
		expiredTimersDuration = {
			type = "range",
			name = "过期时间计时器周期",
			desc = "世界地图上的Felwood计时器在到期后应显示多长时间?",
			order = 82,
			get = "getExpiredTimersDuration",
			set = "setExpiredTimersDuration",
			min = 1,
			max = 60,
			softMin = 1,
			softMax = 60,
			step = 1,
		},
		dmf = {
			type = "header",
			name = "暗月马戏团",
			order = 90,
		},
		dmfDesc = {
			type = "description",
			name = "|CffDEDE42你的暗月马戏团伤害BUFF冷却计时也会显示在暗月马戏团地图上"
					.. " 如果你有这个BUFF的CD且暗月马戏团还未消失",
			fontSize = "medium",
			order = 91,
		},
		showDmfWb = {
			type = "toggle",
			name = "/wb 打开马戏团BUFF计时器",
			desc = "用/wb 命令打开暗月马戏团BUFF计时器",
			order = 92,
			get = "getShowDmfWb",
			set = "setShowDmfWb",
		},
		showDmfWb = {
			type = "toggle",
			name = "/wb 马戏团刷新计时器",
			desc = "用/wb 命令显示暗月马戏团刷新时间的计时器",
			order = 92,
			get = "getShowDmfWb",
			set = "setShowDmfWb",
		},
		showDmfBuffWb = {
			type = "toggle",
			name = "/wb 打开马戏团BUFF CD计时",
			desc = "用 /wb 命令打开暗月马戏团BUFF的CD计时器，当你有一个激活的冷却计时"
					.. " 且暗月马戏团未消失时才有",
			order = 93,
			get = "getShowDmfBuffWb",
			set = "setShowDmfBuffWb",
		},
		--[[showDmfWhenClose = {
			type = "toggle",
			name = "Show Close To Spawn",
			desc = "Show DMF spawn timer at logon and together with /wb command when it's within 12 hours of spawn or despawn.",
			order = 93,
			get = "getShowDmfWhenClose",
			set = "setShowDmfWhenClose",
		},]]
		--[[showDmfLogon = {
			type = "toggle",
			name = "Show Always Logon",
			desc = "Show DMF spawn timer at logon always, even if it's not close to spawn.",
			order = 94,
			get = "getShowDmfLogon",
			set = "setShowDmfLogon",
		},]]
		showDmfMap = {
			type = "toggle",
			name = "Show Map Marker",
			name = "显示地图标记",
			desc = "在莫高雷和艾尔文森林地图上显示暗月马戏团和BUFF的刷新时间"
					.. "输入 /dmf map 可以直接打开标记的这两个地图",
			order = 95,
			get = "getShowDmfMap",
			set = "setShowDmfMap",
		},
		guildChatFilter = {
			type = "header",
			name = "公会聊天过滤",
			order = 100,
		},
		guildChatFilterDesc = {
			type = "description",
			name = "|CffDEDE42这将屏蔽由此插件发送的任何信息，选中后你将无法看到它们.这会阻止 "
					.. "你在公会聊天中看到你自己插件发送的消息以及来自其他插件用户的消息.",
			fontSize = "medium",
			order = 101,
		},
		filterYells = {
			type = "toggle",
			name = "过滤公会BUFF提示",
			desc = "屏蔽世界buff将在几秒后释放的信息(奥妮克希亚Buff将在 14 秒后释放).",
			order = 102,
			get = "getFilterYells",
			set = "setFilterYells",
		},
		filterDrops = {
			type = "toggle",
			name = "过滤公会BUFF释放",
			desc = "屏蔽世界buff已经释放的信息(屠龙者的咆哮（奥妮克希亚）Buff 已经释放).",
			order = 103,
			get = "getFilterDrops",
			set = "setFilterDrops",
		},
		filterTimers = {
			type = "toggle",
			name = "过滤公会计时器信息",
			desc = "屏蔽计时器信息(奥妮克希亚龙头倒计时1分钟).",
			order = 104,
			get = "getFilterTimers",
			set = "setFilterTimers",
		},
		filterCommand = {
			type = "toggle",
			name = "过滤 !wb 命令",
			desc = "屏蔽公会中其他玩家输入的!wb或!dmf 命令信息.",
			order = 105,
			get = "getFilterCommand",
			set = "setFilterCommand",
		},
		filterCommandResponse = {
			type = "toggle",
			name = "过滤 !wb 回复",
			desc = "当!wb或!!dmf 命令被使用时屏蔽这个计时器的回复信息.",
			order = 106,
			get = "getFilterCommandResponse",
			set = "setFilterCommandResponse",
		},
		filterSongflowers = {
			type = "toggle",
			name = "过滤风歌花",
			desc = "屏蔽当一个风歌花被采集时在公会频道的提示信息.",
			order = 107,
			get = "getFilterSongflowers",
			set = "setFilterSongflowers",
		},
		filterNpcKilled = {
			type = "toggle",
			name = "过滤NPC被杀",
			desc = "屏蔽当一个主城中释放Buff的NPC被击杀时在公会频道的提示信息.",
			order = 108,
			get = "getFilterNpcKilled",
			set = "setFilterNpcKilled",
		},
		sounds = {
			type = "header",
			name = "提示音",
			order = 110,
		},
		soundsDesc = {
			type = "description",
			name = "|CffDEDE42设置提示音至 \"无\" 关闭.",
			fontSize = "medium",
			order = 111,
		},
		disableAllSounds = {
			type = "toggle",
			name = "关闭所有提示音",
			desc = "关闭来自该插件的所有提示音.",
			order = 112,
			get = "getDisableAllSounds",
			set = "setDisableAllSounds",
		},
		extraSoundOptions = {
			type = "toggle",
			name = "额外的提示声选项",
			desc = "启用此功能可在下拉列表中显示来自你所有插件的提示声.",
			order = 113,
			get = "getExtraSoundOptions",
			set = "setExtraSoundOptions",
			--width = "double",
		},
		soundOnlyInCity = {
			type = "toggle",
			name = "仅在主城",
			desc = "仅当你位于可以获得世界buff的主城时才播放buff提示音(荆棘谷地区包含赞达拉buff).",
			order = 114,
			get = "getSoundOnlyInCity",
			set = "setSoundOnlyInCity",
		},
		soundsDisableInInstances = {
			type = "toggle",
			name = "在副本中禁用",
			desc = "当你在副本中时禁用提示音.",
			order = 115,
			get = "getSoundsDisableInInstances",
			set = "setSoundsDisableInInstances",
		},
		soundsFirstYell = {
			type = "select",
			name = "Buff即将释放",
			desc = "当龙头任务已交时播放提示声，你需要等待几秒钟，buff才会释放（NPC第一次喊话）.",
			values = function()
				return NWB:getSounds();
			end,
			order = 116,
			get = "getSoundsFirstYell",
			set = "setSoundsFirstYell",
		},
		soundsOneMinute = {
			type = "select",
			name = "1分钟警告",
			desc = "当计时器还剩一分钟时，播放提示声.",
			values = function()
				return NWB:getSounds();
			end,
			order = 117,
			get = "getSoundsOneMinute",
			set = "setSoundsOneMinute",
		},
		soundsRendDrop = {
			type = "select",
			name = "获得雷德黑手Buff",
			desc = "当雷德黑手buff释放且你获得buff时播放提示声.",
			values = function()
				return NWB:getSounds("rend");
			end,
			order = 120,
			get = "getSoundsRendDrop",
			set = "setSoundsRendDrop",
		},
		soundsOnyDrop = {
			type = "select",
			name = "获得奥妮克希亚Buff",
			desc = "当奥妮克希亚buff释放且你获得buff时播放提示声.",
			values = function()
				return NWB:getSounds("ony");
			end,
			order = 121,
			get = "getSoundsOnyDrop",
			set = "setSoundsOnyDrop",
		},
		soundsNefDrop = {
			type = "select",
			name = "获得奈法利安Buff",
			desc = "当奈法利安buff释放且你获得buff时播放提示声.",
			values = function()
				return NWB:getSounds("nef");
			end,
			order = 122,
			get = "getSoundsNefDrop",
			set = "setSoundsNefDrop",
		},
		soundsZanDrop = {
			type = "select",
			name = "获得赞达拉Buff",
			desc = "当赞达拉buff释放且你获得buff时播放提示声.",
			values = function()
				return NWB:getSounds("zan");
			end,
			order = 123,
			get = "getSoundsZanDrop",
			set = "setSoundsZanDrop",
		},
	},
};

function NWB:loadSpecificOptions()
	if (NWB.faction == "Alliance") then
		NWB.options.args["allianceEnableRend"] = {
			type = "toggle",
			name = "开启联盟雷德提示",
			desc = "联盟玩家开启此追踪，被心灵控制时获得雷德buff. 如果你开了这个选项， "
					.. "你所在联盟公会有这个插件的玩家都会收到提示，公会信息提示也可能出现问题(个人计时器信息不会).";
			order = 18,
			get = "getAllianceEnableRend",
			set = "setAllianceEnableRend",
		};
	end
	if (NWB.isLayered) then
		NWB.options.args["minimapLayerFrame"] = {
			type = "toggle",
			name = "在小地图上显示位面",
			desc = "位于主城时在小地图上显示你所在的位面";
			order = 18,
			get = "getMinimapLayerFrame",
			set = "setMinimapLayerFrame",
		};
		NWB.options.args["minimapLayerFrameReset"] = {
				type = "execute",
				name = "重置小地图位面信息",
				desc = "重置小地图位面信息的为主 (按住shift拖动小地图位面信息位置).",
				func = "resetMinimapLayerFrame",
				order = 19,
		};
	end
end

------------------------
--Load option defaults--
------------------------
NWB.optionDefaults = {
	global = {
		chatColorR = 255, chatColorG = 255, chatColorB = 0,
		middleColorR = 1, middleColorG = 0.96, middleColorB = 0.41,
		logonPrint = true,
		chatWarning = true,
		middleScreenWarning = true,
		chat30 = true,
		chat15 = false,
		chat10 = true,
		chat5 = false,
		chat1 = true,
		chat0 = true,
		chatZan = false,
		middle30 = true,
		middle15 = false,
		middle10 = true,
		middle5 = false,
		middle1 = true,
		middle0 = true,
		middleBuffWarning = true,
		guild30 = false,
		guild15 = false,
		guild10 = true,
		guild5 = false,
		guild1 = true,
		guild0 = false,
		rendRespawnTime = 10800,
		rendBuffTime = 3600,
		onyRespawnTime = 21600,
		onyBuffTime = 7200,
		nefRespawnTime = 28800,
		nefBuffTime = 7200,
		zanRespawnTime = 28800,
		zanBuffTime = 7200,
		syncVicinity = true,
		lastVersionMsg = 0,
		showTimeStamp = true,
		timeStampFormat = 12,
		timeStampZone = "local",
		guildNpcKilled = true,
		guildBuffDropped = true,
		guildNpcDialogue = true,
		guildZanDialogue = true,
		guildCommand = true,
		disableAllGuildMsgs = false,
		receiveGuildDataOnly = false,
		guildSongflower = true,
		mySongflowerOnly = false,
		syncFlowersAll = true,
		allianceEnableRend = false,
		showWorldMapMarkers = true,
		showSongflowerWorldmapMarkers = true,
		showSongflowerMinimapMarkers = true,
		showTuberWorldmapMarkers = true,
		showTuberMinimapMarkers = true,
		showDragonWorldmapMarkers = true,
		showDragonMinimapMarkers = true,
		showNewFlower = false,
		showDmfLogon = false,
		showDmfWb = false, --show dmf with /wb cmd
		showDmfWhenClose = true, --both logon and /wb
		showDmfMap = true,
		songflowerBuffTime = 3600,
		dmfBuffTime = 7200,
		dmfBuffCooldown = 18000,
		moxieBuffTime = 7200,
		ferocityBuffTime = 7200,
		savvyBuffTime = 7200,
		colorizePrefixLinks = false,
		flaskPowerBuffTime = 7200,
		flaskTitansBuffTime = 7200,
		flaskWisdomBuffTime = 7200,
		flaskResistanceBuffTime = 7200,
		resistFireBuffTime = 3600,
		printRend = true,
		printOny = true,
		printNef = true,
		printZan = true,
		iceBuffTime = 1800, --Debug.
		logonRend = true,
		logonOny = true,
		logonNef = true,
		logonDmfSpawn = true,
		logonDmfBuffCooldown = true,
		showDmfBuffWb = true,
		showAllAlts = false,
		flashMinimized = true,
		filterYells = false,
		filterDrops = false,
		filterTimers = false,
		filterCommand = false,
		filterCommandResponse = false,
		filterSongflowers = false,
		filterNpcKilled = false,
		minimapLayerFrame = true,
		blackfathomBuffTime = 3600,
		disableAllSounds = false,
		extraSoundOptions = false,
		soundOnlyInCity = false,
		soundsDisableInInstances = true,
		soundsFirstYell = "NWB - Electronic",
		soundsOneMinute = "None",
		soundsRendDrop = "NWB - Zelda",
		soundsOnyDrop = "NWB - Zelda",
		soundsNefDrop = "NWB - Zelda",
		soundsZanDrop = "NWB - Zelda",
		showExpiredTimers = true,
		expiredTimersDuration = 5,
		minimapIcon = {["minimapPos"] = 165, ["hide"] = false},
		minimapButton = true,
		resetLayers3 = true, --Reset layers one time (sometimes needed when upgrading from old version.
		resetSongflowers = true, --Reset songflowers one time.
		experimental = true, --Enable features being tested on occasion.
		resetLayerMaps = true;
	},
};

--Configuraton options are shared but buff data is realm and faction specific so I store timer data seperately.
--Config options = NWB.db.global (ace3)
--Timer data = NWB.data
function NWB:buildRealmFactionData()
	local defaults = {
		rendTimer = 0,
		rendYell = 0,
		rendYell2 = 0,
		onyTimer = 0,
		onyYell = 0,
		onyYell2 = 0,
		onyNpcDied = 0,
		nefTimer = 0,
		nefYell = 0,
		nefYell2 = 0,
		nefNpcDied = 0,
		--zanTimer = 0,
		zanYell = 0,
		zanYell2 = 0,
		flower1 = 0,
		flower2 = 0,
		flower3 = 0,
		flower4 = 0,
		flower5 = 0,
		flower6 = 0,
		flower7 = 0,
		flower8 = 0,
		flower9 = 0,
		flower10 = 0,
		tuber1 = 0,
		tuber2 = 0,
		tuber3 = 0,
		tuber4 = 0,
		tuber5 = 0,
		tuber6 = 0,
		dragon1 = 0,
		dragon2 = 0,
		dragon3 = 0,
		dragon4 = 0,
	};
	--Create realm and faction tables if they don't exist.
	if (not self.db.global[NWB.realm]) then
			self.db.global[NWB.realm] = {};
	end
	if (not self.db.global[NWB.realm][NWB.faction]) then
			self.db.global[NWB.realm][NWB.faction] = {};
	end
	if (not self.db.global[NWB.realm][NWB.faction].myChars) then
			self.db.global[NWB.realm][NWB.faction].myChars = {};
	end
	if (not self.db.global[NWB.realm][NWB.faction].myChars[UnitName("player")]) then
			self.db.global[NWB.realm][NWB.faction].myChars[UnitName("player")] = {};
	end
	if (not self.db.global[NWB.realm][NWB.faction].myChars[UnitName("player")].buffs) then
			self.db.global[NWB.realm][NWB.faction].myChars[UnitName("player")].buffs = {};
	end
	if (not self.db.global[NWB.realm][NWB.faction].myChars[UnitName("player")].rendCount) then
			self.db.global[NWB.realm][NWB.faction].myChars[UnitName("player")].rendCount = 0;
	end
	if (not self.db.global[NWB.realm][NWB.faction].myChars[UnitName("player")].onyCount) then
			self.db.global[NWB.realm][NWB.faction].myChars[UnitName("player")].onyCount = 0;
	end
	if (not self.db.global[NWB.realm][NWB.faction].myChars[UnitName("player")].nefCount) then
			self.db.global[NWB.realm][NWB.faction].myChars[UnitName("player")].nefCount = 0;
	end
	if (not self.db.global[NWB.realm][NWB.faction].myChars[UnitName("player")].zanCount) then
			self.db.global[NWB.realm][NWB.faction].myChars[UnitName("player")].zanCount = 0;
	end
	if (not self.db.global[NWB.realm][NWB.faction].layers) then
			self.db.global[NWB.realm][NWB.faction].layers = {};
	end
	local localizedClass, englishClass = UnitClass("player");
	self.db.global[NWB.realm][NWB.faction].myChars[UnitName("player")].localizedClass = localizedClass;
	self.db.global[NWB.realm][NWB.faction].myChars[UnitName("player")].englishClass = englishClass;
	self.db.global[NWB.realm][NWB.faction].myChars[UnitName("player")].level = UnitLevel("player");
	self.db.global[NWB.realm][NWB.faction].myChars[UnitName("player")].race = UnitRace("player");
	for k, v in pairs(defaults) do
		if (not self.db.global[NWB.realm][NWB.faction][k]) then
			--Add default values if no value is already set.
			self.db.global[NWB.realm][NWB.faction][k] = v;
		end
	end
	--Timer data is stored within the ace3 global table but I create a shortcut here "NWB.data".
	self.data = self.db.global[NWB.realm][NWB.faction];
end

--Print timers to chat window at logon time.
function NWB:setLogonPrint(info, value)
	self.db.global.logonPrint = value;
end

function NWB:getLogonPrint(info)
	return self.db.global.logonPrint;
end

--Show a time stamp after the timers.
function NWB:setShowTimeStamp(info, value)
	self.db.global.showTimeStamp = value;
end

function NWB:getShowTimeStamp(info)
	return self.db.global.showTimeStamp;
end

--Which timestamp format to use 12h/24h.
function NWB:setTimeStampFormat(info, value)
	self.db.global.timeStampFormat = value;
end

function NWB:getTimeStampFormat(info)
	return self.db.global.timeStampFormat;
end

--Which timezone format to use local/server.
function NWB:setTimeStampZone(info, value)
	self.db.global.timeStampZone = value;
end

function NWB:getTimeStampZone(info)
	return self.db.global.timeStampZone;
end

--Show world map markers.
function NWB:setShowWorldMapMarkers(info, value)
	self.db.global.showWorldMapMarkers = value;
	NWB:refreshWorldbuffMarkers();
end

function NWB:getShowWorldMapMarkers(info)
	return self.db.global.showWorldMapMarkers;
end

--Enable rend timers for alliance.
function NWB:setAllianceEnableRend(info, value)
	self.db.global.allianceEnableRend = value;
	NWB:refreshWorldbuffMarkers();
end

function NWB:getAllianceEnableRend(info)
	return self.db.global.allianceEnableRend;
end

--Disable all guild msgs.
function NWB:setDisableAllGuildMsgs(info, value)
	self.db.global.disableAllGuildMsgs = value;
	NWB:sendData("GUILD");
end

function NWB:getDisableAllGuildMsgs(info)
	return self.db.global.disableAllGuildMsgs;
end

--Ignore data from outside the guild.
function NWB:setReceiveGuildDataOnly(info, value)
	self.db.global.receiveGuildDataOnly = value;
end

function NWB:getReceiveGuildDataOnly(info)
	return self.db.global.receiveGuildDataOnly;
end

--Chat color.
function NWB:setChatColor(info, r, g, b, a)
	self.db.global.chatColorR, self.db.global.chatColorG, self.db.global.chatColorB = r, g, b;
	NWB.chatColor = "|cff" .. NWB:RGBToHex(self.db.global.chatColorR, self.db.global.chatColorG, self.db.global.chatColorB);
end

function NWB:getChatColor(info)
	return self.db.global.chatColorR, self.db.global.chatColorG, self.db.global.chatColorB;
end

--Middle of screen color.
function NWB:setMiddleColor(info, r, g, b, a)
	self.db.global.middleColorR, self.db.global.middleColorG, self.db.global.middleColorB = r, g, b;
end

function NWB:getMiddleColor(info)
	return self.db.global.middleColorR, self.db.global.middleColorG, self.db.global.middleColorB;
end

--Reset colors.
function NWB:resetColors(info, r, g, b, a)
	self.db.global.chatColorR = self.optionDefaults.global.chatColorR;
	self.db.global.chatColorG = self.optionDefaults.global.chatColorG;
	self.db.global.chatColorB = self.optionDefaults.global.chatColorB;
	self.db.global.middleColorR = self.optionDefaults.global.middleColorR;
	self.db.global.middleColorG = self.optionDefaults.global.middleColorG;
	self.db.global.middleColorB = self.optionDefaults.global.middleColorB;
	NWB.chatColor = "|cff" .. NWB:RGBToHex(self.db.global.chatColorR, self.db.global.chatColorG, self.db.global.chatColorB);
end

--Reset colors.
function NWB:resetMinimapLayerFrame(info)
	MinimapLayerFrame:ClearAllPoints();
	MinimapLayerFrame:SetPoint("BOTTOM", Minimap, 2, 4);
end
--Colorize chat prefix in all chat channels.
function NWB:setColorizePrefixLinks(info, value)
	self.db.global.colorizePrefixLinks = value;
end

function NWB:getColorizePrefixLinks(info)
	return self.db.global.colorizePrefixLinks;
end

--Show all alts in the buffs window.
function NWB:setShowAllAlts(info, value)
	self.db.global.showAllAlts = value;
end

function NWB:getShowAllAlts(info)
	return self.db.global.showAllAlts;
end

--Flash minimized.
function NWB:setFlashMinimized(info, value)
	self.db.global.flashMinimized = value;
end

function NWB:getFlashMinimized(info)
	return self.db.global.flashMinimized;
end

--Minimap button
function NWB:setMinimapButton(info, value)
	self.db.global.minimapButton = value;
	if (value) then
		NWB.LDBIcon:Show("NovaWorldBuffs");
		self.db.global.minimapIcon.hide = false;
	else
		NWB.LDBIcon:Hide("NovaWorldBuffs");
		self.db.global.minimapIcon.hide = true;
	end
end

function NWB:getMinimapButton(info)
	return self.db.global.minimapButton;
end

--Chat 30 minute warning.
function NWB:setChat30(info, value)
	self.db.global.chat30 = value;
end

function NWB:getChat30(info)
	return self.db.global.chat30;
end

--Chat 15 minute warning.
function NWB:setChat15(info, value)
	self.db.global.chat15 = value;
end

function NWB:getChat15(info)
	return self.db.global.chat15;
end

--Chat 10 minute warning.
function NWB:setChat10(info, value)
	self.db.global.chat10 = value;
end

function NWB:getChat10(info)
	return self.db.global.chat10;
end

--Chat 5 minute warning.
function NWB:setChat5(info, value)
	self.db.global.chat5 = value;
end

function NWB:getChat5(info)
	return self.db.global.chat5;
end

--Chat 1 minute warning.
function NWB:setChat1(info, value)
	self.db.global.chat1 = value;
end

function NWB:getChat1(info)
	return self.db.global.chat1;
end

--Chat timer finished warning.
function NWB:setChat0(info, value)
	self.db.global.chat0 = value;
end

function NWB:getChat0(info)
	return self.db.global.chat0;
end

--Chat zan warning.
function NWB:setChatZan(info, value)
	self.db.global.chatZan = value;
end

function NWB:getChatZan(info)
	return self.db.global.chatZan;
end

--Middle of the screen 30 minute warning.
function NWB:setMiddle30(info, value)
	self.db.global.middle30 = value;
end

function NWB:getMiddle30(info)
	return self.db.global.middle30;
end

--Middle of the screen 15 minute warning.
function NWB:setMiddle15(info, value)
	self.db.global.middle15 = value;
end

function NWB:getMiddle15(info)
	return self.db.global.middle15;
end

--Middle of the screen 10 minute warning.
function NWB:setMiddle10(info, value)
	self.db.global.middle10 = value;
end

function NWB:getMiddle10(info)
	return self.db.global.middle10;
end

--Middle of the screen 5 minute warning.
function NWB:setMiddle5(info, value)
	self.db.global.middle5 = value;
end

function NWB:getMiddle5(info)
	return self.db.global.middle5;
end

--Middle of the screen 1 minute warning.
function NWB:setMiddle1(info, value)
	self.db.global.middle1 = value;
end

function NWB:getMiddle1(info)
	return self.db.global.middle1;
end

--Middle of the screen 0 minute warning.
function NWB:setMiddle0(info, value)
	self.db.global.middle0 = value;
end

function NWB:getMiddle0(info)
	return self.db.global.middle0;
end

--Middle of the screen buff hand in warning.
function NWB:setMiddleBuffWarning(info, value)
	self.db.global.middleBuffWarning = value;
end

function NWB:getMiddleBuffWarning(info)
	return self.db.global.middleBuffWarning;
end

--Guild 30 minute warning.
function NWB:setGuild30(info, value)
	self.db.global.guild30 = value;
end

function NWB:getGuild30(info)
	return self.db.global.guild30;
end

--Guild 15 minute warning.
function NWB:setGuild15(info, value)
	self.db.global.guild15 = value;
end

function NWB:getGuild15(info)
	return self.db.global.guild15;
end

--Guild 10 minute warning.
function NWB:setGuild10(info, value)
	self.db.global.guild10 = value;
end

function NWB:getGuild10(info)
	return self.db.global.guild10;
end

--Guild 5 minute warning.
function NWB:setGuild5(info, value)
	self.db.global.guild5 = value;
end

function NWB:getGuild5(info)
	return self.db.global.guild5;
end

--Guild 1 minute warning.
function NWB:setGuild1(info, value)
	self.db.global.guild1 = value;
end

function NWB:getGuild1(info)
	return self.db.global.guild1;
end

--Guild 0 minute warning.
function NWB:setGuild0(info, value)
	self.db.global.guild0 = value;
end

function NWB:getGuild0(info)
	return self.db.global.guild0;
end

--Guild NPC dialogue started.
function NWB:setGuildNpcDialogue(info, value)
	self.db.global.guildNpcDialogue = value;
	NWB:sendData("GUILD");
end

function NWB:getGuildNpcDialogue(info)
	return self.db.global.guildNpcDialogue;
end

--Guild Zan dialogue started.
function NWB:setGuildZanDialogue(info, value)
	self.db.global.guildZanDialogue = value;
	NWB:sendData("GUILD");
end

function NWB:getGuildZanDialogue(info)
	return self.db.global.guildZanDialogue;
end

--Guild buff dropped.
function NWB:setGuildBuffDropped(info, value)
	self.db.global.guildBuffDropped = value;
	NWB:sendData("GUILD");
end

function NWB:getGuildBuffDropped(info)
	return self.db.global.guildBuffDropped;
end

--Guild NPC killed.
function NWB:setGuildNpcKilled(info, value)
	self.db.global.guildNpcKilled = value;
	NWB:sendData("GUILD");
end

function NWB:getGuildNpcKilled(info)
	return self.db.global.guildNpcKilled;
end

--Guild !wb command.
function NWB:setGuildCommand(info, value)
	self.db.global.guildCommand = value;
	NWB:sendData("GUILD");
end

function NWB:getGuildCommand(info)
	return self.db.global.guildCommand;
end

--Guild songflower picked announce.
function NWB:setGuildSongflower(info, value)
	self.db.global.guildSongflower = value;
end

function NWB:getGuildSongflower(info)
	return self.db.global.guildSongflower;
end

--Only set songflower timer if I picked it.
function NWB:setMySongflowerOnly(info, value)
	self.db.global.mySongflowerOnly = value;
end

function NWB:getMySongflowerOnly(info)
	return self.db.global.mySongflowerOnly;
end

--Sync songflowers on all channels when guild only is selected for data.
function NWB:setSyncFlowersAll(info, value)
	self.db.global.syncFlowersAll = value;
end

function NWB:getSyncFlowersAll(info)
	return self.db.global.syncFlowersAll;
end

--Sync songflowers on all channels when guild only is selected for data.
function NWB:setShowNewFlower(info, value)
	self.db.global.showNewFlower = value;
end

function NWB:getShowNewFlower(info)
	return self.db.global.showNewFlower;
end

--Show world map songflower markers.
function NWB:setShowSongflowerWorldmapMarkers(info, value)
	self.db.global.showSongflowerWorldmapMarkers = value;
	NWB:refreshFelwoodMarkers();
end

function NWB:getShowSongflowerWorldmapMarkers(info)
	return self.db.global.showSongflowerWorldmapMarkers;
end

--Show mini map songflower markers.
function NWB:setShowSongflowerMinimapMarkers(info, value)
	self.db.global.showSongflowerMinimapMarkers = value;
	NWB:refreshFelwoodMarkers();
end

function NWB:getShowSongflowerMinimapMarkers(info)
	return self.db.global.showSongflowerMinimapMarkers;
end

--Show world map tuber markers.
function NWB:setShowTuberWorldmapMarkers(info, value)
	self.db.global.showTuberWorldmapMarkers = value;
	NWB:refreshFelwoodMarkers();
end

function NWB:getShowTuberWorldmapMarkers(info)
	return self.db.global.showTuberWorldmapMarkers;
end

--Show mini map tuber markers.
function NWB:setShowTuberMinimapMarkers(info, value)
	self.db.global.showTuberMinimapMarkers = value;
	NWB:refreshFelwoodMarkers();
end

function NWB:getShowTuberMinimapMarkers(info)
	return self.db.global.showTuberMinimapMarkers;
end

--Show world map dragon markers.
function NWB:setShowDragonWorldmapMarkers(info, value)
	self.db.global.showDragonWorldmapMarkers = value;
	NWB:refreshFelwoodMarkers();
end

function NWB:getShowDragonWorldmapMarkers(info)
	return self.db.global.showDragonWorldmapMarkers;
end

--Show mini map dragon markers.
function NWB:setShowDragonMinimapMarkers(info, value)
	self.db.global.showDragonMinimapMarkers = value;
	NWB:refreshFelwoodMarkers();
end

function NWB:getShowDragonMinimapMarkers(info)
	return self.db.global.showDragonMinimapMarkers;
end

--Show expired timers.
function NWB:setShowExpiredTimers(info, value)
	self.db.global.showExpiredTimers = value;
end

function NWB:getShowExpiredTimers(info)
	return self.db.global.showExpiredTimers;
end

--Expired timers duration.
function NWB:setExpiredTimersDuration(info, value)
	self.db.global.expiredTimersDuration = value;
end

function NWB:getExpiredTimersDuration(info)
	return self.db.global.expiredTimersDuration;
end

--Show DMF at logon always.
function NWB:setShowDmfLogon(info, value)
	self.db.global.showDmfLogon = value;
end

function NWB:getShowDmfLogon(info)
	return self.db.global.showDmfLogon;
end

--Show DMF timer together with /wb.
function NWB:setShowDmfWb(info, value)
	self.db.global.showDmfWb = value;
end

function NWB:getShowDmfWb(info)
	return self.db.global.showDmfWb;
end

--Show DMF buff cooldown together with /wb.
function NWB:setShowDmfBuffWb(info, value)
	self.db.global.showDmfBuffWb = value;
end

function NWB:getShowDmfBuffWb(info)
	return self.db.global.showDmfBuffWb;
end

--Show DMF when timer is close to spawn.
function NWB:setShowDmfWhenClose(info, value)
	self.db.global.showDmfWhenClose = value;
end

function NWB:getShowDmfWhenClose(info)
	return self.db.global.showDmfWhenClose;
end

--Show DMF map marker.
function NWB:setShowDmfMap(info, value)
	self.db.global.showDmfMap = value;
	NWB:refreshDmfMarkers();
end

function NWB:getShowDmfMap(info)
	return self.db.global.showDmfMap;
end

--Rend logon msg.
function NWB:setLogonRend(info, value)
	self.db.global.logonRend = value;
end

function NWB:getLogonRend(info)
	return self.db.global.logonRend;
end

--Ony logon msg.
function NWB:setLogonOny(info, value)
	self.db.global.logonOny = value;
end

function NWB:getLogonOny(info)
	return self.db.global.logonOny;
end

--Nef logon msg.
function NWB:setLogonNef(info, value)
	self.db.global.logonNef = value;
end

function NWB:getLogonNef(info)
	return self.db.global.logonNef;
end

--DMF spawn logon msg.
function NWB:setLogonDmfSpawn(info, value)
	self.db.global.logonDmfSpawn = value;
end

function NWB:getLogonDmfSpawn(info)
	return self.db.global.logonDmfSpawn;
end

--DMF buff cooldown logon msg.
function NWB:setLogonDmfBuffCooldown(info, value)
	self.db.global.logonDmfBuffCooldown = value;
end

function NWB:getLogonDmfBuffCooldown(info)
	return self.db.global.logonDmfBuffCooldown;
end

--Filter guild chat buff warning.
function NWB:setFilterYells(info, value)
	self.db.global.filterYells = value;
end

function NWB:getFilterYells(info)
	return self.db.global.filterYells;
end

--Filter guild chat buff dropped.
function NWB:setFilterDrops(info, value)
	self.db.global.filterDrops = value;
end

function NWB:getFilterDrops(info)
	return self.db.global.filterDrops;
end

--Filter guild chat buff timer warnings.
function NWB:setFilterTimers(info, value)
	self.db.global.filterTimers = value;
end

function NWB:getFilterTimers(info)
	return self.db.global.filterTimers;
end

--Filter guild chat !wb and !dmf commands.
function NWB:setFilterCommand(info, value)
	self.db.global.filterCommand = value;
end

function NWB:getFilterCommand(info)
	return self.db.global.filterCommand;
end

--Filter guild chat !wb and !dmf command response.
function NWB:setFilterCommandResponse(info, value)
	self.db.global.filterCommandResponse = value;
end

function NWB:getFilterCommandResponse(info)
	return self.db.global.filterCommandResponse;
end

--Filter guild chat songflower picked.
function NWB:setFilterSongflowers(info, value)
	self.db.global.filterSongflowers = value;
end

function NWB:getFilterSongflowers(info)
	return self.db.global.filterSongflowers;
end

--Filter guild chat NPC killed msg.
function NWB:setFilterNpcKilled(info, value)
	self.db.global.filterNpcKilled = value;
end

function NWB:getFilterNpcKilled(info)
	return self.db.global.filterNpcKilled;
end

--Minimap layer frame.
function NWB:setMinimapLayerFrame(info, value)
	self.db.global.minimapLayerFrame = value;
	NWB:recalcMinimapLayerFrame();
end

function NWB:getMinimapLayerFrame(info)
	return self.db.global.minimapLayerFrame;
end

------------
---Sounds---
------------

local sounds = {
	--Random snipets from youtube.
	["NWB - Zelda"] = "Interface\\AddOns\\NovaWorldBuffs\\Media\\Zelda.ogg",
	["NWB - FF7"] = "Interface\\AddOns\\NovaWorldBuffs\\Media\\FF7.ogg",
	["NWB - Bell"] = "Interface\\AddOns\\NovaWorldBuffs\\Media\\Bell.ogg",
	["NWB - Alarm"] = "Interface\\AddOns\\NovaWorldBuffs\\Media\\Alarm.ogg",
	["NWB - Alien"] = "Interface\\AddOns\\NovaWorldBuffs\\Media\\Alien.ogg",
	["NWB - Clock"] = "Interface\\AddOns\\NovaWorldBuffs\\Media\\Clock.ogg",
	["NWB - Electronic"] = "Interface\\AddOns\\NovaWorldBuffs\\Media\\Electronic.ogg",
	["NWB - Pop"] = "Interface\\AddOns\\NovaWorldBuffs\\Media\\Pop.ogg",
}
function NWB:registerSounds()
	for k, v in pairs(sounds) do
		NWB.LSM:Register("sound", k, v);
	end
end

function NWB:getSounds(type)
	NWB.sounds = {};
	if (self.db.global.extraSoundOptions) then
		for _, v in pairs(NWB.LSM:List("sound")) do
			NWB.sounds[v] = v;
		end
	else
		for k, v in NWB:pairsByKeys(sounds) do
			NWB.sounds[k] = k;
		end
		NWB.sounds["None"] = "None";
	end
	if (type == "rend") then
		NWB.sounds["NWB - Rend Voice"] = "NWB - Rend Voice";
	elseif (type == "ony") then
		NWB.sounds["NWB - Ony Voice"] = "NWB - Ony Voice";
	elseif (type == "nef") then
		NWB.sounds["NWB - Nef Voice"] = "NWB - Nef Voice";
		NWB.sounds["NWB - Ony Voice"] = "NWB - Ony Voice";
	elseif (type == "zan") then
		NWB.sounds["NWB - Zandalar Voice"] = "NWB - Zandalar Voice";
	end
	return NWB.sounds;
end

--Disable all sounds.
function NWB:setDisableAllSounds(info, value)
	self.db.global.disableAllSounds = value;
end

function NWB:getDisableAllSounds(info)
	return self.db.global.disableAllSounds;
end

--Enable extra sounds.
function NWB:setExtraSoundOptions(info, value)
	self.db.global.extraSoundOptions = value;
end

function NWB:getExtraSoundOptions(info)
	return self.db.global.extraSoundOptions;
end

--Only plays sounds in city.
function NWB:setSoundOnlyInCity(info, value)
	self.db.global.soundOnlyInCity = value;
end

function NWB:getSoundOnlyInCity(info)
	return self.db.global.soundOnlyInCity;
end

--Only plays sounds in city.
function NWB:setSoundsDisableInInstances(info, value)
	self.db.global.soundsDisableInInstances = value;
end

function NWB:getSoundsDisableInInstances(info)
	return self.db.global.soundsDisableInInstances;
end

--First yell sound.
function NWB:setSoundsFirstYell(info, value)
	self.db.global.soundsFirstYell = value;
	local soundFile = NWB.LSM:Fetch("sound", value);
	PlaySoundFile(soundFile);
end

function NWB:getSoundsFirstYell(info)
	return self.db.global.soundsFirstYell;
end

--One minute warning sound.
function NWB:setSoundsOneMinute(info, value)
	self.db.global.soundsOneMinute = value;
	local soundFile = NWB.LSM:Fetch("sound", value);
	PlaySoundFile(soundFile);
end

function NWB:getSoundsOneMinute(info)
	return self.db.global.soundsOneMinute;
end

--Rend drop sound.
function NWB:setSoundsRendDrop(info, value)
	self.db.global.soundsRendDrop = value;
	if (value == "NWB - Rend Voice") then
		PlaySoundFile("Interface\\AddOns\\NovaWorldBuffs\\Media\\RendDropped.ogg", "Master");
	else
		local soundFile = NWB.LSM:Fetch("sound", value);
		PlaySoundFile(soundFile);
	end
end

function NWB:getSoundsRendDrop(info)
	return self.db.global.soundsRendDrop;
end

--Ony drop sound.
function NWB:setSoundsOnyDrop(info, value)
	self.db.global.soundsOnyDrop = value;
	if (value == "NWB - Ony Voice") then
		PlaySoundFile("Interface\\AddOns\\NovaWorldBuffs\\Media\\OnyxiaDropped.ogg", "Master");
	else
		local soundFile = NWB.LSM:Fetch("sound", value);
		PlaySoundFile(soundFile);
	end
end

function NWB:getSoundsOnyDrop(info)
	return self.db.global.soundsOnyDrop;
end

--Nef drop sound.
function NWB:setSoundsNefDrop(info, value)
	self.db.global.soundsNefDrop = value;
	if (value == "NWB - Nef Voice") then
		PlaySoundFile("Interface\\AddOns\\NovaWorldBuffs\\Media\\NefarianDropped.ogg", "Master");
	elseif (value == "NWB - Ony Voice") then
		PlaySoundFile("Interface\\AddOns\\NovaWorldBuffs\\Media\\OnyxiaDropped.ogg", "Master");
	else
		local soundFile = NWB.LSM:Fetch("sound", value);
		PlaySoundFile(soundFile);
	end
end

function NWB:getSoundsNefDrop(info)
	return self.db.global.soundsNefDrop;
end

--Zan drop sound.
function NWB:setSoundsZanDrop(info, value)
	self.db.global.soundsZanDrop = value;
	if (value == "NWB - Zandalar Voice") then
		PlaySoundFile("Interface\\AddOns\\NovaWorldBuffs\\Media\\ZandalarDropped.ogg", "Master");
	else
		local soundFile = NWB.LSM:Fetch("sound", value);
		PlaySoundFile(soundFile);
	end
end

function NWB:getSoundsZanDrop(info)
	return self.db.global.soundsZanDrop;
end