/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.sid;

import de.quippy.javamod.mixer.BasicMixer;
import de.quippy.javamod.multimedia.sid.SIDContainer;
import de.quippy.javamod.system.Log;
import de.quippy.sidplay.libsidplay.SIDPlay2;
import de.quippy.sidplay.libsidplay.common.ISID2Types;
import de.quippy.sidplay.libsidplay.common.SIDBuilder;
import de.quippy.sidplay.libsidplay.components.sidtune.SidTune;
import de.quippy.sidplay.resid_builder.ReSIDBuilder;
import javax.sound.sampled.AudioFormat;

public class SIDMixer
extends BasicMixer {
    private SIDPlay2 sidPlayer;
    private SidTune sidTune;
    private byte[] output;
    private int sampleRate;
    private int sidModel;
    private int optimization;
    private boolean sidFilter;
    private boolean isStereo;
    private static final int MULTIPLIER_SHIFT = 4;
    private static final int MULTIPLIER_VALUE = 16;
    private int multiplier;
    private int songNumber;
    private SIDContainer parentSIDContainer;

    public SIDMixer(SidTune sidTune, SIDContainer sIDContainer, int n, int n2, int n3, boolean bl, boolean bl2) {
        this.sidTune = sidTune;
        if (sidTune != null) {
            this.songNumber = sidTune.getInfo().currentSong;
            if (this.songNumber == 0) {
                this.songNumber = 1;
            }
        } else {
            this.songNumber = 1;
        }
        this.parentSIDContainer = sIDContainer;
        this.optimization = n3;
        this.sampleRate = n;
        this.sidModel = n2;
        this.sidFilter = bl;
        this.isStereo = bl2;
    }

    private void initialize() {
        try {
            this.sidPlayer = new SIDPlay2();
            ISID2Types.sid2_config_t sid2_config_t2 = this.sidPlayer.config();
            sid2_config_t2.frequency = this.sampleRate;
            sid2_config_t2.emulateStereo = this.isStereo;
            sid2_config_t2.playback = this.isStereo ? ISID2Types.sid2_playback_t.sid2_stereo : ISID2Types.sid2_playback_t.sid2_mono;
            sid2_config_t2.optimisation = (byte)this.optimization;
            sid2_config_t2.sidModel = this.sidModel == 0 ? ISID2Types.sid2_model_t.SID2_MODEL_CORRECT : (this.sidModel == 1 ? ISID2Types.sid2_model_t.SID2_MOS6581 : ISID2Types.sid2_model_t.SID2_MOS8580);
            sid2_config_t2.clockDefault = ISID2Types.sid2_clock_t.SID2_CLOCK_CORRECT;
            sid2_config_t2.clockSpeed = ISID2Types.sid2_clock_t.SID2_CLOCK_CORRECT;
            sid2_config_t2.clockForced = false;
            sid2_config_t2.environment = ISID2Types.sid2_env_t.sid2_envR;
            sid2_config_t2.forceDualSids = false;
            sid2_config_t2.leftVolume = 255L;
            sid2_config_t2.rightVolume = 255L;
            sid2_config_t2.sampleFormat = ISID2Types.sid2_sample_t.SID2_LITTLE_SIGNED;
            sid2_config_t2.sidDefault = ISID2Types.sid2_model_t.SID2_MOS6581;
            sid2_config_t2.sidSamples = true;
            sid2_config_t2.precision = 16;
            this.sidPlayer.config(sid2_config_t2);
            ReSIDBuilder reSIDBuilder = new ReSIDBuilder("ReSID");
            if (reSIDBuilder.bool()) {
                sid2_config_t2.sidEmulation = reSIDBuilder;
                reSIDBuilder.create(this.sidPlayer.info().maxsids);
                reSIDBuilder.filter(this.sidFilter);
                reSIDBuilder.sampling(this.sampleRate);
            }
            this.sidTune.selectSong(this.songNumber);
            this.sidPlayer.load(this.sidTune);
            this.multiplier = 16;
        }
        catch (Exception exception) {
            Log.error("[SIDMixer]", exception);
        }
    }

    public void setSampleRate(int n) {
        boolean bl;
        int n2 = this.sampleRate;
        boolean bl2 = bl = !this.isPaused();
        if (bl) {
            this.pausePlayback();
        }
        this.sampleRate = n;
        if (bl) {
            this.setAudioFormat(new AudioFormat(this.sampleRate, 16, 2, true, false));
            this.openAudioDevice();
            if (!this.isInitialized()) {
                this.sampleRate = n2;
                this.setAudioFormat(new AudioFormat(this.sampleRate, 16, 2, true, false));
                this.openAudioDevice();
            } else {
                ISID2Types.sid2_config_t sid2_config_t2 = this.sidPlayer.config();
                sid2_config_t2.frequency = this.sampleRate;
                SIDBuilder sIDBuilder = sid2_config_t2.sidEmulation;
                if (sIDBuilder != null && sIDBuilder.bool() && sIDBuilder instanceof ReSIDBuilder) {
                    ((ReSIDBuilder)sIDBuilder).sampling(this.sampleRate);
                }
                this.sidPlayer.config(sid2_config_t2);
            }
            this.pausePlayback();
        }
    }

    public void setSIDModel(int n) {
        boolean bl;
        boolean bl2 = bl = !this.isPaused();
        if (bl) {
            this.pausePlayback();
        }
        this.sidModel = n;
        ISID2Types.sid2_config_t sid2_config_t2 = this.sidPlayer.config();
        sid2_config_t2.sidModel = this.sidModel == 0 ? ISID2Types.sid2_model_t.SID2_MODEL_CORRECT : (this.sidModel == 1 ? ISID2Types.sid2_model_t.SID2_MOS6581 : ISID2Types.sid2_model_t.SID2_MOS8580);
        this.sidPlayer.config(sid2_config_t2);
        ReSIDBuilder reSIDBuilder = new ReSIDBuilder("ReSID");
        if (reSIDBuilder.bool()) {
            sid2_config_t2.sidEmulation = reSIDBuilder;
            reSIDBuilder.create(this.sidPlayer.info().maxsids);
            reSIDBuilder.filter(this.sidFilter);
            reSIDBuilder.sampling(this.sampleRate);
        }
        this.sidPlayer.config(sid2_config_t2);
        if (bl) {
            this.pausePlayback();
        }
    }

    public void setOptimization(int n) {
        boolean bl;
        boolean bl2 = bl = !this.isPaused();
        if (bl) {
            this.pausePlayback();
        }
        this.optimization = n;
        ISID2Types.sid2_config_t sid2_config_t2 = this.sidPlayer.config();
        sid2_config_t2.optimisation = (byte)this.optimization;
        this.sidPlayer.config(sid2_config_t2);
        ReSIDBuilder reSIDBuilder = new ReSIDBuilder("ReSID");
        if (reSIDBuilder.bool()) {
            sid2_config_t2.sidEmulation = reSIDBuilder;
            reSIDBuilder.create(this.sidPlayer.info().maxsids);
            reSIDBuilder.filter(this.sidFilter);
            reSIDBuilder.sampling(this.sampleRate);
        }
        this.sidPlayer.config(sid2_config_t2);
        if (bl) {
            this.pausePlayback();
        }
    }

    public void setUseSIDFilter(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = !this.isPaused();
        if (bl2) {
            this.pausePlayback();
        }
        this.sidFilter = bl;
        ISID2Types.sid2_config_t sid2_config_t2 = this.sidPlayer.config();
        SIDBuilder sIDBuilder = sid2_config_t2.sidEmulation;
        if (sIDBuilder != null && sIDBuilder.bool() && sIDBuilder instanceof ReSIDBuilder) {
            ((ReSIDBuilder)sIDBuilder).filter(this.sidFilter);
        }
        this.sidPlayer.config(sid2_config_t2);
        if (bl2) {
            this.pausePlayback();
        }
    }

    public void setVirtualStereo(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = !this.isPaused();
        if (bl2) {
            this.pausePlayback();
        }
        this.isStereo = bl;
        ISID2Types.sid2_config_t sid2_config_t2 = this.sidPlayer.config();
        sid2_config_t2.emulateStereo = this.isStereo;
        sid2_config_t2.playback = this.isStereo ? ISID2Types.sid2_playback_t.sid2_stereo : ISID2Types.sid2_playback_t.sid2_mono;
        this.sidPlayer.config(sid2_config_t2);
        ReSIDBuilder reSIDBuilder = new ReSIDBuilder("ReSID");
        if (reSIDBuilder.bool()) {
            sid2_config_t2.sidEmulation = reSIDBuilder;
            reSIDBuilder.create(this.sidPlayer.info().maxsids);
            reSIDBuilder.filter(this.sidFilter);
            reSIDBuilder.sampling(this.sampleRate);
        }
        this.sidPlayer.config(sid2_config_t2);
        if (bl2) {
            this.pausePlayback();
        }
    }

    @Override
    public boolean isSeekSupported() {
        return true;
    }

    @Override
    public long getLengthInMilliseconds() {
        return this.sidTune != null ? this.sidTune.getInfo().songs * 1000 : 0;
    }

    @Override
    public long getMillisecondPosition() {
        return (long)this.songNumber * 1000L;
    }

    @Override
    public int getChannelCount() {
        if (this.sidPlayer != null) {
            return this.sidPlayer.info().channels;
        }
        return 0;
    }

    @Override
    public int getCurrentKBperSecond() {
        return 16 * this.sampleRate / 1000;
    }

    @Override
    public int getCurrentSampleFrequency() {
        return this.sampleRate / 1000;
    }

    @Override
    protected void seek(long l) {
        if (this.sidTune != null) {
            this.pausePlayback();
            this.songNumber = (int)(l / 1000L) + 1;
            this.sidTune.selectSong(this.songNumber);
            this.sidPlayer.load(this.sidTune);
            this.parentSIDContainer.nameChanged();
            this.pausePlayback();
        }
    }

    @Override
    public void setMillisecondPosition(long l) {
        this.seek(l);
    }

    private byte[] getOutputBuffer(int n) {
        if (this.output == null || this.output.length < n) {
            this.output = new byte[n];
        }
        return this.output;
    }

    @Override
    public void startPlayback() {
        this.initialize();
        this.parentSIDContainer.nameChanged();
        this.setIsPlaying();
        try {
            this.setAudioFormat(new AudioFormat(this.sampleRate, 16, 2, true, false));
            this.openAudioDevice();
            if (!this.isInitialized()) {
                return;
            }
            try {
                boolean bl = false;
                int n = this.sampleRate >> 1;
                if (n % 2 != 0) {
                    ++n;
                }
                short[] sArray = new short[n];
                do {
                    this.sidPlayer.play(sArray, n);
                    int n2 = this.isStereo ? n : n << 1;
                    byte[] byArray = this.getOutputBuffer(n2);
                    int n3 = n2;
                    int n4 = n;
                    while (n4 > 0) {
                        byte by;
                        byte by2;
                        byte by3;
                        byte by4;
                        int n5;
                        if (this.isStereo) {
                            n5 = sArray[--n4] << 8 | sArray[--n4];
                            int n6 = sArray[--n4] << 8 | sArray[--n4];
                            n5 = n5 * this.multiplier >> 4;
                            n6 = n6 * this.multiplier >> 4;
                            by4 = (byte)(n5 & 0xFF);
                            by3 = (byte)(n5 >> 8);
                            by2 = (byte)(n6 & 0xFF);
                            by = (byte)(n6 >> 8);
                        } else {
                            n5 = (short)(sArray[--n4] << 8 | sArray[--n4]);
                            n5 = n5 * this.multiplier >> 4;
                            by4 = by2 = (byte)(n5 & 0xFF);
                            by3 = by = (byte)(n5 >> 8);
                        }
                        byArray[--n3] = by3;
                        byArray[--n3] = by4;
                        byArray[--n3] = by;
                        byArray[--n3] = by2;
                    }
                    this.writeSampleDataToLine(byArray, 0, n2);
                    if (this.isStopping()) {
                        this.setIsStopped();
                        break;
                    }
                    if (!this.isPausing()) continue;
                    this.setIsPaused();
                    while (this.isPaused()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } while (!bl);
                if (bl) {
                    this.setHasFinished();
                }
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        finally {
            this.sidPlayer.stop();
            this.setIsStopped();
            this.closeAudioDevice();
        }
    }
}

