/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.wav;

import de.quippy.javamod.io.FileOrPackedInputStream;
import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.wav.WavInfoPanel;
import de.quippy.javamod.multimedia.wav.WavMixer;
import de.quippy.javamod.system.Log;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.swing.JPanel;

public class WavContainer
extends MultimediaContainer {
    private static final String[] wavefile_Extensions;
    private JPanel wavInfoPanel;
    private WavMixer currentMixer;

    static {
        AudioFileFormat.Type[] typeArray = AudioSystem.getAudioFileTypes();
        wavefile_Extensions = new String[typeArray.length];
        int n = 0;
        while (n < typeArray.length) {
            WavContainer.wavefile_Extensions[n] = typeArray[n].getExtension();
            ++n;
        }
        MultimediaContainerManager.registerContainer(new WavContainer());
    }

    @Override
    public MultimediaContainer getInstance(URL uRL) {
        MultimediaContainer multimediaContainer = super.getInstance(uRL);
        AudioInputStream audioInputStream = null;
        try {
            try {
                audioInputStream = AudioSystem.getAudioInputStream(new FileOrPackedInputStream(uRL));
                ((WavInfoPanel)this.getInfoPanel()).fillInfoPanelWith(audioInputStream, this.getSongName());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        finally {
            if (audioInputStream != null) {
                try {
                    audioInputStream.close();
                }
                catch (IOException iOException) {
                    Log.error("IGNORED", iOException);
                }
            }
        }
        return multimediaContainer;
    }

    @Override
    public Object[] getSongInfosFor(URL uRL) {
        String string = MultimediaContainerManager.getSongNameFromURL(uRL);
        Long l = -1L;
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(new FileOrPackedInputStream(uRL));
            AudioFormat audioFormat = audioInputStream.getFormat();
            float f = audioFormat.getFrameRate();
            if (f != -1.0f) {
                l = (long)((double)((float)audioInputStream.getFrameLength() * 1000.0f / f) + 0.5);
            } else {
                int n = audioFormat.getChannels();
                int n2 = audioFormat.getSampleSizeInBits();
                int n3 = n2 >> 3;
                int n4 = (int)audioFormat.getSampleRate();
                l = (long)audioInputStream.available() / (long)n3 / (long)n * 1000L / (long)n4;
            }
        }
        catch (Throwable throwable) {}
        return new Object[]{string, l};
    }

    @Override
    public boolean canExport() {
        return false;
    }

    @Override
    public JPanel getInfoPanel() {
        if (this.wavInfoPanel == null) {
            this.wavInfoPanel = new WavInfoPanel();
        }
        return this.wavInfoPanel;
    }

    @Override
    public JPanel getConfigPanel() {
        return null;
    }

    @Override
    public String[] getFileExtensionList() {
        return wavefile_Extensions;
    }

    @Override
    public String getName() {
        return "Wave-File";
    }

    @Override
    public void configurationChanged(Properties properties) {
    }

    @Override
    public void configurationSave(Properties properties) {
    }

    @Override
    public Mixer createNewMixer() {
        this.currentMixer = new WavMixer(this.getFileURL());
        return this.currentMixer;
    }
}

