/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.decoder;

import de.quippy.jmac.decoder.IAPEDecompress;
import de.quippy.jmac.decoder.UnBitArrayBase;
import de.quippy.jmac.decoder.UnBitArrayState;
import de.quippy.jmac.info.APEFileInfo;
import de.quippy.jmac.info.APEInfo;
import de.quippy.jmac.info.APETag;
import de.quippy.jmac.info.WaveFormat;
import de.quippy.jmac.info.WaveHeader;
import de.quippy.jmac.prediction.IPredictorDecompress;
import de.quippy.jmac.prediction.PredictorDecompress3950toCurrent;
import de.quippy.jmac.prediction.PredictorDecompressNormal3930to3950;
import de.quippy.jmac.tools.CircleBuffer;
import de.quippy.jmac.tools.Crc32;
import de.quippy.jmac.tools.File;
import de.quippy.jmac.tools.JMACException;
import de.quippy.jmac.tools.Prepare;
import java.io.IOException;

public class APEDecompress
extends IAPEDecompress {
    private static final int DECODE_BLOCK_SIZE = 4096;
    protected int m_nBlockAlign;
    protected int m_nCurrentFrame;
    protected int m_nRealFrame;
    protected int m_nStartBlock;
    protected int m_nFinishBlock;
    protected int m_nCurrentBlock;
    protected boolean m_bIsRanged;
    protected boolean m_bDecompressorInitialized;
    protected Prepare m_Prepare = new Prepare();
    protected WaveFormat m_wfeInput;
    protected Crc32 m_nCRC;
    protected long m_nStoredCRC;
    protected int m_nSpecialCodes;
    protected APEInfo m_spAPEInfo;
    protected UnBitArrayBase m_spUnBitArray;
    protected UnBitArrayState m_BitArrayStateX = new UnBitArrayState();
    protected UnBitArrayState m_BitArrayStateY = new UnBitArrayState();
    protected IPredictorDecompress m_spNewPredictorX;
    protected IPredictorDecompress m_spNewPredictorY;
    protected int m_nLastX;
    protected boolean m_bErrorDecodingCurrentFrame;
    protected int m_nCurrentFrameBufferBlock;
    protected int m_nFrameBufferFinishedBlocks;
    protected CircleBuffer m_cbFrameBuffer = new CircleBuffer();

    public APEDecompress(APEInfo aPEInfo) {
        this(aPEInfo, -1, -1);
    }

    public APEDecompress(APEInfo aPEInfo, int n) {
        this(aPEInfo, n, -1);
    }

    public APEDecompress(APEInfo aPEInfo, int n, int n2) {
        this.m_spAPEInfo = aPEInfo;
        if (this.m_spAPEInfo.getApeInfoFileVersion() < 3930) {
            throw new JMACException("Unsupported Version");
        }
        this.m_wfeInput = this.m_spAPEInfo.getApeInfoWaveFormatEx();
        this.m_nBlockAlign = this.m_spAPEInfo.getApeInfoBlockAlign();
        this.m_bDecompressorInitialized = false;
        this.m_nCurrentFrame = 0;
        this.m_nRealFrame = 0;
        this.m_nCurrentBlock = 0;
        this.m_nCurrentFrameBufferBlock = 0;
        this.m_nFrameBufferFinishedBlocks = 0;
        this.m_bErrorDecodingCurrentFrame = false;
        this.m_nStartBlock = n < 0 ? 0 : Math.min(n, this.m_spAPEInfo.getApeInfoTotalBlocks());
        this.m_nFinishBlock = n2 < 0 ? this.m_spAPEInfo.getApeInfoTotalBlocks() : Math.min(n2, this.m_spAPEInfo.getApeInfoTotalBlocks());
        this.m_bIsRanged = this.m_nStartBlock != 0 || this.m_nFinishBlock != this.m_spAPEInfo.getApeInfoTotalBlocks();
    }

    @Override
    public int GetData(byte[] byArray, int n) throws IOException {
        int n2;
        int n3;
        this.InitializeDecompressor();
        int n4 = this.m_nFinishBlock - this.m_nCurrentBlock;
        int n5 = n3 = Math.min(n, n4);
        int n6 = 1;
        int n7 = 0;
        while (n5 > 0 && n6 > 0) {
            this.FillFrameBuffer();
            n2 = this.m_nFrameBufferFinishedBlocks;
            n6 = Math.min(n5, n2);
            if (n6 <= 0) continue;
            this.m_cbFrameBuffer.Get(byArray, n7, n6 * this.m_nBlockAlign);
            n7 += n6 * this.m_nBlockAlign;
            n5 -= n6;
            this.m_nFrameBufferFinishedBlocks -= n6;
        }
        n2 = n3 - n5;
        this.m_nCurrentBlock += n2;
        return n2;
    }

    @Override
    public void Seek(int n) throws IOException {
        this.InitializeDecompressor();
        if ((n += this.m_nStartBlock) >= this.m_nFinishBlock) {
            n = this.m_nFinishBlock - 1;
        }
        if (n < this.m_nStartBlock) {
            n = this.m_nStartBlock;
        }
        int n2 = n / this.m_spAPEInfo.getApeInfoBlocksPerFrame();
        int n3 = n % this.m_spAPEInfo.getApeInfoBlocksPerFrame();
        int n4 = n3 * this.m_nBlockAlign;
        this.m_nCurrentBlock = n2 * this.getApeInfoBlocksPerFrame();
        this.m_nCurrentFrameBufferBlock = n2 * this.getApeInfoBlocksPerFrame();
        this.m_nCurrentFrame = n2;
        this.m_nFrameBufferFinishedBlocks = 0;
        this.m_cbFrameBuffer.Empty();
        this.SeekToFrame(this.m_nCurrentFrame);
        byte[] byArray = new byte[n4];
        int n5 = this.GetData(byArray, n3);
        if (n5 != n3) {
            throw new JMACException("Undefined Error");
        }
    }

    @Override
    public int getApeInfoDecompressCurrentBlock() {
        return this.m_nCurrentBlock - this.m_nStartBlock;
    }

    @Override
    public int getApeInfoDecompressCurrentMS() {
        int n = this.m_spAPEInfo.getApeInfoSampleRate();
        if (n > 0) {
            return (int)((long)this.m_nCurrentBlock * 1000L / (long)n);
        }
        return 0;
    }

    @Override
    public int getApeInfoDecompressTotalBlocks() {
        return this.m_nFinishBlock - this.m_nStartBlock;
    }

    @Override
    public int getApeInfoDecompressLengthMS() {
        int n = this.m_spAPEInfo.getApeInfoSampleRate();
        if (n > 0) {
            return (int)((long)(this.m_nFinishBlock - this.m_nStartBlock) * 1000L / (long)n);
        }
        return 0;
    }

    @Override
    public int getApeInfoDecompressCurrentBitRate() throws IOException {
        return this.m_spAPEInfo.getApeInfoFrameBitrate(this.m_nCurrentFrame);
    }

    @Override
    public int getApeInfoDecompressAverageBitrate() throws IOException {
        if (this.m_bIsRanged || !this.m_spAPEInfo.getApeInfoIoSource().isLocal()) {
            int n = this.m_spAPEInfo.getApeInfoBlocksPerFrame();
            int n2 = this.m_nStartBlock / n;
            int n3 = (this.m_nFinishBlock + n - 1) / n;
            int n4 = this.m_spAPEInfo.getApeInfoFrameBytes(n2) * (this.m_nStartBlock % n) / n;
            if (n3 != n2) {
                n4 += this.m_spAPEInfo.getApeInfoFrameBytes(n3) * (this.m_nFinishBlock % n) / n;
            }
            int n5 = this.m_spAPEInfo.getApeInfoTotalFrames();
            int n6 = n2 + 1;
            while (n6 < n3 && n6 < n5) {
                n4 += this.m_spAPEInfo.getApeInfoFrameBytes(n6);
                ++n6;
            }
            n6 = (int)((long)(this.m_nFinishBlock - this.m_nStartBlock) * 1000L / (long)this.m_spAPEInfo.getApeInfoSampleRate());
            if (n6 != 0) {
                return n4 * 8 / n6;
            }
        } else {
            return this.m_spAPEInfo.getApeInfoAverageBitrate();
        }
        return 0;
    }

    @Override
    public int getApeInfoWavHeaderBytes() {
        if (this.m_bIsRanged) {
            return 44;
        }
        return this.m_spAPEInfo.getApeInfoWavHeaderBytes();
    }

    @Override
    public byte[] getApeInfoWavHeaderData(int n) {
        if (this.m_bIsRanged) {
            if (44 > n) {
                return null;
            }
            WaveFormat waveFormat = this.m_spAPEInfo.getApeInfoWaveFormatEx();
            WaveHeader waveHeader = new WaveHeader();
            WaveHeader.FillWaveHeader(waveHeader, (this.m_nFinishBlock - this.m_nStartBlock) * this.m_spAPEInfo.getApeInfoBlockAlign(), waveFormat, 0);
            return waveHeader.write();
        }
        return this.m_spAPEInfo.getApeInfoWavHeaderData(n);
    }

    @Override
    public int getApeInfoWavTerminatingBytes() {
        if (this.m_bIsRanged) {
            return 0;
        }
        return this.m_spAPEInfo.getApeInfoWavTerminatingBytes();
    }

    @Override
    public byte[] getApeInfoWavTerminatingData(int n) throws IOException {
        if (this.m_bIsRanged) {
            return null;
        }
        return this.m_spAPEInfo.getApeInfoWavTerminatingData(n);
    }

    @Override
    public WaveFormat getApeInfoWaveFormatEx() {
        return this.m_spAPEInfo.getApeInfoWaveFormatEx();
    }

    @Override
    public File getApeInfoIoSource() {
        return this.m_spAPEInfo.getApeInfoIoSource();
    }

    @Override
    public int getApeInfoBlocksPerFrame() {
        return this.m_spAPEInfo.getApeInfoBlocksPerFrame();
    }

    @Override
    public int getApeInfoFileVersion() {
        return this.m_spAPEInfo.getApeInfoFileVersion();
    }

    @Override
    public int getApeInfoCompressionLevel() {
        return this.m_spAPEInfo.getApeInfoCompressionLevel();
    }

    @Override
    public int getApeInfoFormatFlags() {
        return this.m_spAPEInfo.getApeInfoFormatFlags();
    }

    @Override
    public int getApeInfoSampleRate() {
        return this.m_spAPEInfo.getApeInfoSampleRate();
    }

    @Override
    public int getApeInfoBitsPerSample() {
        return this.m_spAPEInfo.getApeInfoBitsPerSample();
    }

    @Override
    public int getApeInfoBytesPerSample() {
        return this.m_spAPEInfo.getApeInfoBytesPerSample();
    }

    @Override
    public int getApeInfoChannels() {
        return this.m_spAPEInfo.getApeInfoChannels();
    }

    @Override
    public int getApeInfoBlockAlign() {
        return this.m_spAPEInfo.getApeInfoBlockAlign();
    }

    @Override
    public int getApeInfoFinalFrameBlocks() {
        return this.m_spAPEInfo.getApeInfoFinalFrameBlocks();
    }

    @Override
    public int getApeInfoTotalFrames() {
        return this.m_spAPEInfo.getApeInfoTotalFrames();
    }

    @Override
    public int getApeInfoWavDataBytes() {
        return this.m_spAPEInfo.getApeInfoWavDataBytes();
    }

    @Override
    public int getApeInfoWavTotalBytes() {
        return this.m_spAPEInfo.getApeInfoWavTotalBytes();
    }

    @Override
    public int getApeInfoApeTotalBytes() {
        return this.m_spAPEInfo.getApeInfoApeTotalBytes();
    }

    @Override
    public int getApeInfoTotalBlocks() {
        return this.m_spAPEInfo.getApeInfoTotalBlocks();
    }

    @Override
    public int getApeInfoLengthMs() {
        return this.m_spAPEInfo.getApeInfoLengthMs();
    }

    @Override
    public int getApeInfoAverageBitrate() {
        return this.m_spAPEInfo.getApeInfoAverageBitrate();
    }

    @Override
    public int getApeInfoSeekByte(int n) {
        return this.m_spAPEInfo.getApeInfoSeekByte(n);
    }

    @Override
    public int getApeInfoFrameBytes(int n) throws IOException {
        return this.m_spAPEInfo.getApeInfoFrameBytes(n);
    }

    @Override
    public int getApeInfoFrameBlocks(int n) {
        return this.m_spAPEInfo.getApeInfoFrameBlocks(n);
    }

    @Override
    public int getApeInfoFrameBitrate(int n) throws IOException {
        return this.m_spAPEInfo.getApeInfoFrameBitrate(n);
    }

    @Override
    public int getApeInfoDecompressedBitrate() {
        return this.m_spAPEInfo.getApeInfoDecompressedBitrate();
    }

    @Override
    public int getApeInfoPeakLevel() {
        return this.m_spAPEInfo.getApeInfoPeakLevel();
    }

    @Override
    public int getApeInfoSeekBit(int n) {
        return this.m_spAPEInfo.getApeInfoSeekBit(n);
    }

    @Override
    public APETag getApeInfoTag() {
        return this.m_spAPEInfo.getApeInfoTag();
    }

    @Override
    public APEFileInfo getApeInfoInternalInfo() {
        return this.m_spAPEInfo.getApeInfoInternalInfo();
    }

    public void SeekToFrame(int n) throws IOException {
        int n2 = (this.m_spAPEInfo.getApeInfoSeekByte(n) - this.m_spAPEInfo.getApeInfoSeekByte(0)) % 4;
        this.m_spUnBitArray.FillAndResetBitArray(n == this.m_nRealFrame ? -1 : this.m_spAPEInfo.getApeInfoSeekByte(n) - n2, n2 * 8);
        this.m_nRealFrame = n;
    }

    protected void DecodeBlocksToFrameBuffer(int n) throws IOException {
        int n2 = 0;
        try {
            if (this.m_wfeInput.nChannels == 2) {
                if ((this.m_nSpecialCodes & 1) > 0 && (this.m_nSpecialCodes & 2) > 0) {
                    n2 = 0;
                    while (n2 < n) {
                        this.m_Prepare.unprepare(0, 0, this.m_wfeInput, this.m_cbFrameBuffer.GetDirectWritePointer(), this.m_nCRC);
                        this.m_cbFrameBuffer.UpdateAfterDirectWrite(this.m_nBlockAlign);
                        ++n2;
                    }
                } else if ((this.m_nSpecialCodes & 4) > 0) {
                    n2 = 0;
                    while (n2 < n) {
                        int n3 = this.m_spNewPredictorX.DecompressValue(this.m_spUnBitArray.DecodeValueRange(this.m_BitArrayStateX));
                        this.m_Prepare.unprepare(n3, 0, this.m_wfeInput, this.m_cbFrameBuffer.GetDirectWritePointer(), this.m_nCRC);
                        this.m_cbFrameBuffer.UpdateAfterDirectWrite(this.m_nBlockAlign);
                        ++n2;
                    }
                } else if (this.m_spAPEInfo.getApeInfoFileVersion() >= 3950) {
                    n2 = 0;
                    while (n2 < n) {
                        int n4;
                        int n5 = this.m_spUnBitArray.DecodeValueRange(this.m_BitArrayStateY);
                        int n6 = this.m_spUnBitArray.DecodeValueRange(this.m_BitArrayStateX);
                        int n7 = this.m_spNewPredictorY.DecompressValue(n5, this.m_nLastX);
                        this.m_nLastX = n4 = this.m_spNewPredictorX.DecompressValue(n6, n7);
                        this.m_Prepare.unprepare(n4, n7, this.m_wfeInput, this.m_cbFrameBuffer.GetDirectWritePointer(), this.m_nCRC);
                        this.m_cbFrameBuffer.UpdateAfterDirectWrite(this.m_nBlockAlign);
                        ++n2;
                    }
                } else {
                    n2 = 0;
                    while (n2 < n) {
                        int n8 = this.m_spNewPredictorX.DecompressValue(this.m_spUnBitArray.DecodeValueRange(this.m_BitArrayStateX));
                        int n9 = this.m_spNewPredictorY.DecompressValue(this.m_spUnBitArray.DecodeValueRange(this.m_BitArrayStateY));
                        this.m_Prepare.unprepare(n8, n9, this.m_wfeInput, this.m_cbFrameBuffer.GetDirectWritePointer(), this.m_nCRC);
                        this.m_cbFrameBuffer.UpdateAfterDirectWrite(this.m_nBlockAlign);
                        ++n2;
                    }
                }
            } else if ((this.m_nSpecialCodes & 1) > 0) {
                n2 = 0;
                while (n2 < n) {
                    this.m_Prepare.unprepare(0, 0, this.m_wfeInput, this.m_cbFrameBuffer.GetDirectWritePointer(), this.m_nCRC);
                    this.m_cbFrameBuffer.UpdateAfterDirectWrite(this.m_nBlockAlign);
                    ++n2;
                }
            } else {
                n2 = 0;
                while (n2 < n) {
                    int n10 = this.m_spNewPredictorX.DecompressValue(this.m_spUnBitArray.DecodeValueRange(this.m_BitArrayStateX));
                    this.m_Prepare.unprepare(n10, 0, this.m_wfeInput, this.m_cbFrameBuffer.GetDirectWritePointer(), this.m_nCRC);
                    this.m_cbFrameBuffer.UpdateAfterDirectWrite(this.m_nBlockAlign);
                    ++n2;
                }
            }
        }
        catch (JMACException jMACException) {
            this.m_bErrorDecodingCurrentFrame = true;
        }
        this.m_nCurrentFrameBufferBlock += n;
    }

    protected void FillFrameBuffer() throws IOException {
        int n = this.m_cbFrameBuffer.MaxAdd() / this.m_nBlockAlign;
        boolean bl = false;
        int n2 = n;
        while (n2 > 0) {
            int n3 = this.getApeInfoFrameBlocks(this.m_nCurrentFrame);
            if (n3 < 0) break;
            int n4 = this.m_nCurrentFrameBufferBlock % this.getApeInfoBlocksPerFrame();
            int n5 = n3 - n4;
            int n6 = Math.min(n5, n2);
            if (n4 == 0) {
                this.startFrame();
            }
            int n7 = this.m_cbFrameBuffer.MaxGet();
            this.DecodeBlocksToFrameBuffer(n6);
            if (n4 + n6 >= n3) {
                this.EndFrame();
                if (this.m_bErrorDecodingCurrentFrame) {
                    this.m_cbFrameBuffer.RemoveTail(this.m_cbFrameBuffer.MaxGet() - n7);
                    byte by = this.getApeInfoBitsPerSample() == 8 ? (byte)127 : 0;
                    int n8 = 0;
                    while (n8 < n3 * this.m_nBlockAlign) {
                        this.m_cbFrameBuffer.GetDirectWritePointer().append(by);
                        this.m_cbFrameBuffer.UpdateAfterDirectWrite(1);
                        ++n8;
                    }
                    this.SeekToFrame(this.m_nCurrentFrame);
                    bl = true;
                }
            }
            n2 -= n6;
        }
        if (bl) {
            throw new JMACException("Invalid Checksum");
        }
    }

    protected void startFrame() throws IOException {
        this.m_nCRC = new Crc32();
        this.m_nStoredCRC = this.m_spUnBitArray.DecodeValue(0);
        this.m_bErrorDecodingCurrentFrame = false;
        this.m_nSpecialCodes = 0;
        if (this.m_spAPEInfo.getApeInfoFileVersion() > 3820) {
            if ((this.m_nStoredCRC & 0x80000000L) != 0L) {
                this.m_nSpecialCodes = (int)this.m_spUnBitArray.DecodeValue(0);
            }
            this.m_nStoredCRC &= Integer.MAX_VALUE;
        }
        this.m_spNewPredictorX.Flush();
        this.m_spNewPredictorY.Flush();
        this.m_spUnBitArray.FlushState(this.m_BitArrayStateX);
        this.m_spUnBitArray.FlushState(this.m_BitArrayStateY);
        this.m_spUnBitArray.FlushBitArray();
        this.m_nLastX = 0;
    }

    protected void EndFrame() {
        this.m_nFrameBufferFinishedBlocks += this.getApeInfoFrameBlocks(this.m_nCurrentFrame);
        ++this.m_nCurrentFrame;
        this.m_spUnBitArray.finalize_internally();
        if (this.m_nCRC.checksum() != this.m_nStoredCRC) {
            this.m_bErrorDecodingCurrentFrame = true;
        }
    }

    protected void InitializeDecompressor() throws IOException {
        if (this.m_bDecompressorInitialized) {
            return;
        }
        this.m_bDecompressorInitialized = true;
        this.m_cbFrameBuffer.CreateBuffer((this.getApeInfoBlocksPerFrame() + 4096) * this.m_nBlockAlign, this.m_nBlockAlign * 64);
        this.m_spUnBitArray = UnBitArrayBase.CreateUnBitArray(this, this.m_spAPEInfo.getApeInfoFileVersion());
        if (this.m_spAPEInfo.getApeInfoFileVersion() >= 3950) {
            this.m_spNewPredictorX = new PredictorDecompress3950toCurrent(this.m_spAPEInfo.getApeInfoCompressionLevel(), this.m_spAPEInfo.getApeInfoFileVersion());
            this.m_spNewPredictorY = new PredictorDecompress3950toCurrent(this.m_spAPEInfo.getApeInfoCompressionLevel(), this.m_spAPEInfo.getApeInfoFileVersion());
        } else {
            this.m_spNewPredictorX = new PredictorDecompressNormal3930to3950(this.m_spAPEInfo.getApeInfoCompressionLevel(), this.m_spAPEInfo.getApeInfoFileVersion());
            this.m_spNewPredictorY = new PredictorDecompressNormal3930to3950(this.m_spAPEInfo.getApeInfoCompressionLevel(), this.m_spAPEInfo.getApeInfoFileVersion());
        }
        this.Seek(-1);
    }
}

