/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.decoder;

import de.quippy.jmac.decoder.APEDecompress;
import de.quippy.jmac.decoder.APEDecompressOld;
import de.quippy.jmac.info.APEFileInfo;
import de.quippy.jmac.info.APEInfo;
import de.quippy.jmac.info.APELink;
import de.quippy.jmac.info.APETag;
import de.quippy.jmac.info.WaveFormat;
import de.quippy.jmac.tools.File;
import de.quippy.jmac.tools.JMACException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class IAPEDecompress {
    public abstract int GetData(byte[] var1, int var2) throws IOException;

    public abstract void Seek(int var1) throws IOException;

    public abstract int getApeInfoDecompressCurrentBlock();

    public abstract int getApeInfoDecompressCurrentMS();

    public abstract int getApeInfoDecompressTotalBlocks();

    public abstract int getApeInfoDecompressLengthMS();

    public abstract int getApeInfoDecompressCurrentBitRate() throws IOException;

    public abstract int getApeInfoDecompressAverageBitrate() throws IOException;

    public abstract File getApeInfoIoSource();

    public abstract int getApeInfoBlocksPerFrame();

    public abstract int getApeInfoFileVersion();

    public abstract int getApeInfoCompressionLevel();

    public abstract int getApeInfoFormatFlags();

    public abstract int getApeInfoSampleRate();

    public abstract int getApeInfoBitsPerSample();

    public abstract int getApeInfoBytesPerSample();

    public abstract int getApeInfoChannels();

    public abstract int getApeInfoBlockAlign();

    public abstract int getApeInfoFinalFrameBlocks();

    public abstract int getApeInfoTotalFrames();

    public abstract int getApeInfoWavHeaderBytes();

    public abstract int getApeInfoWavTerminatingBytes();

    public abstract int getApeInfoWavDataBytes();

    public abstract int getApeInfoWavTotalBytes();

    public abstract int getApeInfoApeTotalBytes();

    public abstract int getApeInfoTotalBlocks();

    public abstract int getApeInfoLengthMs();

    public abstract int getApeInfoAverageBitrate();

    public abstract int getApeInfoSeekByte(int var1);

    public abstract int getApeInfoFrameBytes(int var1) throws IOException;

    public abstract int getApeInfoFrameBlocks(int var1);

    public abstract int getApeInfoFrameBitrate(int var1) throws IOException;

    public abstract int getApeInfoDecompressedBitrate();

    public abstract int getApeInfoPeakLevel();

    public abstract int getApeInfoSeekBit(int var1);

    public abstract WaveFormat getApeInfoWaveFormatEx();

    public abstract byte[] getApeInfoWavHeaderData(int var1);

    public abstract APETag getApeInfoTag();

    public abstract byte[] getApeInfoWavTerminatingData(int var1) throws IOException;

    public abstract APEFileInfo getApeInfoInternalInfo();

    public static IAPEDecompress CreateIAPEDecompressCore(APEInfo aPEInfo, int n, int n2) {
        IAPEDecompress iAPEDecompress = null;
        if (aPEInfo != null) {
            iAPEDecompress = aPEInfo.getApeInfoFileVersion() >= 3930 ? new APEDecompress(aPEInfo, n, n2) : new APEDecompressOld(aPEInfo, n, n2);
        }
        return iAPEDecompress;
    }

    public static APEInfo CreateAPEInfo(File file) throws IOException {
        APEInfo aPEInfo = null;
        if (file.isLocal()) {
            String string = file.getExtension();
            if (string.toLowerCase().equals(".mac") || string.toLowerCase().equals(".ape")) {
                aPEInfo = new APEInfo(file);
            }
        } else {
            aPEInfo = new APEInfo(file);
        }
        if (aPEInfo == null) {
            throw new JMACException("Invalid Input File");
        }
        return aPEInfo;
    }

    public static IAPEDecompress CreateIAPEDecompress(File file) throws IOException {
        Object object;
        APEInfo aPEInfo = null;
        int n = -1;
        int n2 = -1;
        if (file.isLocal()) {
            object = file.getFilename();
            String string = file.getExtension();
            if (string.toLowerCase().equals(".apl")) {
                APELink aPELink = new APELink((String)object);
                if (aPELink.GetIsLinkFile()) {
                    URL uRL = null;
                    try {
                        uRL = new URL(aPELink.GetImageFilename());
                        aPEInfo = new APEInfo(uRL);
                    }
                    catch (MalformedURLException malformedURLException) {
                        aPEInfo = new APEInfo(new java.io.File(aPELink.GetImageFilename()));
                    }
                    n = aPELink.GetStartBlock();
                    n2 = aPELink.GetFinishBlock();
                }
            } else if (string.toLowerCase().equals(".mac") || string.toLowerCase().equals(".ape")) {
                aPEInfo = new APEInfo(file);
            }
        } else {
            aPEInfo = new APEInfo(file);
        }
        if (aPEInfo == null) {
            throw new JMACException("Invalid Input File");
        }
        object = IAPEDecompress.CreateIAPEDecompressCore(aPEInfo, n, n2);
        return object;
    }

    public static IAPEDecompress CreateIAPEDecompressEx(APEInfo aPEInfo, int n, int n2) {
        return IAPEDecompress.CreateIAPEDecompressCore(aPEInfo, n, n2);
    }
}

