/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.libsidplay.components.sidtune;

import de.quippy.sidplay.libsidplay.components.sidtune.SidTune;

public class PP20 {
    private static final String _pp20_txt_packeddatacorrupt = "PowerPacker: Packed data is corrupt";
    private static final String _pp20_txt_unrecognized = "PowerPacker: Unrecognized compression method";
    private static final String _pp20_txt_uncompressed = "Not compressed with PowerPacker (PP20)";
    private static final String _pp20_txt_fast = "PowerPacker: fast compression";
    private static final String _pp20_txt_mediocre = "PowerPacker: mediocre compression";
    private static final String _pp20_txt_good = "PowerPacker: good compression";
    private static final String _pp20_txt_verygood = "PowerPacker: very good compression";
    private static final String _pp20_txt_best = "PowerPacker: best compression";
    private static final String PP_ID = "PP20";
    private short[] efficiency = new short[4];
    private short[] source;
    short[] dest;
    private int readPtr;
    private int writePtr;
    private int current;
    private int bits;
    private boolean globalError;
    private String statusString = "Not compressed with PowerPacker (PP20)";

    public boolean isCompressed(short[] sArray, int n) {
        if (n < 8) {
            return false;
        }
        short[] sArray2 = sArray;
        if (!new String(new byte[]{(byte)sArray2[0], (byte)sArray2[1], (byte)sArray2[2], (byte)sArray2[3]}).equals(PP_ID)) {
            this.statusString = _pp20_txt_uncompressed;
            return false;
        }
        return this.checkEfficiency(sArray, 4);
    }

    public int decompress(short[] sArray, int n, SidTune.Decompressed decompressed) {
        this.source = sArray;
        this.globalError = false;
        this.readPtr = 0;
        if (!this.isCompressed(sArray, n)) {
            return 0;
        }
        this.readPtr += n - 4;
        int n2 = this.readBEdword(sArray, this.readPtr);
        int n3 = n2 >> 8;
        this.dest = new short[n3];
        this.writePtr = n3;
        this.bits = 32 - (n2 & 0xFF);
        this.bytesTOdword();
        if (this.bits != 32) {
            this.current >>= 32 - this.bits;
        }
        do {
            if (this.readBits(1) == 0) {
                this.bytes();
            }
            if (this.writePtr > 0) {
                this.sequence();
            }
            if (!this.globalError) continue;
            n3 = 0;
            break;
        } while (this.writePtr > 0);
        if (n3 > 0) {
            decompressed.destBufRef = new short[this.dest.length];
            System.arraycopy(this.dest, 0, decompressed.destBufRef, 0, this.dest.length);
        }
        return n3;
    }

    public final String getStatusString() {
        return this.statusString;
    }

    private boolean checkEfficiency(short[] sArray, int n) {
        System.arraycopy(sArray, n, this.efficiency, 0, 4);
        int n2 = this.readBEdword(this.efficiency, 0);
        if (n2 != 0x9090909 && n2 != 0x90A0A0A && n2 != 151653131 && n2 != 151653388 && n2 != 151653389) {
            this.statusString = _pp20_txt_unrecognized;
            return false;
        }
        switch (n2) {
            case 0x9090909: {
                this.statusString = _pp20_txt_fast;
                break;
            }
            case 0x90A0A0A: {
                this.statusString = _pp20_txt_mediocre;
                break;
            }
            case 151653131: {
                this.statusString = _pp20_txt_good;
                break;
            }
            case 151653388: {
                this.statusString = _pp20_txt_verygood;
                break;
            }
            case 151653389: {
                this.statusString = _pp20_txt_best;
            }
        }
        return true;
    }

    private void bytesTOdword() {
        this.readPtr -= 4;
        if (this.readPtr < 0) {
            this.statusString = _pp20_txt_packeddatacorrupt;
            this.globalError = true;
        } else {
            this.current = this.readBEdword(this.source, this.readPtr);
        }
    }

    private int readBits(int n) {
        int n2 = 0;
        while (n > 0) {
            n2 += n2;
            n2 |= this.current & 1;
            this.current >>= 1;
            if (--this.bits == 0) {
                this.bytesTOdword();
                this.bits = 32;
            }
            --n;
        }
        return n2;
    }

    private void bytes() {
        int n;
        int n2 = n = this.readBits(2);
        while (n == 3) {
            n = this.readBits(2);
            n2 += n;
        }
        ++n2;
        while (n2 > 0) {
            if (this.writePtr > 0) {
                this.dest[--this.writePtr] = (short)this.readBits(8);
            } else {
                this.statusString = _pp20_txt_packeddatacorrupt;
                this.globalError = true;
            }
            --n2;
        }
    }

    private void sequence() {
        int n;
        int n2 = this.readBits(2);
        int n3 = this.efficiency[n2];
        if ((n2 += 2) != 5) {
            n = this.readBits(n3);
        } else {
            if (this.readBits(1) == 0) {
                n3 = 7;
            }
            n = this.readBits(n3);
            int n4 = this.readBits(3);
            n2 += n4;
            while (n4 == 7) {
                n4 = this.readBits(3);
                n2 += n4;
            }
        }
        while (n2 > 0) {
            if (this.writePtr > 0) {
                --this.writePtr;
                this.dest[this.writePtr] = this.dest[this.writePtr + 1 + n];
            } else {
                this.statusString = _pp20_txt_packeddatacorrupt;
                this.globalError = true;
            }
            --n2;
        }
    }

    int readBEdword(short[] sArray, int n) {
        return (sArray[n + 0] << 24) + (sArray[n + 1] << 16) + (sArray[n + 2] << 8) + sArray[n + 3] << 0;
    }
}

