﻿/* 
* 本程序主要用于将一个附件路径转换为可预览的文件模式
* Author：新启科技
*/
(function (window, undefined, $) {
    var objwidth = 400, //元素宽度
    objheight = 400; //元素高度
    var $ = window.jQuery;
    var path2html = function (id, path) {
        /// <summary>
        /// 将制定地址转化为可视化html
        /// ID为显示容器，Path为路径地址，注意：该路径必须为绝对路径如：http://www.xxx.com/111.jpg
        /// </summary>
        var ext = getFileExt(path);
        if (ext != "") {
            if (ext == ".jpg" || ext == ".png" || ext == ".gif") {//如果为图片
                $("#" + id).html("<A href=\"" + path + "\" rel=colorbox1 target=_blank><img src='" + path + "' /></a>");
            }
            else if (ext == ".pdf" || ext == ".doc" || ext == ".docx" || ext == ".xls"
              || ext == ".xlsx" || ext == ".xlsx") {//如果为文档
                $("#" + id).html("<iframe  src='/Training/Courseware/Office/OfficeShow.aspx?p=" + path + "' width='100%' height='100%'></iframe>");
            }
            else if (ext == ".flv" || ext == ".mp4") {//如果为视频
                getavplay(id, path);
            }
            else if (ext == ".swf") {//如果为动画
                getflash(id, path);
            }
            else if (ext == ".mp3") {//如果为声音
                getmp3(id, path);
            }
            else {//其它下载
                var title = path.substring(path.lastIndexOf("/") + 1, path.lastIndexOf("."));
                var cate = ext, ico = "";
                if (cate == ".rar") {
                    ico = "<img border=\"0\" src=\"/Themes/Images/32/rar.png\" height=\"32\" width=\"32\"  />";
                }
                else if (cate == ".zip") {
                    ico = "<img border=\"0\" src=\"/Themes/Images/32/zip.png\" height=\"32\" width=\"32\"  />";
                }
                else if (cate == ".flv" || cate == ".avi" || cate == ".mp4" || cate == ".rmvb") {
                    ico = "<img border=\"0\" src=\"/Themes/Images/32/movies.png\" height=\"32\" width=\"32\"  />";
                }
                else {
                    ico = "<img border=\"0\" src=\"/Themes/Images/32/Unknown.png\" height=\"32\" width=\"32\"  />";
                }
                $("#" + id).html("<a href='" + path + "' class='downText' title='点击下载'>" + ico + title + "</a>");
            }
        }
    };
    function getavplay(id, path) {
        /// <summary>
        /// 获得播放器，播放视频
        /// </summary>
        var varobj = {
            f: path,
            c: 0,
            b: 0,
            p: 1,
            e: 0,
            h: 3
        };
        var params = { bgcolor: '#000', allowFullScreen: true, allowScriptAccess: 'always', wmode: 'opaque' };
        var video = [varobj.f + '->video/mp4'];
        //以下为新方法
        CKobject.embed('/Training/Learn/m/ckplayer/ckplayer.swf', id, 'ckplayer_a1', '100%', '100%', false, varobj, video);
    }
    function getflash(id, path) {
        /// <summary>
        /// 获得FLASH
        /// </summary>
        var swfVersionStr = "10.0.0";
        var xiSwfUrlStr = "/live/playerProductInstall.swf";
        var params = { bgcolor: '#000', allowFullScreen: true, allowScriptAccess: 'always', wmode: 'opaque' };
        swfobject.embedSWF(path, id, "100%", "100%",
                swfVersionStr, xiSwfUrlStr,
                null, params, null);
    }
    function getmp3(id, path) {
        /// <summary>
        /// 获得mp3
        /// </summary>
        if (typeof (Worker) !== "undefined") {
            var swfVersionStr = "10.0.0";
            var xiSwfUrlStr = "/live/playerProductInstall.swf";
            var flashvars = {
                mp3: path,
                showvolume: 1
            };
            var params = { bgcolor: '#000', allowFullScreen: true, allowScriptAccess: 'always', wmode: 'opaque' };
            swfobject.embedSWF("/live/player_mp3_maxi.swf", id, "200", "20",
               swfVersionStr, xiSwfUrlStr,
               flashvars, params, null);
        } else {
            $("#" + id).html("<audio controls=\"controls\"><source src=\"" + path + "\" type=\"audio/mpeg\"></audio>");
        }
    }
    function getFileExt(str) {
        /// <summary>
        ///    根据文件路径获得文件后缀名
        /// </summary>
        /// <returns type="void" />
        var d = /\.[^\.]+$/.exec(str);
        if (d != null && d != "") {
            return d.toString().toLowerCase(); //转化为小写字母
        } else {
            return "";
        }
    }


    window.path2html = path2html;
})(window);