/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.appication;

import com.unclezs.novel.app.framework.appication.SceneNavigateBundle;
import com.unclezs.novel.app.framework.appication.SceneView;
import com.unclezs.novel.app.framework.components.StageDecorator;
import com.unclezs.novel.app.framework.core.AppContext;
import com.unclezs.novel.app.framework.util.ResourceUtils;
import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseApplication
extends Application {
    private static final Logger log = LoggerFactory.getLogger(BaseApplication.class);
    public static final String FX_THREAD_NAME = "FX";
    public static final String APPLICATION_STYLESHEET = "css/application.css";
    protected SceneView<? extends Region> currentView;
    protected double stageX = -1.0;
    protected double stageY = -1.0;
    private Stage stage;

    public static void destroy() {
        AppContext.getInstance().destroy();
    }

    public abstract SceneView<? extends Region> getIndexView();

    public void init() throws Exception {
        Thread.currentThread().setName(FX_THREAD_NAME);
    }

    public void start(Stage stage) throws Exception {
        this.stage = stage;
        AppContext.getInstance().setPrimaryStage(stage);
        this.loadSceneView(this.getIndexView());
        this.initScene();
        this.getIndexView().onShow(new SceneNavigateBundle());
    }

    public void navigate(Class<? extends SceneView<? extends Region>> viewClass) {
        this.navigate(viewClass, null);
    }

    public void navigate(Class<? extends SceneView<? extends Region>> viewClass, SceneNavigateBundle bundle) {
        if (this.currentView != null) {
            this.currentView.onHidden();
        }
        SceneView<? extends Region> sceneView = AppContext.getView(viewClass);
        this.loadSceneView(sceneView);
        if (this.stage.isShowing()) {
            this.stage.hide();
        }
        if (bundle == null) {
            bundle = new SceneNavigateBundle();
            bundle.setFrom(sceneView.getClass().getName());
        }
        this.initScene();
        sceneView.onShow(bundle);
        this.stage.show();
    }

    private void loadSceneView(SceneView<? extends Region> sceneView) {
        this.currentView = sceneView;
        if (((Region)sceneView.getRoot()).getScene() == null) {
            sceneView.setApp(this);
            if (sceneView.getRoot() instanceof StageDecorator) {
                ((StageDecorator)sceneView.getRoot()).setStage(this.stage, sceneView);
            }
            Scene scene = new Scene((Parent)sceneView.getRoot(), (Paint)Color.TRANSPARENT);
            scene.getStylesheets().setAll((Object[])new String[]{ResourceUtils.externalForm(APPLICATION_STYLESHEET)});
            sceneView.onCreated();
        }
    }

    private void initScene() {
        this.stage.setScene(((Region)this.currentView.getRoot()).getScene());
        this.stage.setMinWidth(((Region)this.currentView.getRoot()).getMinWidth());
        this.stage.setMinHeight(((Region)this.currentView.getRoot()).getMinHeight());
        if (((Region)this.currentView.getRoot()).getWidth() == 0.0) {
            this.stage.setHeight(((Region)this.currentView.getRoot()).getPrefHeight());
            this.stage.setWidth(((Region)this.currentView.getRoot()).getPrefWidth());
        } else {
            this.stage.setHeight(((Region)this.currentView.getRoot()).getHeight());
            this.stage.setWidth(((Region)this.currentView.getRoot()).getWidth());
        }
        double x = this.stage.getX();
        double y = this.stage.getY();
        if (this.stageX > 0.0 && this.stageY > 0.0) {
            this.stage.setX(this.stageX);
            this.stage.setY(this.stageY);
        }
        this.stageX = x;
        this.stageY = y;
        this.onSceneChange(((Region)this.currentView.getRoot()).getScene());
    }

    public void onSceneChange(Scene scene) {
    }
}

