/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.components;

import cn.hutool.core.text.CharSequenceUtil;
import com.jfoenix.controls.JFXAlert;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialogLayout;
import com.unclezs.novel.app.framework.components.icon.Icon;
import com.unclezs.novel.app.framework.components.icon.IconButton;
import com.unclezs.novel.app.framework.components.icon.IconFont;
import com.unclezs.novel.app.framework.core.AppContext;
import com.unclezs.novel.app.framework.support.LocalizedSupport;
import com.unclezs.novel.app.framework.util.NodeHelper;
import com.unclezs.novel.app.framework.util.ReflectUtils;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.stage.Window;

public class ModalBox
extends JFXAlert<Object>
implements LocalizedSupport {
    public static final String BUNDLE_NAME = "widgets.modal";
    private final JFXDialogLayout layout = new JFXDialogLayout();
    private final JFXButton cancel = new JFXButton(this.localized("cancel"));
    private JFXButton submit;
    private Icon icon;
    private BooleanSupplier successStateSupplier;

    private ModalBox() {
        this((Window)AppContext.getInstance().getPrimaryStage());
    }

    private ModalBox(Type type, String titleKey) {
        this();
        this.layout.getStyleClass().add((Object)type.name().toLowerCase());
        this.icon = NodeHelper.addClass(new Icon((Object)type.iconFont), "message-icon");
        if (titleKey != null) {
            this.title(this.localized(titleKey));
        }
    }

    private ModalBox(Window window) {
        super(window);
        this.cancel.setOnMouseClicked(event -> this.closeModal());
        this.layout.getActions().add((Object)this.cancel);
        this.setOverlayClose(false);
        this.setContent(new Node[]{this.layout});
    }

    public static ModalBox none() {
        return new ModalBox(Type.NONE, null);
    }

    public static ModalBox info() {
        return new ModalBox(Type.INFO, "info");
    }

    public static ModalBox warn() {
        return new ModalBox(Type.WARN, "warn");
    }

    public static ModalBox error() {
        return new ModalBox(Type.ERROR, "error");
    }

    public static ModalBox success() {
        return new ModalBox(Type.SUCCESS, "success");
    }

    public static ModalBox confirm(Consumer<Boolean> callback) {
        return new ModalBox(Type.CONFIRM, "confirm").createConfirm(callback);
    }

    public static ModalBox input(Consumer<String> callback) {
        return ModalBox.input("", "", callback);
    }

    public static ModalBox input(String prompt, Consumer<String> callback) {
        return ModalBox.input("", prompt, callback);
    }

    public static ModalBox input(String init, String prompt, Consumer<String> callback) {
        return new ModalBox().createInput(init, prompt, callback);
    }

    public ModalBox message(String msg) {
        return this.message(msg, null);
    }

    public ModalBox message(String msg, Icon icon) {
        if (icon != null) {
            this.icon = icon;
        }
        Label msgLabel = NodeHelper.addClass(new Label(msg, (Node)this.icon), new String[0]);
        this.layout.setBody(new Node[]{msgLabel});
        return this;
    }

    public ModalBox disabledAnimateClose() {
        ReflectUtils.setFieldValue("animateClosing", this, false);
        return this;
    }

    public ModalBox body(Node node) {
        this.layout.setBody(new Node[]{node});
        return this;
    }

    public ModalBox title(String title) {
        this.layout.setHeading(new Node[]{new Label(title)});
        return this;
    }

    public ModalBox success(BooleanSupplier successStateSupplier) {
        this.successStateSupplier = successStateSupplier;
        return this;
    }

    public ModalBox cancel(String text) {
        this.cancel.setText(text);
        return this;
    }

    public ModalBox submit(String text) {
        if (CharSequenceUtil.isNotBlank((CharSequence)text)) {
            if (this.submit == null) {
                this.submit = NodeHelper.addClass(new IconButton(text), "btn-submit");
                this.layout.getActions().add(0, (Object)this.submit);
            } else {
                this.submit.setText(text);
            }
        }
        return this;
    }

    private ModalBox createInput(String init, String prompt, Consumer<String> callback) {
        TextField input = new TextField(init);
        if (CharSequenceUtil.isBlank((CharSequence)prompt)) {
            input.setPromptText(this.localized("input.prompt"));
        }
        this.submitButton().setOnMouseClicked(event -> {
            callback.accept(input.getText());
            this.closeModal();
        });
        this.layout.setBody(new Node[]{input});
        return this;
    }

    private ModalBox createConfirm(Consumer<Boolean> callback) {
        this.submitButton().setOnMouseClicked(event -> {
            this.setResult(true);
            callback.accept(true);
            this.closeModal();
        });
        this.cancel.setOnMouseClicked(event -> {
            this.setResult(false);
            callback.accept(false);
            this.closeModal();
        });
        return this;
    }

    private JFXButton submitButton() {
        if (this.submit == null) {
            this.submit(this.localized("submit"));
        }
        return this.submit;
    }

    public void closeModal() {
        if (this.successStateSupplier != null && !this.successStateSupplier.getAsBoolean()) {
            return;
        }
        this.hideWithAnimation();
    }

    @Override
    public String getBundleName() {
        return BUNDLE_NAME;
    }

    public JFXDialogLayout getLayout() {
        return this.layout;
    }

    public static enum Type {
        ERROR(IconFont.ERROR),
        WARN(IconFont.WARN),
        SUCCESS(IconFont.SUCCESS),
        INFO(IconFont.INFO),
        CONFIRM(IconFont.CONFIRM),
        NONE(null);

        IconFont iconFont;

        private Type(IconFont iconFont) {
            this.iconFont = iconFont;
        }
    }
}

