/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.components;

import com.unclezs.novel.app.framework.components.ImageViewPlus;
import com.unclezs.novel.app.framework.components.icon.Icon;
import com.unclezs.novel.app.framework.components.icon.IconButton;
import com.unclezs.novel.app.framework.components.icon.IconFont;
import com.unclezs.novel.app.framework.support.LocalizedSupport;
import com.unclezs.novel.app.framework.util.NodeHelper;
import com.unclezs.novel.app.framework.util.PlatformUtils;
import javafx.beans.DefaultProperty;
import javafx.event.Event;
import javafx.geometry.BoundingBox;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

@DefaultProperty(value="content")
public class StageDecorator
extends StackPane
implements LocalizedSupport {
    public static final String STAGE_DECORATOR = "stage-decorator";
    public static final String STAGE_DECORATOR_ROOT = "stage-decorator-root";
    public static final String STAGE_DECORATOR_HEADER = "stage-decorator-header";
    public static final String STAGE_DECORATOR_LOGO = "stage-decorator-logo";
    public static final String STAGE_DECORATOR_ACTIONS = "stage-decorator-actions";
    public static final String STAGE_DECORATOR_LOGO_ICON = "stage-decorator-logo-icon";
    public static final String STAGE_DECORATOR_LOGO_TITLE = "stage-decorator-logo-title";
    public static final String STAGE_DECORATOR_ACTION_SEPARATOR = "stage-decorator-action-separator";
    public static final String STAGE_DECORATOR_ACTIONS_EXIT = "stage-decorator-actions-exit";
    public static final String HIDDEN_HEADER = "hidden-header";
    public static final String STAGE_DECORATOR_CONTENT = "stage-decorator-content";
    public static final int CLICK_COUNT_TO_MAX_WINDOW = 2;
    private static final Border DEFAULT_BORDER = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.TRANSPARENT, BorderStrokeStyle.NONE, CornerRadii.EMPTY, new BorderWidths(4.0))});
    private static final Insets DEFAULT_PADDING = new Insets(10.0);
    private Stage stage;
    private StackPane root;
    private HBox logoBox;
    private ImageViewPlus logoImage;
    private Label titleLabel;
    private HBox actions;
    private HBox header;
    private Node content;
    private double xOffset = 0.0;
    private double yOffset = 0.0;
    private double initX;
    private double initY;
    private double initWidth = -1.0;
    private double initHeight = -1.0;
    private double initStageX = -1.0;
    private double initStageY = -1.0;
    private boolean allowMove = false;
    private boolean isDragging = false;
    private Rectangle originalBox;
    private IconButton btnMax;
    private boolean maximized = false;
    private boolean theme;
    private boolean setting;
    private boolean max;
    private boolean min;
    private String logo;
    private String title;
    private ActionHandler actionHandler;

    public StageDecorator() {
        NodeHelper.addClass(this, STAGE_DECORATOR);
        this.createContainer();
        this.initStageBehavior();
    }

    public StageDecorator(Stage stage, ActionHandler actionHandler, boolean theme, boolean setting, boolean max, boolean min) {
        this();
        this.theme = theme;
        this.setting = setting;
        this.max = max;
        this.min = min;
        this.setStage(stage, actionHandler);
    }

    private void initialize() {
        if (!this.stage.isShowing()) {
            this.stage.initStyle(StageStyle.TRANSPARENT);
        }
        this.createActions();
    }

    @Override
    public String getBundleName() {
        return "widgets.stage-decorator";
    }

    private void createContainer() {
        this.logoBox = NodeHelper.addClass(new HBox(), STAGE_DECORATOR_LOGO);
        this.actions = NodeHelper.addClass(new HBox(), STAGE_DECORATOR_ACTIONS);
        HBox.setHgrow((Node)this.actions, (Priority)Priority.ALWAYS);
        this.header = NodeHelper.addClass(new HBox(new Node[]{this.logoBox, this.actions}), STAGE_DECORATOR_HEADER);
        StackPane.setAlignment((Node)this.header, (Pos)Pos.TOP_CENTER);
        this.root = NodeHelper.addClass(new StackPane(new Node[]{this.header}), STAGE_DECORATOR_ROOT);
        this.getChildren().setAll((Object[])new Node[]{this.root});
    }

    private void initStageBehavior() {
        this.root.addEventFilter(MouseEvent.MOUSE_PRESSED, this::updateInitMouseValues);
        this.header.addEventFilter(MouseEvent.MOUSE_PRESSED, this::updateInitMouseValues);
        this.root.addEventFilter(MouseEvent.MOUSE_MOVED, this::showDragCursorOnTheBorder);
        this.root.addEventFilter(MouseEvent.MOUSE_RELEASED, e -> {
            this.isDragging = false;
        });
        this.root.addEventFilter(MouseEvent.MOUSE_DRAGGED, this::onStageDragged);
        this.setOnMouseClicked(e -> {
            if (e.getTarget().equals(this.root) && this.getCursor().equals(Cursor.DEFAULT)) {
                this.stage.toBack();
            }
        });
        this.header.addEventFilter(MouseEvent.MOUSE_ENTERED, e -> {
            this.allowMove = true;
        });
        this.header.addEventFilter(MouseEvent.MOUSE_EXITED, e -> {
            this.allowMove = this.isDragging;
        });
    }

    private void createActions() {
        if (this.theme) {
            IconButton btnTheme = new IconButton(IconFont.THEME, this.localized("decorator.theme"));
            this.actions.getChildren().add((Object)btnTheme);
            btnTheme.setOnMouseClicked(e -> this.actionHandler.onTheme(this, btnTheme));
        }
        if (this.setting) {
            IconButton btnSetting = new IconButton(null, IconFont.MENU, this.localized("decorator.setting"));
            this.actions.getChildren().addAll((Object[])new Node[]{btnSetting, (Node)NodeHelper.addClass(new Pane(), STAGE_DECORATOR_ACTION_SEPARATOR)});
            btnSetting.setOnMouseClicked(e -> this.actionHandler.onSetting(this, btnSetting));
        }
        if (this.min) {
            IconButton btnMin = new IconButton(null, IconFont.MIN, this.localized("decorator.min"));
            btnMin.setOnAction(action -> this.stage.setIconified(true));
            this.actions.getChildren().add((Object)btnMin);
        }
        if (this.max) {
            Icon resizeMaxIcon = new Icon((Object)IconFont.MAX);
            Icon resizeMinIcon = new Icon((Object)IconFont.MAX_RESTORE);
            this.btnMax = new IconButton();
            this.btnMax.setTip(this.localized("decorator.max"));
            this.btnMax.setIcon(resizeMaxIcon);
            this.btnMax.setOnAction(action -> this.maximize(resizeMinIcon, resizeMaxIcon));
            this.header.setOnMouseClicked(mouseEvent -> {
                if (mouseEvent.getClickCount() >= 2) {
                    this.btnMax.fire();
                }
            });
            this.actions.getChildren().add((Object)this.btnMax);
        }
        IconButton btnClose = NodeHelper.addClass(new IconButton(null, IconFont.EXIT, this.localized("decorator.exit")), STAGE_DECORATOR_ACTIONS_EXIT);
        btnClose.setOnMouseClicked(e -> this.actionHandler.onClose(this, btnClose));
        this.actions.getChildren().add((Object)btnClose);
    }

    public Stage getStage() {
        return this.stage;
    }

    public void setStage(Stage stage, ActionHandler handler) {
        this.stage = stage;
        this.actionHandler = handler;
        this.initialize();
    }

    public void setLogo(String logoImagePath) {
        if (this.logo == null) {
            this.logoImage = NodeHelper.addClass(new ImageViewPlus(), STAGE_DECORATOR_LOGO_ICON);
            this.logoBox.getChildren().add(0, (Object)this.logoImage);
        }
        this.logo = logoImagePath;
        this.logoImage.setImage(new Image(logoImagePath));
    }

    public void setTitle(String titleText) {
        if (this.title == null) {
            this.titleLabel = NodeHelper.addClass(new Label(), STAGE_DECORATOR_LOGO_TITLE);
            this.logoBox.getChildren().add((Object)this.titleLabel);
        }
        this.title = titleText;
        this.titleLabel.setText(titleText);
    }

    public Node getContent() {
        return this.content;
    }

    public void setContent(Node content) {
        if (this.content != null) {
            this.root.getChildren().remove((Object)content);
        }
        this.root.getChildren().add(0, (Object)content);
        this.content = content;
        if (!this.content.getStyleClass().contains((Object)STAGE_DECORATOR_CONTENT)) {
            this.content.getStyleClass().add((Object)STAGE_DECORATOR_CONTENT);
        }
    }

    public void updateInitMouseValues(MouseEvent mouseEvent) {
        this.initStageX = this.stage.getX();
        this.initStageY = this.stage.getY();
        this.initWidth = this.stage.getWidth();
        this.initHeight = this.stage.getHeight();
        this.initX = mouseEvent.getScreenX();
        this.initY = mouseEvent.getScreenY();
        this.xOffset = mouseEvent.getSceneX();
        this.yOffset = mouseEvent.getSceneY();
    }

    public void showDragCursorOnTheBorder(MouseEvent mouseEvent) {
        if (this.stage.isFullScreen() || this.maximized) {
            this.setCursor(Cursor.DEFAULT);
            return;
        }
        if (!this.stage.isResizable()) {
            return;
        }
        double x = mouseEvent.getX();
        double y = mouseEvent.getY();
        if (this.root.getBorder() != null && !this.root.getBorder().getStrokes().isEmpty()) {
            double borderWidth = this.root.snappedLeftInset();
            if (this.isRightEdge(x)) {
                if (y < borderWidth) {
                    this.setCursor(Cursor.NE_RESIZE);
                } else if (y > this.getHeight() - borderWidth) {
                    this.setCursor(Cursor.SE_RESIZE);
                } else {
                    this.setCursor(Cursor.E_RESIZE);
                }
            } else if (this.isLeftEdge(x)) {
                if (y < borderWidth) {
                    this.setCursor(Cursor.NW_RESIZE);
                } else if (y > this.getHeight() - borderWidth) {
                    this.setCursor(Cursor.SW_RESIZE);
                } else {
                    this.setCursor(Cursor.W_RESIZE);
                }
            } else if (this.isTopEdge(y)) {
                this.setCursor(Cursor.N_RESIZE);
            } else if (this.isBottomEdge(y)) {
                this.setCursor(Cursor.S_RESIZE);
            } else {
                this.setCursor(Cursor.DEFAULT);
            }
        }
    }

    private void onStageDragged(MouseEvent mouseEvent) {
        this.isDragging = true;
        if (!mouseEvent.isPrimaryButtonDown() || this.xOffset == -1.0 && this.yOffset == -1.0) {
            return;
        }
        if (this.stage.isFullScreen() || mouseEvent.isStillSincePress() || this.maximized) {
            return;
        }
        double newX = mouseEvent.getScreenX();
        double newY = mouseEvent.getScreenY();
        double deltaX = newX - this.initX;
        double deltaY = newY - this.initY;
        Cursor cursor = this.getCursor();
        if (Cursor.E_RESIZE.equals(cursor)) {
            this.setStageWidth(this.initWidth + deltaX);
            mouseEvent.consume();
        } else if (Cursor.NE_RESIZE.equals(cursor)) {
            if (this.setStageHeight(this.initHeight - deltaY)) {
                this.stage.setY(this.initStageY + deltaY);
            }
            this.setStageWidth(this.initWidth + deltaX);
            mouseEvent.consume();
        } else if (Cursor.SE_RESIZE.equals(cursor)) {
            this.setStageWidth(this.initWidth + deltaX);
            this.setStageHeight(this.initHeight + deltaY);
            mouseEvent.consume();
        } else if (Cursor.S_RESIZE.equals(cursor)) {
            this.setStageHeight(this.initHeight + deltaY);
            mouseEvent.consume();
        } else if (Cursor.W_RESIZE.equals(cursor)) {
            if (this.setStageWidth(this.initWidth - deltaX)) {
                this.stage.setX(this.initStageX + deltaX);
            }
            mouseEvent.consume();
        } else if (Cursor.SW_RESIZE.equals(cursor)) {
            if (this.setStageWidth(this.initWidth - deltaX)) {
                this.stage.setX(this.initStageX + deltaX);
            }
            this.setStageHeight(this.initHeight + deltaY);
            mouseEvent.consume();
        } else if (Cursor.NW_RESIZE.equals(cursor)) {
            if (this.setStageWidth(this.initWidth - deltaX)) {
                this.stage.setX(this.initStageX + deltaX);
            }
            if (this.setStageHeight(this.initHeight - deltaY)) {
                this.stage.setY(this.initStageY + deltaY);
            }
            mouseEvent.consume();
        } else if (Cursor.N_RESIZE.equals(cursor)) {
            if (this.setStageHeight(this.initHeight - deltaY)) {
                this.stage.setY(this.initStageY + deltaY);
            }
            mouseEvent.consume();
        } else if (this.allowMove) {
            this.stage.setX(mouseEvent.getScreenX() - this.xOffset);
            this.stage.setY(mouseEvent.getScreenY() - this.yOffset);
            mouseEvent.consume();
        }
    }

    private boolean isRightEdge(double x) {
        double width = this.root.getWidth();
        return x < width && x > width - this.root.snappedLeftInset();
    }

    private boolean isTopEdge(double y) {
        return y >= 0.0 && y < this.root.snappedLeftInset();
    }

    private boolean isBottomEdge(double y) {
        double height = this.root.getHeight();
        return y < height && y > height - this.root.snappedLeftInset();
    }

    private boolean isLeftEdge(double x) {
        return x >= 0.0 && x < this.root.snappedLeftInset();
    }

    private boolean setStageWidth(double width) {
        if (width >= this.stage.getMinWidth() + this.root.snappedRightInset() + this.root.snappedLeftInset() && width >= this.header.getMinWidth()) {
            this.stage.setWidth(width);
            return true;
        }
        if (width >= this.stage.getMinWidth() && width <= this.header.getMinWidth()) {
            width = this.header.getMinWidth();
            this.stage.setWidth(width);
        }
        return false;
    }

    public void hideHeader() {
        if (!this.isHeaderHidden()) {
            this.header.getChildren().clear();
            this.getStyleClass().add((Object)HIDDEN_HEADER);
        }
    }

    public void showHeader() {
        if (this.isHeaderHidden()) {
            this.header.getChildren().setAll((Object[])new Node[]{this.logoBox, this.actions});
            this.getStyleClass().remove((Object)HIDDEN_HEADER);
        }
    }

    public boolean isHeaderHidden() {
        return this.header.getChildren().isEmpty();
    }

    private boolean setStageHeight(double height) {
        if (height >= this.stage.getMinHeight() + this.root.snappedRightInset() + this.root.snappedLeftInset() && height >= this.header.getHeight()) {
            this.stage.setHeight(height);
            return true;
        }
        if (height >= this.stage.getMinHeight() && height <= this.header.getHeight()) {
            height = this.header.getHeight();
            this.stage.setHeight(height);
        }
        return false;
    }

    private void maximize(Icon restoreIcon, Icon maxIcon) {
        boolean bl = this.maximized = !this.maximized;
        if (this.maximized) {
            this.setPadding(Insets.EMPTY);
            this.root.setBorder(Border.EMPTY);
            this.btnMax.setGraphic((Node)restoreIcon);
            this.btnMax.setTip(this.localized("decorator.restore"));
        } else {
            this.setPadding(DEFAULT_PADDING);
            this.root.setBorder(DEFAULT_BORDER);
            this.btnMax.setGraphic((Node)maxIcon);
            this.btnMax.setTip(this.localized("decorator.max"));
        }
        if (PlatformUtils.isMac()) {
            if (this.maximized) {
                this.originalBox = new Rectangle(this.stage.getX(), this.stage.getY(), this.stage.getWidth(), this.stage.getHeight());
                BoundingBox maximizedBox = new BoundingBox(0.0, 0.0, Screen.getPrimary().getVisualBounds().getWidth(), Screen.getPrimary().getVisualBounds().getHeight());
                this.stage.setX(maximizedBox.getMinX());
                this.stage.setY(maximizedBox.getMinY());
                this.stage.setWidth(maximizedBox.getWidth());
                this.stage.setHeight(maximizedBox.getHeight());
            } else {
                this.stage.setX(this.originalBox.getX());
                this.stage.setY(this.originalBox.getY());
                this.stage.setWidth(this.originalBox.getWidth());
                this.stage.setHeight(this.originalBox.getHeight());
                this.originalBox = null;
            }
        } else {
            this.stage.setMaximized(this.maximized);
        }
    }

    public boolean isTheme() {
        return this.theme;
    }

    public void setTheme(boolean theme) {
        this.theme = theme;
    }

    public boolean isSetting() {
        return this.setting;
    }

    public void setSetting(boolean setting) {
        this.setting = setting;
    }

    public boolean isMax() {
        return this.max;
    }

    public void setMax(boolean max) {
        this.max = max;
    }

    public boolean isMin() {
        return this.min;
    }

    public void setMin(boolean min) {
        this.min = min;
    }

    public String getLogo() {
        return this.logo;
    }

    public String getTitle() {
        return this.title;
    }

    public static interface ActionHandler {
        default public void onTheme(StageDecorator view, IconButton themeButton) {
        }

        default public void onSetting(StageDecorator view, IconButton settingButton) {
        }

        default public void onClose(StageDecorator view, IconButton closeButton) {
            view.stage.fireEvent((Event)new WindowEvent((Window)view.stage, WindowEvent.WINDOW_CLOSE_REQUEST));
        }
    }
}

