/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.components;

import com.unclezs.novel.app.framework.components.TabButton;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class TabGroup {
    private final List<TabButton> tabs = new ArrayList<TabButton>();
    private Consumer<TabButton> onSelected;

    public void selectTab(TabButton tabButton) {
        for (TabButton tab : this.tabs) {
            if (tab != tabButton) {
                tab.setSelected(false);
                continue;
            }
            if (this.onSelected == null) continue;
            this.onSelected.accept(tab);
        }
    }

    public TabButton findTab(Object userData) {
        for (TabButton tab : this.tabs) {
            if (!Objects.equals(userData, tab.getUserData())) continue;
            return tab;
        }
        return null;
    }

    public List<TabButton> getTabs() {
        return this.tabs;
    }

    public void setOnSelected(Consumer<TabButton> onSelected) {
        this.onSelected = onSelected;
    }
}

