/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.components.icon;

import com.unclezs.novel.app.framework.components.icon.IconFont;
import com.unclezs.novel.app.framework.util.ResourceUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.converter.SizeConverter;
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

public class Icon
extends Label {
    public static final String FONT_FAMILY = "iconfont";
    private static final String ICONFONT_PATH = "fonts/iconfont.ttf";
    private static final String[] DEFAULT_CSS_CLASSES = new String[]{"icon", "font-icon"};
    private static final Map<String, Character> ICONS = new HashMap<String, Character>(16);
    private final ObjectProperty<Object> value = new SimpleObjectProperty();
    private final StyleableDoubleProperty size = new SimpleStyleableDoubleProperty(StyleableProperties.SIZE, (Object)this, "size", -1.0){

        public void invalidated() {
            Icon.this.setFontSize(super.getValue());
        }
    };

    public Icon() {
        this.getStyleClass().setAll((Object[])DEFAULT_CSS_CLASSES);
        this.setTextAlignment(TextAlignment.LEFT);
        this.setAlignment(Pos.CENTER_LEFT);
        this.setFontFamily(FONT_FAMILY);
        this.value.addListener(x -> this.updateIcon());
        this.fontProperty().addListener(x -> this.updateIcon());
    }

    public Icon(Object value) {
        this();
        this.setValue(value);
    }

    public static void register(String name, char iconUnicode) {
        ICONS.put(name, Character.valueOf(iconUnicode));
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    public String getFontFamily() {
        return this.getFont().getFamily();
    }

    public void setFontFamily(String family) {
        if (!this.getFontFamily().equals(family)) {
            this.setFont(Font.font((String)family, (double)this.getFontSize()));
        }
    }

    public double getFontSize() {
        return this.getFont().getSize();
    }

    public void setFontSize(double size) {
        Font newFont = Font.font((String)this.getFontFamily(), (double)size);
        this.setFont(newFont);
    }

    public void setColor(Color color) {
        this.setTextFill((Paint)color);
    }

    public Object getValue() {
        return this.value.get();
    }

    public void setValue(Object iconValue) {
        this.value.set(iconValue);
    }

    private void updateIcon() {
        Object iconValue = this.getValue();
        if (iconValue != null) {
            if (iconValue instanceof IconFont) {
                this.setTextUnicode(((IconFont)((Object)iconValue)).getUnicode());
            } else if (iconValue instanceof Character) {
                this.setTextUnicode(((Character)iconValue).charValue());
            } else {
                String iconName = this.getValue().toString();
                Character iconUnicode = ICONS.get(iconName.toLowerCase());
                if (iconUnicode == null) {
                    this.setText(iconName);
                } else {
                    this.setTextUnicode(iconUnicode.charValue());
                }
            }
        }
    }

    private void setTextUnicode(char unicode) {
        this.setText(String.valueOf(unicode));
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Icon.getClassCssMetaData();
    }

    static {
        Font.loadFont((InputStream)ResourceUtils.stream(ICONFONT_PATH), (double)13.0);
        for (IconFont value : IconFont.values()) {
            Icon.register(value.name().toLowerCase(), value.getUnicode());
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<Icon, Number> SIZE = new CssMetaData<Icon, Number>("-fx-icon-size", SizeConverter.getInstance(), (Number)-1.0){

            public boolean isSettable(Icon control) {
                return control.size == null || !control.size.isBound();
            }

            public StyleableDoubleProperty getStyleableProperty(Icon control) {
                return control.size;
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Labeled.getClassCssMetaData());
            Collections.addAll(styleables, SIZE);
            CHILD_STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

