/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.components.sidebar;

import com.unclezs.novel.app.framework.components.SelectableButton;
import com.unclezs.novel.app.framework.components.sidebar.SidebarNavigateBundle;
import com.unclezs.novel.app.framework.components.sidebar.SidebarNavigation;
import com.unclezs.novel.app.framework.components.sidebar.SidebarView;
import com.unclezs.novel.app.framework.core.AppContext;
import com.unclezs.novel.app.framework.util.ReflectUtils;
import javafx.scene.Parent;

public class SidebarMenuItem
extends SelectableButton {
    private static final String DEFAULT_STYLE_CLASS = "sidebar-menu-item";
    private String view;
    private SidebarView<? extends Parent> sidebarView;
    private SidebarNavigation navigation;

    public SidebarMenuItem() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setOnAction(e -> {
            SidebarNavigateBundle bundle = new SidebarNavigateBundle();
            bundle.setMenuTrigger(true);
            if (this.sidebarView == null) {
                this.sidebarView = (SidebarView)AppContext.getView(ReflectUtils.forName(this.view));
                this.sidebarView.setNavigation(this.navigation);
            }
            this.navigation.navigate(this.sidebarView, bundle);
        });
    }

    public void setView(String view) {
        this.view = view;
        this.sidebarView = (SidebarView)AppContext.getView(ReflectUtils.forName(view));
    }

    public String getView() {
        return this.view;
    }

    public SidebarView<? extends Parent> getSidebarView() {
        return this.sidebarView;
    }

    public SidebarNavigation getNavigation() {
        return this.navigation;
    }

    public void setSidebarView(SidebarView<? extends Parent> sidebarView) {
        this.sidebarView = sidebarView;
    }

    public void setNavigation(SidebarNavigation navigation) {
        this.navigation = navigation;
    }
}

