/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.components.sidebar;

import com.unclezs.novel.app.framework.collection.SimpleObservableList;
import com.unclezs.novel.app.framework.components.sidebar.SidebarMenu;
import com.unclezs.novel.app.framework.components.sidebar.SidebarMenuItem;
import com.unclezs.novel.app.framework.components.sidebar.SidebarNavigateBundle;
import com.unclezs.novel.app.framework.components.sidebar.SidebarView;
import com.unclezs.novel.app.framework.core.AppContext;
import com.unclezs.novel.app.framework.executor.Executor;
import com.unclezs.novel.app.framework.util.NodeHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

@DefaultProperty(value="menus")
public class SidebarNavigation
extends HBox {
    private VBox sidebar;
    private StackPane content;
    private ObservableList<SidebarMenu> menus;
    private List<SidebarMenuItem> menuItems;
    private SidebarView<? extends Node> currentView;

    public SidebarNavigation() {
        this.init();
    }

    private void init() {
        this.getStyleClass().add((Object)"sidebar-nav");
        ScrollPane sidebarContainer = new ScrollPane();
        sidebarContainer.getStyleClass().add((Object)"sidebar");
        this.sidebar = NodeHelper.addClass(new VBox(), "sidebar-menus");
        sidebarContainer.setContent((Node)this.sidebar);
        this.menuItems = new ArrayList<SidebarMenuItem>();
        this.menus = new SimpleObservableList<SidebarMenu>(){

            @Override
            public void onAdd(SidebarMenu element) {
                SidebarNavigation.this.addMenu(element);
            }

            @Override
            public void onRemove(SidebarMenu element) {
                SidebarNavigation.this.removeMenu(element);
            }
        };
        this.content = new StackPane();
        this.content.getStyleClass().add((Object)"content");
        HBox.setHgrow((Node)this.content, (Priority)Priority.ALWAYS);
        this.getChildren().setAll((Object[])new Node[]{sidebarContainer, this.content});
    }

    public void removeMenu(SidebarMenu sidebarMenu) {
        this.sidebar.getChildren().removeAll(sidebarMenu.getMenuItems());
        this.menuItems.removeAll((Collection<?>)sidebarMenu.getMenuItems());
        if (sidebarMenu.getText() != null) {
            this.sidebar.getChildren().remove((Object)sidebarMenu);
        }
    }

    public void addMenu(SidebarMenu menu) {
        if (menu.getText() != null) {
            this.sidebar.getChildren().add((Object)menu);
        }
        this.menuItems.addAll((Collection<SidebarMenuItem>)menu.getMenuItems());
        this.sidebar.getChildren().addAll(menu.getMenuItems());
        for (SidebarMenuItem menuItem : menu.getMenuItems()) {
            if (menuItem.getSidebarView() != null) {
                menuItem.getSidebarView().setNavigation(this);
            }
            menuItem.setNavigation(this);
            if (!menuItem.isSelected()) continue;
            menuItem.fire();
        }
    }

    public void navigate(SidebarView<? extends Parent> view, SidebarNavigateBundle bundle) {
        if (bundle == null) {
            bundle = new SidebarNavigateBundle();
        }
        if (this.currentView != null) {
            String fromViewName = this.currentView.getClass().getName();
            String toViewName = view.getClass().getName();
            if (toViewName.equals(fromViewName)) {
                return;
            }
            this.currentView.onHidden();
            bundle.setFrom(fromViewName);
            this.menuItems.forEach(menuItem -> {
                if (menuItem.getView().equals(toViewName)) {
                    menuItem.setSelected(true);
                } else if (menuItem.isSelected()) {
                    menuItem.setSelected(false);
                }
            });
        }
        SidebarNavigateBundle finalBundle = bundle;
        Executor.runFx(() -> {
            view.onShow(finalBundle);
            this.content.getChildren().setAll((Object[])new Node[]{(Node)view.getRoot()});
            this.currentView = view;
            view.onShown(finalBundle);
        }, 40L);
    }

    public void navigate(Class<?> viewClass, SidebarNavigateBundle bundle) {
        SidebarView view = (SidebarView)AppContext.getView(viewClass);
        if (view.getNavigation() == null) {
            view.setNavigation(this);
        }
        this.navigate(view, bundle);
    }

    public void navigate(Class<?> viewClass) {
        this.navigate(viewClass, null);
    }

    public void navigate(SidebarView<? extends Parent> view) {
        this.navigate(view, null);
    }

    public VBox getSidebar() {
        return this.sidebar;
    }

    public StackPane getContent() {
        return this.content;
    }

    public ObservableList<SidebarMenu> getMenus() {
        return this.menus;
    }

    public List<SidebarMenuItem> getMenuItems() {
        return this.menuItems;
    }

    public SidebarView<? extends Node> getCurrentView() {
        return this.currentView;
    }

    public void setSidebar(VBox sidebar) {
        this.sidebar = sidebar;
    }

    public void setContent(StackPane content) {
        this.content = content;
    }

    public void setMenus(ObservableList<SidebarMenu> menus) {
        this.menus = menus;
    }

    public void setMenuItems(List<SidebarMenuItem> menuItems) {
        this.menuItems = menuItems;
    }

    public void setCurrentView(SidebarView<? extends Node> currentView) {
        this.currentView = currentView;
    }
}

