/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.core;

import com.unclezs.novel.app.framework.core.ContextDestroyedListener;
import com.unclezs.novel.app.framework.core.ViewFactory;
import com.unclezs.novel.app.framework.util.ReflectUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.stage.Stage;

public class AppContext {
    private static final AppContext CONTEXT = new AppContext();
    private final ViewFactory viewFactory = new ViewFactory();
    private final Map<String, Object> contextBeans = new HashMap<String, Object>();
    private final List<ContextDestroyedListener> destroyedListeners = new ArrayList<ContextDestroyedListener>();
    private Stage primaryStage;

    private AppContext() {
    }

    public static <T> T registerView(Class<?> clazz, T view) {
        return AppContext.CONTEXT.viewFactory.register(clazz, view);
    }

    public static <V> V getRoot(Class<?> clazz) {
        return AppContext.CONTEXT.viewFactory.getRoot(clazz);
    }

    public static <T> T getView(Class<T> clazz) {
        return AppContext.CONTEXT.viewFactory.getView(clazz);
    }

    public static <T> T getView(String className) {
        Class clazz = ReflectUtils.forName(className);
        return AppContext.CONTEXT.viewFactory.getView(clazz);
    }

    public static AppContext getInstance() {
        return CONTEXT;
    }

    public void register(Class<?> clazz, Object bean) {
        this.register(clazz.getName(), bean);
    }

    public void register(String id, Object bean) {
        this.contextBeans.put(id, bean);
    }

    public <T> T getBean(String id) {
        return (T)this.contextBeans.get(id);
    }

    public <T> T getBean(Class<T> beanClass) {
        return this.getBean(beanClass.getName());
    }

    public void destroy() {
        for (ContextDestroyedListener listener : this.destroyedListeners) {
            listener.contextDestroyed(CONTEXT);
        }
        this.viewFactory.destroy();
    }

    public void registerDestroyedListener(ContextDestroyedListener listener) {
        this.destroyedListeners.add(listener);
    }

    public void setPrimaryStage(Stage primaryStage) {
        this.primaryStage = primaryStage;
    }

    public Stage getPrimaryStage() {
        return this.primaryStage;
    }
}

