/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.core;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.unclezs.novel.app.framework.annotation.FxView;
import com.unclezs.novel.app.framework.core.View;
import com.unclezs.novel.app.framework.exception.FxException;
import com.unclezs.novel.app.framework.support.LocalizedSupport;
import com.unclezs.novel.app.framework.util.ReflectUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.fxml.FXMLLoader;

public class ViewFactory {
    public static final String ROOT_FIELD_NAME = "root";
    public static final String BUNDLE_FIELD_NAME = "bundle";
    private final Map<String, Object> views = new ConcurrentHashMap<String, Object>();

    public <T> T register(Class<?> clazz, T view) {
        FxView fxView = clazz.getAnnotation(FxView.class);
        if (this.views.get(clazz.getName()) != null && fxView.singleton()) {
            throw new FxException("view \u5df2\u7ecf\u88ab\u6ce8\u518c\uff0c{}", clazz);
        }
        this.views.put(clazz.getName(), view);
        if (CharSequenceUtil.isNotBlank((CharSequence)fxView.bundle())) {
            ReflectUtils.setFieldValue(BUNDLE_FIELD_NAME, view, LocalizedSupport.getBundle(fxView.bundle()));
        }
        return view;
    }

    public <V> V getRoot(Class<?> clazz) {
        Object cache = this.views.get(clazz.getName());
        if (cache == null) {
            return ((View)this.createFxmlView(clazz)).getRoot();
        }
        return (V)cache;
    }

    public <T> T getView(Class<?> clazz) {
        Object cache = this.views.get(clazz.getName());
        if (cache == null) {
            return this.createFxmlView(clazz);
        }
        return (T)cache;
    }

    private <T> T createFxmlView(Class<?> clazz) {
        FxView fxView = clazz.getAnnotation(FxView.class);
        Assert.notNull((Object)fxView, (String)"{}\u5fc5\u987b\u8981\u6807\u8bb0\u6ce8\u89e3@FxView", (Object[])new Object[]{clazz});
        Assert.notBlank((CharSequence)fxView.fxml(), (String)"@FxView\u7684fxml\u5c5e\u6027\u4e0d\u53ef\u4e3a\u7a7a {}", (Object[])new Object[]{clazz});
        try {
            FXMLLoader loader = new FXMLLoader();
            if (CharSequenceUtil.isNotBlank((CharSequence)fxView.bundle())) {
                loader.setResources(LocalizedSupport.getBundle(fxView.bundle()));
            }
            loader.setLocation(clazz.getResource(fxView.fxml()));
            Object root = loader.load();
            Object controller = loader.getController();
            ReflectUtils.setFieldValue(ROOT_FIELD_NAME, controller, root);
            this.views.put(clazz.getName(), controller);
            return (T)controller;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FxException("\u521b\u5efaFXML\u5931\u8d25\uff1a{}", fxView.fxml(), e);
        }
    }

    public void destroy() {
        this.views.values().forEach(view -> {
            if (view instanceof View) {
                ((View)view).onDestroy();
            }
        });
    }
}

