/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.executor;

import com.unclezs.novel.app.framework.executor.Executor;
import java.util.concurrent.ScheduledFuture;

public class DebounceTask {
    private final Long delay;
    private final Runnable runnable;
    private final boolean fx;
    private ScheduledFuture<?> scheduledFuture;

    public DebounceTask(Runnable runnable, Long delay) {
        this(runnable, delay, true);
    }

    public DebounceTask(Runnable runnable, Long delay, boolean fx) {
        this.runnable = runnable;
        this.delay = delay;
        this.fx = fx;
    }

    public static DebounceTask build(Runnable runnable, Long delay) {
        return new DebounceTask(runnable, delay);
    }

    public static DebounceTask build(Runnable runnable, Long delay, boolean fx) {
        return new DebounceTask(runnable, delay, fx);
    }

    public void run() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        this.scheduledFuture = Executor.run(() -> {
            this.scheduledFuture = null;
            if (this.fx) {
                Executor.runFxAndWait(this.runnable);
            } else {
                Executor.run(this.runnable);
            }
        }, this.delay);
    }
}

