/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.executor;

import com.unclezs.novel.app.framework.components.Loading;
import com.unclezs.novel.app.framework.executor.Executor;
import java.util.function.Consumer;
import javafx.concurrent.Task;

public abstract class FluentTask<R>
extends Task<R> {
    private final boolean loadingEnabled;
    private Loading loading;
    private Runnable finallyTask;

    protected FluentTask() {
        this(true);
    }

    protected FluentTask(boolean loadingEnabled) {
        this.loadingEnabled = loadingEnabled;
        if (loadingEnabled) {
            this.loading = new Loading();
            this.loading.setOnCloseRequest(event -> this.cancel());
            super.setOnRunning(e -> this.loading.show());
        }
        super.setOnSucceeded(e -> this.close());
        super.setOnFailed(e -> this.close());
        super.setOnCancelled(e -> this.close());
    }

    private void close() {
        if (this.loadingEnabled && this.loading.isShowing()) {
            this.loading.hideWithAnimation();
        }
        if (this.finallyTask != null) {
            this.finallyTask.run();
        }
    }

    public FluentTask<R> onSuccess(Consumer<R> callback) {
        super.setOnSucceeded(e -> {
            if (this.isCancelled()) {
                return;
            }
            callback.accept(this.getValue());
            this.close();
        });
        return this;
    }

    public FluentTask<R> onFailed(Consumer<Throwable> callback) {
        super.setOnFailed(e -> {
            callback.accept(this.getException());
            this.close();
        });
        return this;
    }

    public FluentTask<R> onCanceled(Runnable callback) {
        super.setOnCancelled(e -> {
            callback.run();
            this.close();
        });
        return this;
    }

    public FluentTask<R> onFinally(Runnable callback) {
        this.finallyTask = callback;
        return this;
    }

    public void start() {
        Executor.run((Runnable)((Object)this));
    }

    public void start(long delay) {
        Executor.run((Runnable)((Object)this), delay);
    }
}

