/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.support.fonts;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.URLUtil;
import java.io.File;
import javafx.scene.text.Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FontsLoader {
    private static final Logger log = LoggerFactory.getLogger(FontsLoader.class);

    public static void loadFonts(File dir) {
        if (!dir.exists()) {
            log.debug("\u5b57\u4f53\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff1a{}", (Object)dir);
            return;
        }
        String[] fonts = dir.list();
        if (fonts == null) {
            log.debug("\u672a\u53d1\u73b0\u5b57\u4f53\uff1a{}", (Object)dir);
            return;
        }
        for (String filename : fonts) {
            try {
                String fontUrl = URLUtil.getURL((File)FileUtil.file((File)dir, (String)filename)).toExternalForm();
                Font font = Font.loadFont((String)fontUrl, (double)Font.getDefault().getSize());
                if (font != null) {
                    log.debug("\u52a0\u8f7d{}\u5b57\u4f53\u6210\u529f", (Object)font.getFamily());
                    continue;
                }
                log.error("\u52a0\u8f7d{}\u5b57\u4f53\u5931\u8d25", (Object)filename);
            }
            catch (Exception e) {
                log.error("\u52a0\u8f7d{}\u5b57\u4f53\u5931\u8d25", (Object)filename, (Object)e);
            }
        }
    }

    private FontsLoader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

