/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.support.hotkey;

import cn.hutool.core.collection.CollectionUtil;
import com.unclezs.novel.app.framework.support.hotkey.HotKeyCombination;
import java.util.ArrayList;
import java.util.Set;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;

public class KeyRecorder {
    private static final Set<KeyCode> MODIFIERS = CollectionUtil.newHashSet((Object[])new KeyCode[]{KeyCode.CONTROL, KeyCode.SHIFT, KeyCode.META, KeyCode.ALT, KeyCode.WINDOWS, KeyCode.UNDEFINED});
    private boolean shift;
    private boolean ctrl;
    private boolean meta;
    private boolean alt;
    private KeyCode keyCode;
    private boolean effective;
    private HotKeyCombination combination;
    private String keyText;

    private void generate() {
        if (!this.effective) {
            return;
        }
        ArrayList<KeyCombination.Modifier> combinations = new ArrayList<KeyCombination.Modifier>();
        if (this.ctrl) {
            combinations.add(KeyCombination.CONTROL_DOWN);
        }
        if (this.shift) {
            combinations.add(KeyCombination.SHIFT_DOWN);
        }
        if (this.meta) {
            combinations.add(KeyCombination.META_DOWN);
        }
        if (this.alt) {
            combinations.add(KeyCombination.ALT_DOWN);
        }
        this.combination = new HotKeyCombination(this.keyCode, combinations.toArray(new KeyCombination.Modifier[0]));
    }

    public void reset() {
        this.keyText = null;
        this.alt = false;
        this.shift = false;
        this.ctrl = false;
        this.meta = false;
        this.effective = false;
    }

    public boolean record(KeyEvent event) {
        this.combination = null;
        StringBuilder text = new StringBuilder();
        this.ctrl = event.isControlDown();
        if (this.ctrl) {
            text.append(KeyCode.CONTROL.getName().toLowerCase()).append(" ");
        }
        this.shift = event.isShiftDown();
        if (this.shift) {
            text.append(KeyCode.SHIFT.getName().toLowerCase()).append(" ");
        }
        this.meta = event.isMetaDown();
        if (this.meta) {
            text.append(KeyCode.META.getName().toLowerCase()).append(" ");
        }
        this.alt = event.isAltDown();
        if (this.alt) {
            text.append(KeyCode.ALT.getName().toLowerCase()).append(" ");
        }
        boolean bl = this.effective = !MODIFIERS.contains(event.getCode());
        if (this.effective) {
            this.keyCode = event.getCode();
            text.append(this.keyCode.getName().toUpperCase());
        }
        this.keyText = text.toString();
        return this.effective;
    }

    public HotKeyCombination getCombination() {
        if (!this.effective) {
            return null;
        }
        if (this.combination == null) {
            this.generate();
        }
        return this.combination;
    }

    public boolean isEffective() {
        return this.effective;
    }

    public String getKeyText() {
        return this.keyText;
    }
}

