/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.util;

import cn.hutool.core.io.IORuntimeException;
import com.unclezs.novel.app.framework.components.Toast;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DesktopUtils {
    private static final Logger log = LoggerFactory.getLogger(DesktopUtils.class);

    public static void openBrowse(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (Exception e) {
            log.error("\u94fe\u63a5\u6253\u5f00\u5931\u8d25\uff1a{}", (Object)url, (Object)e);
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static void openDir(File dir) {
        if (!dir.exists()) {
            Toast.error("\u6587\u4ef6\u5939\u4e0d\u5b58\u5728");
        }
        try {
            Desktop.getDesktop().open(dir);
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u5939\u6253\u5f00\u5931\u8d25\uff1a{}", (Object)dir, (Object)e);
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static void copy(String text) {
        Clipboard cb = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        content.put((Object)DataFormat.PLAIN_TEXT, (Object)text);
        cb.setContent((Map)content);
    }

    private DesktopUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

