/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.util;

import com.unclezs.novel.app.framework.exception.FxException;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ScrollBar;

public final class NodeHelper {
    public static final String SELECTOR_SCROLL_BAR_VERTICAL = ".scroll-bar:vertical";
    public static final String SELECTOR_SCROLL_BAR_HORIZONTAL = ".scrollbar:horizontal";

    public static <T extends Styleable> T addClass(T node, String ... classNames) {
        if (node == null) {
            return null;
        }
        if (classNames != null) {
            node.getStyleClass().addAll((Object[])classNames);
        }
        return node;
    }

    public static <T extends Parent> T addStyleSheet(T node, String styleSheets, String ... classNames) {
        if (node == null) {
            return null;
        }
        if (styleSheets != null) {
            node.getStylesheets().add((Object)styleSheets);
        }
        NodeHelper.addClass(node, classNames);
        return node;
    }

    public static ScrollBar findVBar(Node node) {
        ScrollBar vBar = (ScrollBar)node.lookup(SELECTOR_SCROLL_BAR_VERTICAL);
        if (vBar != null) {
            return vBar;
        }
        throw new FxException("\u7eb5\u5411\u6eda\u52a8\u6761\u672a\u627e\u5230\uff1a{}", node);
    }

    public static ScrollBar findHBar(Node node) {
        ScrollBar vBar = (ScrollBar)node.lookup(SELECTOR_SCROLL_BAR_HORIZONTAL);
        if (vBar != null) {
            return vBar;
        }
        throw new FxException("\u6a2a\u5411\u6eda\u52a8\u6761\u672a\u627e\u5230\uff1a{}", node);
    }

    private NodeHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

